/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.utils.jface.help;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.base.utils.jface.help.IStylesheetProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.IXtextBrowserInformationControl;

public class HelpHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.XtextEditorHover.font")
    protected String fontSymbolicName = "org.eclipse.jdt.ui.javadocfont";
    protected CustomHoverControlCreator hoverControlCreator;
    protected DefaultEObjectHoverProvider.PresenterControlCreator presenterControlCreator;
    @Inject
    protected OpenInHelpAction openExternalDocumentationAction;
    @Inject(optional=true)
    protected IStylesheetProvider styleSheetProvider;

    protected String loadStyleSheet() {
        if (this.styleSheetProvider == null) {
            return null;
        }
        return this.styleSheetProvider.getCSS();
    }

    protected boolean hasHover(EObject o) {
        if (o instanceof Keyword) {
            return true;
        }
        return super.hasHover(o);
    }

    protected String getHoverInfoAsHtml(EObject o) {
        String hover;
        StringBuffer buffer = new StringBuffer();
        String documentation = this.getDocumentation(o);
        if (documentation != null && !documentation.isEmpty()) {
            buffer.append(documentation);
        }
        if ((hover = buffer.toString()) == null || "".equals(hover)) {
            return null;
        }
        return hover;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.presenterControlCreator == null) {
            this.presenterControlCreator = new CustomPresenterControlCreator();
        }
        return this.presenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.hoverControlCreator == null) {
            this.hoverControlCreator = new CustomHoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.hoverControlCreator;
    }

    public final class CustomHoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;

        public CustomHoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.jdt.ui.javadocfont";
                boolean areHoverDocsScrollable = true;
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, areHoverDocsScrollable){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return CustomHoverControlCreator.this.fInformationPresenterControlCreator;
                    }
                };
                HelpHoverProvider.this.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }
    }

    public class CustomPresenterControlCreator
    extends DefaultEObjectHoverProvider.PresenterControlCreator {
        public CustomPresenterControlCreator() {
            super((DefaultEObjectHoverProvider)HelpHoverProvider.this);
        }

        protected void configureControl(IXtextBrowserInformationControl control, ToolBarManager tbm, String font) {
            HelpHoverProvider.this.openExternalDocumentationAction.setEnabled(true);
            tbm.add((IAction)HelpHoverProvider.this.openExternalDocumentationAction);
            tbm.update(true);
        }
    }

    public static final class OpenInHelpAction
    extends Action {
        public static final String CONTEXTID = "openhelp.contextid";
        @Inject(optional=true)
        @Named(value="openhelp.contextid")
        protected String contextId;

        public OpenInHelpAction() {
            this.setText("Open user guide");
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP")));
        }

        public void run() {
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            if (this.contextId == null) {
                helpSystem.displayHelp();
            } else {
                helpSystem.displayHelp(this.contextId);
            }
        }
    }
}

