/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.simulation.scxml;

import com.google.inject.Inject;
import com.yakindu.sct.domain.scxml.simulation.BiDiExecutionContextAdapter;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension;
import org.apache.commons.scxml2.TriggerEvent;
import org.apache.commons.scxml2.model.EnterableState;
import org.apache.commons.scxml2.model.Transition;
import org.apache.commons.scxml2.model.TransitionTarget;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class SCTUnitBiDiExecutionContextAdapter
extends BiDiExecutionContextAdapter {
    @Inject(optional=true)
    private ILaunch launch;
    @Inject
    protected Measurement measurement;
    @Inject
    protected MeasurementExtension mExtension;

    public synchronized void onEntry(EnterableState it) {
        Vertex foundState;
        super.onEntry(it);
        if (this.launch != null && (foundState = this.findState(it.getId())) != null) {
            this.increaseVisited((EObject)foundState);
        }
    }

    public synchronized void onTransition(TransitionTarget source, TransitionTarget target, Transition transition, String string) {
        super.onTransition(source, target, transition, string);
        if (this.launch != null) {
            this.increaseVisited((EObject)this.findTransition(source, target, string));
        }
    }

    protected void raiseEvent(TriggerEvent it, ExecutionEvent ev) {
        try {
            this.executor.triggerEvent(it);
            ev.setRaised(false);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void increaseVisited(EObject o) {
        if (o == null) {
            return;
        }
        try {
            Measurement current = this.mExtension.forSubject(this.measurement, (Object)o);
            if (current != null) {
                this.mExtension.visits(current).increase();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void onVisit(Object subject) {
        if (subject != null) {
            this.mExtension.visits(this.mExtension.forSubject(this.measurement, subject)).increase();
        }
    }
}

