/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.inferrer;

import com.google.inject.Singleton;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.Guard;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.expressions.inferrer.ExpressionsTypeInferrer;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression;
import com.yakindu.sct.model.stext.stext.SubmachineReferenceExpression;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class STextTypeInferrer
extends ExpressionsTypeInferrer {
    public static final String GUARD = "The evaluation result of a guard expression must be of type boolean.";
    public static final String TIME_SPEC = "The evaluation result of a time expression must be of type integer.";

    public ITypeSystemInferrer.InferenceResult doInfer(Event e) {
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Guard e) {
        ITypeSystemInferrer.InferenceResult result = this.inferTypeDispatch((EObject)e.getExpression());
        this.assertIsSubType(result, this.getResultFor("boolean"), GUARD);
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(TimeEventSpec e) {
        ITypeSystemInferrer.InferenceResult result = this.inferTypeDispatch((EObject)e.getValue());
        this.assertIsSubType(result, this.getResultFor("integer"), TIME_SPEC);
        return this.inferTypeDispatch((EObject)result.getType());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Scope scope) {
        return this.getResultFor("void");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(SubmachineReferenceExpression submachineExpression) {
        return this.inferTypeDispatch((EObject)submachineExpression.getSubmachine());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ActiveStateReferenceExpression e) {
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(VariableDefinition e) {
        ITypeSystemInferrer.InferenceResult propInferredType = this.inferTypeDispatch((EObject)e.getTypeSpecifier(false));
        if (e.getInitialValue() == null) {
            this.assertNotType(propInferredType, "'void' is an invalid type for variables", new ITypeSystemInferrer.InferenceResult[]{this.getResultFor("void")});
            return propInferredType;
        }
        ITypeSystemInferrer.InferenceResult valueInferredType = this.inferTypeDispatch((EObject)e.getInitialValue());
        if (e.getTypeSpecifier(false) == null) {
            this.assertNotType(valueInferredType, "'void' is an invalid type for variables", new ITypeSystemInferrer.InferenceResult[]{this.getResultFor("void")});
            if (this.registry.isStringLiteral(valueInferredType.getType())) {
                valueInferredType = this.getResultFor("string");
            }
            return valueInferredType;
        }
        this.assertAssignable(propInferredType, valueInferredType, String.format("Cannot assign a value of type %s to a variable of type %s.", valueInferredType, propInferredType));
        return propInferredType;
    }

    protected ITypeSystemInferrer.InferenceResult getTargetTypeForVariableInit(ArgumentExpression exp) {
        VariableDefinition property;
        EObject container = exp.eContainer();
        if (container instanceof VariableDefinition && (property = (VariableDefinition)container).getInitialValue() == exp) {
            return this.inferTypeDispatch((EObject)property.getTypeSpecifier(false));
        }
        return super.getTargetTypeForVariableInit(exp);
    }
}

