/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.resource;

import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.resource.AbstractSCTResource;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;

public class SCTResourceValidatorImpl
extends ResourceValidatorImpl {
    protected void resolveProxies(Resource resource, CancelIndicator monitor) {
        if (resource instanceof AbstractSCTResource) {
            ((AbstractSCTResource)resource).resolveLazyCrossReferences(monitor);
        } else {
            super.resolveProxies(resource, monitor);
        }
    }

    protected IAcceptor<Issue> createAcceptor(List<Issue> result) {
        return new ListBasedMarkerAcceptor(result);
    }

    protected void validate(Resource resource, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        for (EObject ele : resource.getContents()) {
            if (!(ele instanceof Statechart) || monitor.isCanceled()) continue;
            this.validate(null, ele, mode, monitor, acceptor);
        }
    }

    protected static class ListBasedMarkerAcceptor
    implements IAcceptor<Issue> {
        private static final Pattern DUPLICATE_PROPERTY_IN_COMPLEX_TYPE = Pattern.compile("Duplicate Property.*in ComplexType");
        private static final Pattern DUPLICATE_PACKAGE_IN_PACKAGE = Pattern.compile("Duplicate Package.*in Package");
        private final List<Issue> result;

        protected ListBasedMarkerAcceptor(List<Issue> result) {
            this.result = result;
        }

        public void accept(Issue issue) {
            if (issue != null && !DUPLICATE_PROPERTY_IN_COMPLEX_TYPE.matcher(issue.getMessage()).find() && !DUPLICATE_PACKAGE_IN_PACKAGE.matcher(issue.getMessage()).find()) {
                this.result.add(issue);
            }
        }
    }
}

