/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.annotations.TypeAnnotations;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.stext.naming.StextNameProvider;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.INamesAreUniqueValidationHelper;
import org.eclipse.xtext.validation.NamesAreUniqueValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STextNamesValidator
extends NamesAreUniqueValidator {
    public static final ImmutableList<String> RESERVED = ImmutableList.of((Object)"enter", (Object)"exit", (Object)"runCycle", (Object)"isActive", (Object)"isStateActive", (Object)"isFinal");
    public static final ImmutableList<String> DEPRECATED = ImmutableList.of((Object)"if", (Object)"return");
    @Inject
    private INamesAreUniqueValidationHelper helper;
    @Inject
    private StextNameProvider fqnProvider;
    @Inject
    protected TypeAnnotations typeAnnotations;
    public static final String RESERVED_NAME_MSG = "The name '%s' is reserved, choose another name.";
    public static final String RESERVED_NAME_CODE = "reserved";
    public static final String DEPRECATED_NAME_MSG = "The use of '%s' as an identifier is deprecated, choose another name.";
    public static final String DEPRECATED_NAME_CODE = "deprecated";

    public void doCheckUniqueNames(Resource resource, CancelIndicator cancelIndicator) {
        ArrayList<NamedElement> candidates = new ArrayList<NamedElement>();
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof NamedElement)) continue;
            if (obj instanceof Package && obj.eContainer() == null) {
                iter.prune();
                continue;
            }
            candidates.add((NamedElement)obj);
        }
        this.helper.checkUniqueNames(Scopes.scopedElementsFor(candidates, (Function)this.fqnProvider), cancelIndicator, (ValidationMessageAcceptor)this);
    }

    @Check
    public void checkReservedNamed(InternalScope scope) {
        this.checkDeclarations(scope);
    }

    @Check
    public void checkReservedNamed(InterfaceScope scope) {
        if (scope.getName() == null || scope.getName().isEmpty()) {
            this.checkDeclarations(scope);
        }
    }

    protected void checkDeclarations(Scope scope) {
        List members = EcoreUtil2.getAllContentsOfType((EObject)scope, Declaration.class);
        for (Declaration declaration : members) {
            if (!RESERVED.contains((Object)declaration.getName())) continue;
            this.error(String.format(RESERVED_NAME_MSG, declaration.getName()), (EObject)declaration, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME, RESERVED_NAME_CODE, new String[0]);
        }
    }

    @Check
    public void checkDeprecatedNamed(InternalScope scope) {
        this.checkDeclarationsForDeprecatedNames(scope);
    }

    @Check
    public void checkDeprecatedNamed(InterfaceScope scope) {
        if (scope.getName() == null || scope.getName().isEmpty()) {
            this.checkDeclarationsForDeprecatedNames(scope);
        }
    }

    protected void checkDeclarationsForDeprecatedNames(Scope scope) {
        List members = EcoreUtil2.getAllContentsOfType((EObject)scope, Declaration.class);
        for (Declaration declaration : members) {
            if (!DEPRECATED.contains((Object)declaration.getName())) continue;
            this.warning(String.format(DEPRECATED_NAME_MSG, declaration.getName()), (EObject)declaration, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME, DEPRECATED_NAME_CODE, new String[0]);
        }
    }
}

