/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.EventSpec;
import com.yakindu.base.expressions.expressions.ReactionTrigger;
import com.yakindu.base.expressions.expressions.RegularEventSpec;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.types.Trigger;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.ReactionProperty;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.SgraphExtensions;
import com.yakindu.sct.model.stext.concepts.CompletionTransition;
import com.yakindu.sct.model.stext.concepts.ExitTransition;
import com.yakindu.sct.model.stext.stext.AlwaysEvent;
import com.yakindu.sct.model.stext.stext.DefaultTrigger;
import com.yakindu.sct.model.stext.stext.EntryPointSpec;
import com.yakindu.sct.model.stext.stext.ExitPointSpec;
import com.yakindu.sct.model.stext.stext.LocalReaction;
import com.yakindu.sct.model.stext.stext.SubmachineReferenceExpression;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TransitionValidator
extends STextBaseValidator {
    public static final String MULTIPLE_COMPLETION_TRANSITION = "Multiple completion/default transition. Only one completion/default transition is allowed from state '%s'";
    public static final String DEAD_TRANSITION_DUE_COMPLETION = "Dead transition from state '%s'. This transition is never taken due to the precedence of completion transition.";
    public static final String NOT_ALLOWED_LOCAL_REACTION = "Local reactions of state '%s' are never executed due to completion transition.";
    public static final String SOURCE_STATE_NOT_COMPLETABLE = "Dead transition. This completion transition is never taken because the source state '%s' is not completable.";
    public static final String INFINITE_CYCLE = "The completion transition of state '%s' results in an infinite cycle.";
    public static final String COMPLETION_TRANSITION_IGNORES_SUBMACHINE = "The completion transition of state '%s' will ignore the submachine state.";
    @Inject
    @Extension
    protected CompletionTransition _completionTransition;
    @Inject
    @Extension
    protected SgraphExtensions _sgraphExtensions;
    @Inject
    @Extension
    protected ExitTransition _exitTransition;
    public static final String DEAD_TRANSITION = "Dead transition. This transition can not be taken due to previous transition with '%s' trigger.";
    public static final String ALWAYS_TRUE_TRANSITION_USED = "Transition with '%s' should be evaluate as the last transition of the state as following transitions won't be evaluated. Change the transition order (in the Properties view).";
    public static final String TRANSITION_SOURCE_ISNT_VERTEX = "The source of the transition must be a vertex. First move the source and target of the transition to a Node. It can only be deleted after fixing the source/target!";
    public static final String TRANSITION_ENTRY_SPEC_NOT_COMPOSITE = "Target state '%s' isn't composite.";
    public static final String TRANSITION_EXIT_SPEC_NOT_COMPOSITE = "Source state '%s' isn't composite.";
    public static final String TRANSITION_EXIT_SPEC_ON_MULTIPLE_SIBLINGS = "ExitPointSpec '%s' can't be used on transition siblings.";
    public static final String TRANSITION_NOT_EXISTING_NAMED_EXIT_POINT = "Source state '%s' needs at least one region with the named exit point.";
    private static final String KEYWORD_ONCYCLE = "oncycle";
    private static final String KEYWORD_ALWAYS = "always";

    protected boolean resultsInfiniteCycle(Transition t, Vertex s, HashSet<Transition> traversedTransitions) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = tr -> this._completionTransition.isCompletionTransition((Transition)tr);
        Iterable outgoingCompletionTransitions = IterableExtensions.filter((Iterable)t.getTarget().getOutgoingTransitions(), (Functions.Function1)_function);
        boolean _xifexpression = false;
        Functions.Function1 _function_1 = it -> this._completionTransition.isCompletionTransition((Transition)it) && Objects.equals(it.getTarget(), s);
        boolean _exists = IterableExtensions.exists((Iterable)t.getTarget().getOutgoingTransitions(), (Functions.Function1)_function_1);
        if (_exists) {
            return true;
        }
        boolean _xifexpression_1 = false;
        Functions.Function1 _function_2 = it -> {
            boolean _contains = traversedTransitions.contains(it);
            return !_contains;
        };
        boolean _exists_1 = IterableExtensions.exists((Iterable)outgoingCompletionTransitions, (Functions.Function1)_function_2);
        if (_exists_1) {
            Iterables.addAll(traversedTransitions, (Iterable)outgoingCompletionTransitions);
            Functions.Function1 _function_3 = it -> this.resultsInfiniteCycle((Transition)it, s, traversedTransitions);
            return IterableExtensions.exists((Iterable)outgoingCompletionTransitions, (Functions.Function1)_function_3);
        }
        _xblockexpression = _xifexpression = (_xifexpression_1 = false);
        return _xblockexpression;
    }

    @Check(value=CheckType.FAST)
    public void completionTransitions(State state) {
        boolean _isLeaf;
        int _size_2;
        boolean _greaterThan;
        Functions.Function1 _function = it -> this._completionTransition.isCompletionTransition((Transition)it);
        List completionTransitions = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)state.getOutgoingTransitions(), (Functions.Function1)_function));
        if (IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)state.getIncomingTransitions(), intrans -> this._completionTransition.isCompletionTransition((Transition)intrans))) > 0 && IterableExtensions.exists((Iterable)completionTransitions, it -> this.resultsInfiniteCycle((Transition)it, it.getSource(), CollectionLiterals.newHashSet()))) {
            this.warning(String.format(INFINITE_CYCLE, state.getName()), (EObject)state, null, -1);
        }
        if (!state.isLeaf() && completionTransitions.size() > 0) {
            int _size_1;
            boolean _lessThan;
            Functions.Function1 _function_1 = r -> r.getVertices();
            Functions.Function1 _function_2 = v -> v instanceof FinalState;
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)state.getRegions(), (Functions.Function1)_function_1)), (Functions.Function1)_function_2));
            boolean bl = _lessThan = _size < (_size_1 = state.getRegions().size());
            if (_lessThan) {
                Consumer<Transition> _function_3 = it -> this.error(String.format(SOURCE_STATE_NOT_COMPLETABLE, it.getSource().getName()), (EObject)it, null, -1);
                completionTransitions.forEach(_function_3);
            }
        }
        if (state.isLeaf() && completionTransitions.size() > 0 && state.getScopes() != null && IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)state.getScopes(), s -> {
            EList _members = s.getMembers();
            return _members != null;
        }), s -> s.getMembers())), LocalReaction.class), lr -> ((ReactionTrigger)lr.getTrigger()).getTriggers().isEmpty() || !IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)((ReactionTrigger)lr.getTrigger()).getTriggers(), t -> t instanceof RegularEventSpec || t instanceof TimeEventSpec || t instanceof AlwaysEvent)).isEmpty())) > 0) {
            this.error(String.format(NOT_ALLOWED_LOCAL_REACTION, state.getName()), (EObject)state, null, -1);
        }
        boolean bl = _greaterThan = (_size_2 = completionTransitions.size()) > 1;
        if (_greaterThan) {
            Consumer<Transition> _function_4 = it -> this.error(String.format(MULTIPLE_COMPLETION_TRANSITION, it.getSource().getName()), (EObject)it, null, -1);
            completionTransitions.forEach(_function_4);
        }
        if (_isLeaf = state.isLeaf()) {
            Functions.Function1 _function_5 = t -> !completionTransitions.contains(t) && t.getTrigger() != null;
            Iterable regularTransitions = IterableExtensions.filter((Iterable)state.getOutgoingTransitions(), (Functions.Function1)_function_5);
            if (completionTransitions.size() == 1 && IterableExtensions.size((Iterable)regularTransitions) > 0) {
                Consumer<Transition> _function_6 = it -> this.warning(String.format(DEAD_TRANSITION_DUE_COMPLETION, it.getSource().getName()), (EObject)it, null, -1);
                regularTransitions.forEach(_function_6);
            }
        }
        Functions.Function1 _function_7 = it -> it.getMembers();
        Iterable submachineReferences = Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)state.getScopes(), (Functions.Function1)_function_7)), SubmachineReferenceExpression.class);
        if (!IterableExtensions.isEmpty((Iterable)submachineReferences) && !completionTransitions.isEmpty()) {
            this.warning(String.format(COMPLETION_TRANSITION_IGNORES_SUBMACHINE, state.getName()), (EObject)state, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAlwaysTransitionHasLowestPriority(RegularState state) {
        Iterator iterator = state.getOutgoingTransitions().iterator();
        Transition deadTransition = null;
        while (iterator.hasNext()) {
            EventSpec eventSpec;
            EList triggers;
            Transition transition = (Transition)iterator.next();
            Trigger trigger = transition.getTrigger();
            if (deadTransition != null) {
                this.warning(String.format(DEAD_TRANSITION, this.getTransitionDeclaration(deadTransition)), (EObject)transition, null, -1);
            }
            if (trigger instanceof DefaultTrigger && iterator.hasNext()) {
                this.warning(String.format(ALWAYS_TRUE_TRANSITION_USED, transition.getSpecification()), (EObject)transition, null, -1);
                if (deadTransition != null) continue;
                deadTransition = transition;
                continue;
            }
            if (!(trigger instanceof ReactionTrigger) || (triggers = ((ReactionTrigger)trigger).getTriggers()).size() != 1 || ((ReactionTrigger)trigger).getGuard() != null || !((eventSpec = (EventSpec)triggers.get(0)) instanceof AlwaysEvent) || !iterator.hasNext()) continue;
            this.warning(String.format(ALWAYS_TRUE_TRANSITION_USED, this.getTransitionDeclaration(transition)), (EObject)transition, null, -1);
            if (deadTransition != null) continue;
            deadTransition = transition;
        }
    }

    @Check(value=CheckType.FAST)
    public void checkEContainer(Transition transition) {
        if (!(transition.eContainer() instanceof Vertex) && this.hasNotationView(transition)) {
            this.error(TRANSITION_SOURCE_ISNT_VERTEX, (EObject)transition, null, -1);
        }
    }

    public boolean hasNotationView(Transition transition) {
        Functions.Function1 _function = it -> IteratorExtensions.toList((Iterator)it.eAllContents());
        Functions.Function1 _function_1 = it -> {
            EObject _element = it.getElement();
            return Objects.equals(_element, transition);
        };
        return IterableExtensions.exists((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)transition.eResource().getContents(), Diagram.class), (Functions.Function1)_function)), View.class), (Functions.Function1)_function_1);
    }

    @Check(value=CheckType.FAST)
    public void checkTransitionPropertySpec(Transition transition) {
        EList _properties = transition.getProperties();
        for (ReactionProperty property : _properties) {
            boolean _not_2;
            boolean _not_1;
            Vertex _source;
            if (property instanceof EntryPointSpec) {
                boolean _not;
                Vertex _target = transition.getTarget();
                if (!(_target instanceof State)) continue;
                Vertex _target_1 = transition.getTarget();
                State state = (State)_target_1;
                boolean _isComposite = state.isComposite();
                boolean bl = _not = !_isComposite;
                if (!_not) continue;
                this.warning(String.format(TRANSITION_ENTRY_SPEC_NOT_COMPOSITE, transition.getTarget().getName()), (EObject)transition, null, -1);
                continue;
            }
            if (!(property instanceof ExitPointSpec) || !((_source = transition.getSource()) instanceof State)) continue;
            Vertex _source_1 = transition.getSource();
            State state_1 = (State)_source_1;
            boolean _isComposite_1 = state_1.isComposite();
            boolean bl = _not_1 = !_isComposite_1;
            if (_not_1) {
                this.warning(String.format(TRANSITION_EXIT_SPEC_NOT_COMPOSITE, transition.getSource().getName()), (EObject)transition, null, -1);
                continue;
            }
            Functions.Function1 _function = t -> transition != t && this._exitTransition.isNamedExitTransition((Transition)t, ((ExitPointSpec)property).getExitpoint());
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)state_1.getOutgoingTransitions(), (Functions.Function1)_function));
            boolean bl2 = _not_2 = !_isEmpty;
            if (_not_2) {
                this.warning(String.format(TRANSITION_EXIT_SPEC_ON_MULTIPLE_SIBLINGS, ((ExitPointSpec)property).getExitpoint()), (EObject)transition, null, -1);
            }
            Functions.Function1 _function_1 = e -> ((ExitPointSpec)property).getExitpoint().equals(e.getName());
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._sgraphExtensions.getAllPseudoStates((Object)state_1), Exit.class), (Functions.Function1)_function_1));
            if (!_isEmpty_1) continue;
            this.error(String.format(TRANSITION_NOT_EXISTING_NAMED_EXIT_POINT, state_1.getName()), (EObject)transition, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAlwaysAndDefaultTransitionInChoices(Choice choice) {
        Trigger trigger;
        Transition transition;
        Transition deadTransition = null;
        EList outgoingTransitions = choice.getOutgoingTransitions();
        int size = outgoingTransitions.size();
        int deadTransitionIndex = 0;
        int i = 0;
        while (i < size) {
            EventSpec _get;
            EList triggers;
            transition = (Transition)outgoingTransitions.get(i);
            if (deadTransition != null) {
                this.warning(String.format(DEAD_TRANSITION, this.getTransitionDeclaration(deadTransition)), (EObject)transition, null, -1);
            }
            if ((trigger = transition.getTrigger()) instanceof ReactionTrigger && (triggers = ((ReactionTrigger)trigger).getTriggers()).size() == 1 && ((ReactionTrigger)trigger).getGuard() == null && (_get = (EventSpec)triggers.get(0)) instanceof AlwaysEvent) {
                if (i != size - 1) {
                    this.warning(String.format(ALWAYS_TRUE_TRANSITION_USED, transition.getSpecification()), (EObject)transition, null, -1);
                }
                if (deadTransition == null) {
                    deadTransition = transition;
                    deadTransitionIndex = i;
                }
            }
            ++i;
        }
        if (deadTransition != null) {
            i = 0;
            while (i < deadTransitionIndex) {
                transition = (Transition)outgoingTransitions.get(i);
                trigger = transition.getTrigger();
                if (trigger instanceof DefaultTrigger || trigger == null) {
                    this.warning(String.format(DEAD_TRANSITION, this.getTransitionDeclaration(deadTransition)), (EObject)transition, null, -1);
                }
                ++i;
            }
        }
    }

    protected String getTransitionDeclaration(Transition transition) {
        String specification = transition.getSpecification();
        boolean _contains = KEYWORD_ALWAYS.contains(specification);
        if (_contains) {
            return KEYWORD_ALWAYS;
        }
        boolean _contains_1 = KEYWORD_ONCYCLE.contains(specification);
        if (_contains_1) {
            return KEYWORD_ONCYCLE;
        }
        return specification;
    }
}

