/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ui.contentassist;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.GeneratorExtensions;
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import com.yakindu.sct.generator.genmodel.ui.PathToImageResolver;
import com.yakindu.sct.generator.genmodel.ui.contentassist.AbstractSGenProposalProvider;
import com.yakindu.sct.model.sgen.GeneratorModel;
import com.yakindu.sct.model.sgraph.Statechart;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SGenProposalProvider
extends AbstractSGenProposalProvider {
    @Inject
    private IScopeProvider scopeProvider;

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleEquals;
        EObject _currentModel = context.getCurrentModel();
        boolean bl = _tripleEquals = _currentModel == null;
        if (_tripleEquals) {
            super.lookupCrossReference(crossReference, context, acceptor);
            return;
        }
        EReference reference = GrammarUtil.getReference((CrossReference)crossReference, (EClass)context.getCurrentModel().eClass());
        if (reference == null) {
            super.lookupCrossReference(crossReference, context, acceptor);
            return;
        }
        IScope scope = this.scopeProvider.getScope(context.getCurrentModel(), reference);
        Functions.Function1 _function = desc -> {
            String _string = desc.getName().toString();
            boolean isThreadSafe = Objects.equals(_string, "ThreadSafeAccess");
            String container = desc.getUserData("featureContainer");
            boolean isGeneralFeatures = Objects.equals("GeneralFeatures", container);
            return !isThreadSafe || !isGeneralFeatures;
        };
        Iterable visibleProposals = IterableExtensions.filter((Iterable)scope.getAllElements(), (Functions.Function1)_function);
        for (IEObjectDescription candidate : visibleProposals) {
            boolean _not;
            boolean _canAcceptMoreProposals = acceptor.canAcceptMoreProposals();
            boolean bl2 = _not = !_canAcceptMoreProposals;
            if (_not) {
                return;
            }
            ICompletionProposal proposal = this.createCompletionProposal(candidate.getName().toString(), context);
            if (proposal == null) continue;
            acceptor.accept(proposal);
        }
    }

    @Override
    public void completeGeneratorEntry_Keyword(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        GeneratorModel generatorModel = (GeneratorModel)EcoreUtil2.getContainerOfType((EObject)model, GeneratorModel.class);
        Optional descriptor = GeneratorExtensions.getGeneratorDescriptor((String)generatorModel.getGeneratorId());
        boolean _isPresent = descriptor.isPresent();
        boolean bl = _not = !_isPresent;
        if (_not) {
            return;
        }
        ICompletionProposal proposal = this.createCompletionProposal(((IGeneratorDescriptor)descriptor.get()).getKeyword(), context);
        acceptor.accept(proposal);
    }

    @Override
    public void completeGeneratorModel_GeneratorId(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List descriptions = GeneratorExtensions.getGeneratorDescriptors();
        for (IGeneratorDescriptor desc : descriptions) {
            boolean _isPrimary = desc.isPrimary();
            if (!_isPrimary) continue;
            String _id = desc.getId();
            String _xifexpression = null;
            String _name = desc.getName();
            boolean _tripleNotEquals = _name != null;
            _xifexpression = _tripleNotEquals ? desc.getName() : "null";
            StyledString _styledString = new StyledString(_xifexpression);
            ICompletionProposal proposal = this.createCompletionProposal(_id, _styledString, PathToImageResolver.toImage(desc.getImagePath()), context);
            if (proposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
                configurable.setAdditionalProposalInfo((Object)desc.getDescription());
            }
            acceptor.accept(proposal);
        }
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedName, String shortName) {
        if (element instanceof Statechart) {
            return this.computeStyledString((Statechart)element, qualifiedName, shortName);
        }
        return super.getStyledDisplayString(element, qualifiedName, shortName);
    }

    protected StyledString computeStyledString(Statechart sct, String qualifiedName, String shortName) {
        StyledString firstPart = new StyledString(qualifiedName);
        StyledString secondPart = this.getPackageImportStyleString(EcoreUtil.getURI((EObject)sct));
        return firstPart.append(secondPart);
    }

    protected StyledString getPackageImportStyleString(URI uri) {
        String _xifexpression = null;
        boolean _isPlatform = uri.isPlatform();
        _xifexpression = _isPlatform ? uri.toPlatformString(true) : uri.toFileString();
        String filePath = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("- ");
        _builder.append(filePath, " ");
        GreyoutStyler _greyoutStyler = new GreyoutStyler();
        return new StyledString(_builder.toString(), (StyledString.Styler)_greyoutStyler);
    }

    public static class GreyoutStyler
    extends StyledString.Styler {
        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = Display.getDefault().getSystemColor(15);
        }
    }
}

