/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ui.wizard;

import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import java.util.Comparator;

public enum CoreGenerator {
    C("create::c"),
    Cpp("create::cpp"),
    Java("create::java");

    private String id;
    public static final Comparator<IGeneratorDescriptor> generatorOrder;

    static {
        generatorOrder = new Comparator<IGeneratorDescriptor>(){

            @Override
            public int compare(IGeneratorDescriptor o1, IGeneratorDescriptor o2) {
                int a = this.getPrio(o1);
                int b = this.getPrio(o2);
                int result = Integer.valueOf(a).compareTo(b);
                if (result == 0) {
                    result = o2.getName().compareTo(o1.getName());
                }
                return result;
            }

            private int getPrio(IGeneratorDescriptor o1) {
                try {
                    return CoreGenerator.parseId(o1.getId()).ordinal();
                }
                catch (IllegalArgumentException e) {
                    return Integer.MAX_VALUE;
                }
            }
        };
    }

    private CoreGenerator(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    static CoreGenerator parseId(String id) {
        if (CoreGenerator.Java.id.equals(id)) {
            return Java;
        }
        if (CoreGenerator.C.id.equals(id)) {
            return C;
        }
        if (CoreGenerator.Cpp.id.equals(id)) {
            return Cpp;
        }
        throw new IllegalArgumentException(String.format("No such generator id '%s'", id));
    }
}

