/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.sct.generator.c;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeAlias;
import com.yakindu.base.types.TypedElement;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.generator.c.extensions.FileNaming;
import com.yakindu.sct.generator.c.extensions.GenmodelEntries;
import com.yakindu.sct.generator.c.extensions.Naming;
import com.yakindu.sct.generator.c.types.CTypes;
import com.yakindu.sct.generator.core.artifacts.IContentTemplate;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.yet.sct.generator.c.CYETExtensions;
import com.yakindu.yet.sct.generator.c.YETNaming;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class StatechartTracerSource
implements IContentTemplate<ExecutionFlow> {
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    protected FileNaming _fileNaming;
    @Inject
    @Extension
    private CTypes _cTypes;
    @Inject
    @Extension
    private ITypeSystem _iTypeSystem;
    @Inject
    @Extension
    private YETNaming yetNaming;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private CYETExtensions _cYETExtensions;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;

    public String content(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("/* Implements a standard statechart trace handler which adapts to the");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* YET tracing library.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        CharSequence _includes = this.includes(flow, entry, locations);
        _builder.append((Object)_includes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        CharSequence _declarations = this.declarations(flow, entry, locations);
        _builder.append((Object)_declarations);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        CharSequence _implementations = this.implementations(flow, entry, locations);
        _builder.append((Object)_implementations);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder.toString();
    }

    protected CharSequence includes(ExecutionFlow flow, GeneratorEntry entry, @Extension IGenArtifactConfigurations locations) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"");
        String _relativeTo = locations.relativeTo(this._fileNaming.h(this.yetNaming.tracerModule(flow)), this._fileNaming.c(this.yetNaming.tracerModule(flow)));
        _builder.append(_relativeTo);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _relativeTo_1 = locations.relativeTo(this._fileNaming.h(this._fileNaming.metaModule(flow)), this._fileNaming.c(this.yetNaming.tracerModule(flow)));
        _builder.append(_relativeTo_1);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <string.h>");
        _builder.newLine();
        _builder.append("#include <stdlib.h>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence declarations(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef SC_UNUSED");
        _builder.newLine();
        _builder.append("#define SC_UNUSED(P) (void)(P)");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static ");
        String _name = this._cTypes.sc_string().name();
        _builder.append(_name);
        _builder.append(" default_scope_name = \"");
        String _name_1 = flow.getName();
        _builder.append(_name_1);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("static yet_value_serializer feature_value_serializer[");
        int _length = ((Object[])Conversions.unwrapArray(this._cYETExtensions.tracedTypedElements(flow), Object.class)).length;
        int _plus = _length + 1;
        _builder.append((Object)_plus);
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence serializeFunction(Type it, Type startType) {
        if (it == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("yet_serialize_void");
            return _builder;
        }
        boolean _isIntegerType = this.isIntegerType(it);
        if (_isIntegerType) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("yet_int_serializer_function(sizeof(");
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(startType);
            _builder_1.append(_targetLanguageName);
            _builder_1.append("), ");
            boolean _isSuperType = this._iTypeSystem.isSuperType(it, this._iTypeSystem.getType("unsigned integer"));
            boolean _not = !_isSuperType;
            _builder_1.append((Object)_not);
            _builder_1.append(")");
            return _builder_1;
        }
        boolean _haveCommonType = this._iTypeSystem.haveCommonType(it, this._iTypeSystem.getType("real"));
        if (_haveCommonType) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("yet_real_serializer_function(sizeof(");
            String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(startType);
            _builder_2.append(_targetLanguageName_1);
            _builder_2.append("))");
            return _builder_2;
        }
        boolean _haveCommonType_1 = this._iTypeSystem.haveCommonType(it, this._iTypeSystem.getType("boolean"));
        if (_haveCommonType_1) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("yet_serialize_bool");
            return _builder_3;
        }
        boolean _haveCommonType_2 = this._iTypeSystem.haveCommonType(it, this._iTypeSystem.getType("string"));
        if (_haveCommonType_2) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("yet_serialize_string");
            return _builder_4;
        }
        boolean _isEnumerationType = this.isEnumerationType(it);
        if (_isEnumerationType) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("yet_int_serializer_function(sizeof(");
            String _targetLanguageName_2 = this._iCodegenTypeSystemAccess.getTargetLanguageName(startType);
            _builder_5.append(_targetLanguageName_2);
            _builder_5.append("), true)");
            return _builder_5;
        }
        if (it instanceof TypeAlias) {
            return this.serializeFunction(((TypeAlias)it).getType(), startType);
        }
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("yet_serialize_void");
        return _builder_6;
    }

    protected CharSequence implementations(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
        StringConcatenation _xblockexpression = null;
        List<TypedElement> tracedTypedElements = this._cYETExtensions.tracedTypedElements(flow);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static void init_feature_value_serializer(void) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("feature_value_serializer[0] = yet_serialize_void;");
        _builder.newLine();
        for (TypedElement typedElement : tracedTypedElements) {
            _builder.append("\t");
            _builder.append("feature_value_serializer[");
            int _indexOf = tracedTypedElements.indexOf(typedElement);
            int _plus = _indexOf + 1;
            _builder.append((Object)_plus, "\t");
            _builder.append("] = ");
            CharSequence _serializeFunction = this.serializeFunction(typedElement.getType(), typedElement.getType());
            _builder.append((Object)_serializeFunction, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static char* featureName(");
        String _name = this._cTypes.sc_integer().name();
        _builder.append(_name);
        _builder.append(" featureId)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _metaFeaturesProperty = this._naming.metaFeaturesProperty(flow);
        _builder.append((Object)_metaFeaturesProperty, "\t");
        _builder.append("[featureId];");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static char* featureValue(");
        String _name_1 = this._cTypes.sc_integer().name();
        _builder.append(_name_1);
        _builder.append(" featureId, const void* valuePtr, char* buf)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return (feature_value_serializer[featureId])(valuePtr, buf);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static char* stateName(");
        String _name_2 = this._cTypes.sc_integer().name();
        _builder.append(_name_2);
        _builder.append(" stateId)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _metaStatesProperty = this._naming.metaStatesProperty(flow);
        _builder.append((Object)_metaStatesProperty, "\t");
        _builder.append("[stateId];");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static yet_error dispatchMessage(yet_scope *scope, yet_message * msg, char *fqn);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        CharSequence _functionPrefixStatechart = this.yetNaming.functionPrefixStatechart(flow);
        _builder.append((Object)_functionPrefixStatechart);
        _builder.append("_init_sc_tracer(yet_sc_tracer *tracer, ");
        CharSequence _statemachine = this.yetNaming.statemachine(flow);
        _builder.append((Object)_statemachine);
        _builder.append("* machine, sc_string name)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (tracer != sc_null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("yet_init_sc_tracer(tracer, machine, &dispatchMessage);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tracer->scope.name = default_scope_name;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (name != sc_null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("tracer->scope.name = name;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tracer->traceinfoProvider.featureName = featureName;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tracer->traceinfoProvider.featureValue = featureValue;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tracer->traceinfoProvider.stateName = stateName;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("machine->trace_handler = &(tracer->traceEventHandler);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("init_feature_value_serializer();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Implementation of yet_handler callback function. Handles incoming stimuli and call appropriate state machine function. */");
        _builder.newLine();
        _builder.append("static yet_error dispatchMessage(yet_scope *scope, yet_message * msg, char *fqn)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        if (IterableExtensions.isNullOrEmpty(this.getAllInEvents(flow)) && !this.hasVariables(flow)) {
            _builder.append("\t");
            _builder.append("SC_UNUSED(scope);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("SC_UNUSED(msg);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("SC_UNUSED(fqn);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return 0;");
            _builder.newLine();
        } else {
            boolean _not;
            _builder.append("\t");
            _builder.append("yet_sc_tracer* tracer = scope->instance;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("char* member;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("member = fqn;");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            boolean _hasVariables = this.hasVariables(flow);
            boolean bl = _not = !_hasVariables;
            if (_not) {
                _builder.append("\t");
                _builder.append("SC_UNUSED(msg);");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.newLine();
            Iterable<EventDefinition> _allInEvents = this.getAllInEvents(flow);
            for (EventDefinition inEvent : _allInEvents) {
                _builder.append("\t");
                _builder.append("if(strcmp(member, \"");
                QualifiedName _metaName = this._naming.metaName((Declaration)inEvent);
                _builder.append((Object)_metaName, "\t");
                _builder.append("\") == 0) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("/* Skip one message; this should not be re-raised on host */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("/* TODO: this is not optimal check if we can get rid of it */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("tracer->skip_raised_in_event++; ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                String _asRaiser = this._naming.asRaiser((Event)inEvent);
                _builder.append(_asRaiser, "\t\t");
                _builder.append("(tracer->machine");
                boolean _hasValue = this._sExecExtensions.hasValue((Object)inEvent);
                if (_hasValue) {
                    _builder.append(", ");
                    CharSequence _convertType = this.convertType(inEvent.getType(), inEvent.getType());
                    _builder.append((Object)_convertType, "\t\t");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return 0;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            Iterable<VariableDefinition> _allExternalVariables = this.getAllExternalVariables(flow);
            for (VariableDefinition v : _allExternalVariables) {
                _builder.append("\t");
                _builder.append("if(strcmp(member, \"");
                QualifiedName _metaName_1 = this._naming.metaName((Declaration)v);
                _builder.append((Object)_metaName_1, "\t");
                _builder.append("\") == 0) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(v.getType());
                _builder.append(_targetLanguageName, "\t\t");
                _builder.append(" converted = ");
                CharSequence _convertType_1 = this.convertType(v.getType(), v.getType());
                _builder.append((Object)_convertType_1, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                String _asSetter = this._naming.asSetter((Object)v);
                _builder.append(_asSetter, "\t\t");
                _builder.append("(tracer->machine, converted);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return 0;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            Iterable<VariableDefinition> _allInternalVariables = this.getAllInternalVariables(flow);
            for (VariableDefinition v_1 : _allInternalVariables) {
                _builder.append("\t");
                _builder.append("if(strcmp(member, \"");
                QualifiedName _metaName_2 = this._naming.metaName((Declaration)v_1);
                _builder.append((Object)_metaName_2, "\t");
                _builder.append("\") == 0) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(v_1.getType());
                _builder.append(_targetLanguageName_1, "\t\t");
                _builder.append(" converted = ");
                CharSequence _convertType_2 = this.convertType(v_1.getType(), v_1.getType());
                _builder.append((Object)_convertType_2, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("((");
                String _type = this._naming.type((Notifier)flow);
                _builder.append(_type, "\t\t");
                _builder.append("*)tracer->machine)->");
                EObject _eContainer = v_1.eContainer();
                String _instance = this._naming.instance((Scope)((InternalScope)_eContainer));
                _builder.append(_instance, "\t\t");
                _builder.append(".");
                String _asEscapedIdentifier = this.yetNaming.asEscapedIdentifier(v_1.getName());
                _builder.append(_asEscapedIdentifier, "\t\t");
                _builder.append(" = converted;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return 0;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return YET_ERR_INVALID_KEY;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence convertType(Type it, Type baseType) {
        StringConcatenation _xifexpression = null;
        if (this.isIntegerType(it) || this.isEnumerationType(it)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(");
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(baseType);
            _builder.append(_targetLanguageName);
            _builder.append(")atol(msg->value)");
            return _builder;
        }
        StringConcatenation _xifexpression_1 = null;
        boolean _haveCommonType = this._iTypeSystem.haveCommonType(it, this._iTypeSystem.getType("boolean"));
        if (_haveCommonType) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("(msg->value[0] == 't')");
            return _builder_1;
        }
        StringConcatenation _xifexpression_2 = null;
        boolean _haveCommonType_1 = this._iTypeSystem.haveCommonType(it, this._iTypeSystem.getType("real"));
        if (_haveCommonType_1) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("(");
            String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(baseType);
            _builder_2.append(_targetLanguageName_1);
            _builder_2.append(")atof(msg->value)");
            _xifexpression_2 = _builder_2;
        } else {
            StringConcatenation _xifexpression_3 = null;
            boolean _haveCommonType_2 = this._iTypeSystem.haveCommonType(it, this._iTypeSystem.getType("string"));
            if (_haveCommonType_2) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("msg->value");
                _xifexpression_3 = _builder_3;
            } else {
                StringConcatenation _xifexpression_4 = null;
                if (it instanceof TypeAlias) {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    CharSequence _convertType = this.convertType(((TypeAlias)it).getType(), baseType);
                    _builder_4.append((Object)_convertType);
                    _xifexpression_4 = _builder_4;
                } else {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append("sc_null");
                    _xifexpression_4 = _builder_5;
                }
                _xifexpression_3 = _xifexpression_4;
            }
            _xifexpression_2 = _xifexpression_3;
        }
        _xifexpression = _xifexpression_1 = _xifexpression_2;
        return _xifexpression;
    }

    public boolean isIntegerType(Type it) {
        return this._iTypeSystem.haveCommonType(it, this._iTypeSystem.getType("integer")) && this._iTypeSystem.isSuperType(it, this._iTypeSystem.getType("integer"));
    }

    public boolean isEnumerationType(Type it) {
        Type _originType = it.getOriginType();
        return _originType instanceof EnumerationType;
    }

    protected boolean hasVariables(ExecutionFlow flow) {
        return !IterableExtensions.isNullOrEmpty(this.getAllExternalVariables(flow)) || !IterableExtensions.isNullOrEmpty(this.getAllInternalVariables(flow));
    }

    protected Iterable<EventDefinition> getAllInEvents(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> it_1.getDeclarations();
        Functions.Function1 _function_1 = it_1 -> {
            Direction _direction = it_1.getDirection();
            return Objects.equals(_direction, Direction.IN);
        };
        return IterableExtensions.filter((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)it.getScopes(), InterfaceScope.class), (Functions.Function1)_function)), EventDefinition.class), (Functions.Function1)_function_1);
    }

    protected Iterable<VariableDefinition> getAllExternalVariables(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> it_1.getDeclarations();
        Functions.Function1 _function_1 = it_1 -> {
            boolean _isConst = it_1.isConst();
            return !_isConst;
        };
        Functions.Function1 _function_2 = it_1 -> {
            boolean _isReadonly = it_1.isReadonly();
            return !_isReadonly;
        };
        Functions.Function1 _function_3 = it_1 -> {
            boolean _isComplexType = this.isComplexType(it_1.getType());
            return !_isComplexType;
        };
        return IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)it.getScopes(), InterfaceScope.class), (Functions.Function1)_function)), VariableDefinition.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
    }

    protected Iterable<VariableDefinition> getAllInternalVariables(ExecutionFlow it) {
        Functions.Function1 _function = it_1 -> it_1.getDeclarations();
        Functions.Function1 _function_1 = it_1 -> {
            boolean _isConst = it_1.isConst();
            return !_isConst;
        };
        Functions.Function1 _function_2 = it_1 -> {
            boolean _isReadonly = it_1.isReadonly();
            return !_isReadonly;
        };
        Functions.Function1 _function_3 = it_1 -> {
            boolean _isComplexType = this.isComplexType(it_1.getType());
            return !_isComplexType;
        };
        return IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)it.getScopes(), InternalScope.class), (Functions.Function1)_function)), VariableDefinition.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
    }

    protected boolean isComplexType(Type it) {
        if (it instanceof EnumerationType) {
            return false;
        }
        if (it instanceof ComplexType) {
            return true;
        }
        if (it instanceof TypeAlias) {
            return this.isComplexType(((TypeAlias)it).getType());
        }
        return false;
    }

    protected String removePrefix(String s) {
        int _indexOf = s.indexOf(".");
        int _plus = _indexOf + 1;
        return s.substring(_plus);
    }
}

