/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ServerSettings {
    public static final String PORT_DEFAULT = "6200";
    private final List<String> hosts;
    private final String port;
    private final boolean isExternal;
    private final boolean isEnabled;
    public static final ServerSettings NOT_AVAILABLE = new ServerSettings(Collections.emptyList(), null, false, false){

        @Override
        public String toString() {
            return "<not configured>";
        }
    };

    private ServerSettings(List<String> hosts, String port, boolean isEnabled, boolean isExternal) {
        this.hosts = hosts;
        this.port = port;
        this.isEnabled = isEnabled;
        this.isExternal = isExternal;
    }

    public static ServerSettings createFrom(String serverPath, boolean isEnabled, boolean isExternal) {
        String serverPathTrimmed;
        String string = serverPathTrimmed = serverPath == null ? null : serverPath.trim();
        if (serverPathTrimmed != null && !serverPathTrimmed.isEmpty()) {
            String[] servers = serverPath.split("[,;:]");
            ArrayList<String> hosts = new ArrayList<String>(servers.length);
            String port = null;
            String[] stringArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                String server = stringArray[n2];
                String serverTrimmed = server.trim();
                if (!serverTrimmed.isEmpty()) {
                    String host;
                    String[] split;
                    if (serverTrimmed.contains("@")) {
                        split = serverTrimmed.split("@");
                        String string2 = host = split.length > 1 ? split[1].trim() : null;
                        if (host != null && !host.isEmpty()) {
                            hosts.add(host);
                            if (port == null && !split[0].trim().isEmpty() && !"null".equals(split[0].trim())) {
                                port = split[0].trim();
                            }
                        }
                    } else if (serverTrimmed.contains("%")) {
                        split = serverTrimmed.split("%");
                        String string3 = host = split.length > 0 ? split[0].trim() : null;
                        if (host != null && !host.isEmpty()) {
                            hosts.add(host);
                            if (port == null && split.length > 1 && !split[1].trim().isEmpty() && !"null".equals(split[1].trim())) {
                                port = split[1].trim();
                            }
                        }
                    } else {
                        hosts.add(serverTrimmed);
                    }
                }
                ++n2;
            }
            if (!hosts.isEmpty()) {
                return new ServerSettings(hosts, port == null ? PORT_DEFAULT : port, isEnabled, isExternal);
            }
        }
        return NOT_AVAILABLE;
    }

    public static ServerSettings createFrom(String serverPath, boolean isExternal) {
        return ServerSettings.createFrom(serverPath, true, isExternal);
    }

    public List<String> getHosts() {
        return this.hosts == null ? Collections.emptyList() : Collections.unmodifiableList(this.hosts);
    }

    public String getHost() {
        if (this.hosts == null || this.hosts.isEmpty()) {
            return "";
        }
        if (this.hosts.size() == 1) {
            return this.hosts.get(0);
        }
        return this.hosts.stream().collect(Collectors.joining(File.pathSeparator));
    }

    public String getPort() {
        return this.port;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getServerUrl() {
        if (this.hosts == null || this.hosts.isEmpty()) {
            return "<none>";
        }
        if (this.hosts.size() == 1) {
            return String.valueOf(this.port) + "@" + this.hosts.get(0);
        }
        return this.hosts.stream().map(h -> String.valueOf(this.port) + "@" + h).collect(Collectors.joining(File.pathSeparator));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hosts == null ? 0 : this.hosts.hashCode());
        result = 31 * result + (this.isEnabled ? 1231 : 1237);
        result = 31 * result + (this.isExternal ? 1231 : 1237);
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerSettings other = (ServerSettings)obj;
        if (this.hosts == null ? other.hosts != null : !this.hosts.equals(other.hosts)) {
            return false;
        }
        if (this.isEnabled != other.isEnabled) {
            return false;
        }
        if (this.isExternal != other.isExternal) {
            return false;
        }
        return !(this.port == null ? other.port != null : !this.port.equals(other.port));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getServerUrl());
        stringBuilder.append(" (enabled:").append(this.isEnabled()).append("), (external:").append(this.isExternal()).append(")");
        return stringBuilder.toString();
    }
}

