/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.custom;

import com.xformation.lmx.LmxHostid;
import com.xformation.lmx.LmxHostidType;
import com.xformation.lmx.LmxStatus;
import com.yakindu.licmgmt.internal.LicenseSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomLicenseHelper {
    private static final String ACTIONS = "GITHUB_ACTIONS";
    private static final String SERVER_URL = "GITHUB_SERVER_URL";
    private static final Pattern PRODUCT_APP_PATTERN = Pattern.compile("\\-(product|application)\\s+([^\\s]+)\\s");
    private static final Pattern[] TEST_APP_PATTERN = new Pattern[]{Pattern.compile("org\\.eclipse\\.pde\\.junit\\.runtime\\.\\w+testapplication"), Pattern.compile("org\\.eclipse\\.(tycho\\.)?surefire\\.[a-zA-Z0-9_\\.]+test[a-zA-Z0-9_\\.]*")};
    private static final String CMD = "eclipse.commands";
    private static final String PRODUCT = "eclipse.product";
    private static final String APPLICATION = "eclipse.application";
    private static final String CUSTOM_HOSTID = "custom.hostid";
    private static final String GH_SERVER = "github.server";
    private static final String ECLIPSE_CMD = System.getProperty("eclipse.commands");
    private static final String ECLIPSE_PRODUCT = System.getProperty("eclipse.product");
    private static final String ECLIPSE_APPLICATION = System.getProperty("eclipse.application");
    private static final String GH_ACTIONS = System.getenv("GITHUB_ACTIONS");
    private static final String GH_URL = System.getenv("GITHUB_SERVER_URL");
    private final String eclipseCmd = System.getProperty("eclipse.commands");
    private final String eclipseProduct = System.getProperty("eclipse.product");
    private final String eclipseApplication = System.getProperty("eclipse.application");
    private final String ghActions = System.getenv("GITHUB_ACTIONS");
    private final String ghUrl = System.getenv("GITHUB_SERVER_URL");

    public LmxStatus addHostIds(List<LmxHostid> hostIds, LicenseSettings settings) {
        this.addProductHostIds(hostIds, settings);
        this.addGHHostIds(hostIds);
        return LmxStatus.LMX_SUCCESS;
    }

    public void addProductHostIds(List<LmxHostid> hostIds, LicenseSettings settings) {
        if (this.isPropertyModified() && !this.isTestApplication(ECLIPSE_CMD)) {
            return;
        }
        Map<String, String> ids = this.getIdsFromEclipseCmd();
        if (ids.isEmpty()) {
            this.addProductId(ids);
            this.addApplicationId(ids);
        }
        this.addCustomHostIdFromSettings(ids, settings);
        if (ids.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> id : ids.entrySet()) {
            LmxHostid hostid = new LmxHostid();
            hostid.setHostidType(LmxHostidType.LMX_HOSTID_CUSTOM);
            hostid.setDescription(id.getKey().toUpperCase());
            hostid.setValue(id.getValue());
            hostIds.add(hostid);
        }
    }

    private void addGHHostIds(List<LmxHostid> hostIds) {
        if (this.isPropertyModified() && !this.isTestApplication(ECLIPSE_CMD)) {
            return;
        }
        if ("true".equalsIgnoreCase(this.ghActions) || "\"true\"".equalsIgnoreCase(this.ghActions) || "1".equals(this.ghActions)) {
            String[] ghUrls = this.getGhUrls();
            int i = 0;
            while (i < ghUrls.length) {
                LmxHostid hostid = new LmxHostid();
                hostid.setHostidType(LmxHostidType.LMX_HOSTID_CUSTOM);
                hostid.setDescription(i == 0 ? GH_SERVER : GH_SERVER + i);
                hostid.setValue(ghUrls[i]);
                hostIds.add(hostid);
                ++i;
            }
        }
    }

    private String[] getGhUrls() {
        if (this.ghUrl == null || this.ghUrl.isBlank() || this.ghUrl.length() < 3) {
            return new String[0];
        }
        String normalizedUrl = this.normalizeGhUrl(this.ghUrl);
        String[] ghUrls = new String[]{normalizedUrl, String.valueOf(normalizedUrl) + "/", "\"" + normalizedUrl + "\"", "\"" + normalizedUrl + "/\""};
        return ghUrls;
    }

    private String normalizeGhUrl(String url) {
        String urlWithoutQuotes = url.startsWith("\"") && url.endsWith("\"") || url.startsWith("'") && url.endsWith("'") ? url.substring(1, url.length() - 1) : url;
        String urlWithoutTrailingSlash = urlWithoutQuotes.endsWith("/") ? urlWithoutQuotes.substring(0, urlWithoutQuotes.length() - 1) : urlWithoutQuotes;
        return urlWithoutTrailingSlash;
    }

    private boolean isPropertyModified() {
        if (!Objects.equals(ECLIPSE_CMD, this.eclipseCmd)) {
            return true;
        }
        if (!Objects.equals(ECLIPSE_APPLICATION, this.eclipseApplication)) {
            return true;
        }
        if (!Objects.equals(ECLIPSE_PRODUCT, this.eclipseProduct)) {
            return true;
        }
        if (!Objects.equals(GH_ACTIONS, this.ghActions)) {
            return true;
        }
        return !Objects.equals(GH_URL, this.ghUrl);
    }

    private Map<String, String> getIdsFromEclipseCmd() {
        HashMap<String, String> ids = new HashMap<String, String>(2);
        if (this.eclipseCmd != null) {
            Matcher matcher = PRODUCT_APP_PATTERN.matcher(this.eclipseCmd);
            while (matcher.find()) {
                String id = matcher.group(1);
                if (id == null || id.isEmpty()) continue;
                String description = matcher.group(1).toUpperCase();
                String value = matcher.group(2);
                ids.put(description, value);
            }
        }
        return ids;
    }

    private void addApplicationId(Map<String, String> ids) {
        if (this.eclipseApplication != null && !this.eclipseApplication.trim().isEmpty()) {
            ids.put(APPLICATION, this.eclipseApplication);
        }
    }

    private void addProductId(Map<String, String> ids) {
        if (this.eclipseProduct != null && !this.eclipseProduct.trim().isEmpty()) {
            ids.put(PRODUCT, this.eclipseProduct);
        }
    }

    private void addCustomHostIdFromSettings(Map<String, String> ids, LicenseSettings settings) {
        String customHostId = settings.getCustomHostId();
        if (customHostId != null && !customHostId.trim().isEmpty()) {
            ids.put(CUSTOM_HOSTID, customHostId);
        }
    }

    private boolean isTestApplication(String cmd) {
        if (cmd != null && !cmd.isBlank()) {
            Matcher matcher = PRODUCT_APP_PATTERN.matcher(cmd);
            while (matcher.find()) {
                String appId = matcher.group(2);
                Pattern[] patternArray = TEST_APP_PATTERN;
                int n = TEST_APP_PATTERN.length;
                int n2 = 0;
                while (n2 < n) {
                    Pattern testPattern = patternArray[n2];
                    if (testPattern.matcher(appId).matches()) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }
}

