/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.builder;

import com.google.common.collect.Sets;
import com.yakindu.sct.generator.builder.BuilderActivator;
import com.yakindu.sct.generator.builder.EclipseContextGeneratorExecutorLookup;
import com.yakindu.sct.generator.builder.GenmodelIndex;
import com.yakindu.sct.generator.builder.resources.DefaultResourceBlacklist;
import com.yakindu.sct.generator.core.execution.IGeneratorEntryExecutor;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgen.GeneratorModel;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.runtime.ContentTypeHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

public class SCTBuilder
extends IncrementalProjectBuilder {
    protected static final String SGEN_FILE_EXTENSION = "sgen";
    public static final String BUILDER_ID = "com.yakindu.sct.builder.SCTBuilder";
    private DefaultResourceBlacklist sgenBlackList;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IPreferenceStore store = BuilderActivator.getDefault().getPreferenceStore();
        boolean generateAutomatical = store.getBoolean("generate.automatically");
        this.sgenBlackList = new DefaultResourceBlacklist();
        if (generateAutomatical) {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            HashSet allSgens = Sets.newHashSet();
            this.getProject().accept(resource -> {
                if (resource instanceof IFile && SGEN_FILE_EXTENSION.equals(resource.getFileExtension())) {
                    allSgens.add(resource);
                }
                return true;
            });
            GenmodelIndex.rebuildIndex(allSgens);
            this.getProject().accept((IResourceVisitor)new SimpleResourceVisitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new DeltaVisitor());
    }

    public void doIt(IResource changedResource, Set<IResource> buildSgens) {
        if (SGEN_FILE_EXTENSION.equals(changedResource.getFileExtension()) && !buildSgens.contains(changedResource)) {
            if (this.hasError(changedResource)) {
                this.logGenmodelError(changedResource.getFullPath().toString());
            } else {
                buildSgens.add(changedResource);
                this.executeGenmodelGenerator(changedResource);
            }
            return;
        }
        if (changedResource instanceof IFile && ContentTypeHelper.isStatechart((IFile)((IFile)changedResource))) {
            Statechart statechart = (Statechart)this.loadFromResource(changedResource);
            if (statechart == null) {
                return;
            }
            Collection<IResource> genmodelsForStatechart = GenmodelIndex.findGenmodelsReferencing(statechart);
            for (IResource genmodel : genmodelsForStatechart) {
                if (buildSgens.contains(genmodel)) continue;
                if (this.hasError(genmodel)) {
                    this.logGenmodelError(genmodel.getFullPath().toString());
                    continue;
                }
                buildSgens.add(genmodel);
                this.executeGenmodelGenerator(genmodel, statechart);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasError(IResource resource) {
        IMarker[] findMarkers = null;
        try {
            IMarker[] iMarkerArray = findMarkers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = findMarkers.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMarker iMarker = iMarkerArray[n2];
                Integer attribute = (Integer)iMarker.getAttribute("severity");
                if (attribute == 2) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void executeGenmodelGenerator(IResource resource) {
        if (this.sgenBlackList.violates(resource, resource.getProject())) {
            this.logGenmodelInfo(resource);
            return;
        }
        new EclipseContextGeneratorExecutorLookup().executeGenerator(resource.getProject().getFile(resource.getProjectRelativePath()));
    }

    protected void executeGenmodelGenerator(IResource genmodel, Statechart changedStatechart) {
        if (this.sgenBlackList.violates(genmodel, genmodel.getProject())) {
            this.logGenmodelInfo(genmodel);
            return;
        }
        GeneratorModel genModel = (GeneratorModel)this.loadFromResource(genmodel);
        if (genModel == null || genModel.getEntries().isEmpty()) {
            return;
        }
        URI changedUri = EcoreUtil.getURI((EObject)changedStatechart);
        EclipseContextGeneratorExecutorLookup lookup = new EclipseContextGeneratorExecutorLookup();
        for (GeneratorEntry entry : genModel.getEntries()) {
            EObject ref = entry.getElementRef();
            if (ref == null || !EcoreUtil.getURI((EObject)ref).equals(changedUri)) continue;
            IGeneratorEntryExecutor executor = lookup.createExecutor(entry, genModel.getGeneratorId());
            executor.execute(entry);
        }
    }

    protected void logGenmodelInfo(IResource resource) {
        Status status = new Status(1, BUILDER_ID, String.format("Cannot execute Genmodel %s. The file is excluded from build. (see project properties > itemis CREATE > SGen Filter)", resource));
        Platform.getLog((Bundle)BuilderActivator.getDefault().getBundle()).log((IStatus)status);
    }

    protected void logGenmodelError(String resource) {
        Status status = new Status(2, BUILDER_ID, String.format("Cannot execute Genmodel %s. The file contains errors.", resource));
        Platform.getLog((Bundle)BuilderActivator.getDefault().getBundle()).log((IStatus)status);
    }

    protected void logStatechartError(String resource) {
        Status status = new Status(2, BUILDER_ID, String.format("Cannot generate Code for Statechart %s. The file contains errors.", resource));
        Platform.getLog((Bundle)BuilderActivator.getDefault().getBundle()).log((IStatus)status);
    }

    private <TYPE extends EObject> TYPE loadFromResource(IResource res) {
        URI uri = URI.createPlatformResourceURI((String)res.getFullPath().toString(), (boolean)true);
        ResourceSetImpl set = new ResourceSetImpl();
        Resource emfResource = null;
        try {
            emfResource = set.getResource(uri, true);
        }
        catch (WrappedException e) {
            Platform.getLog((Bundle)BuilderActivator.getDefault().getBundle()).log((IStatus)new Status(2, "com.yakindu.sct.generator.core", "Resource " + String.valueOf(uri) + " can not be loaded by builder", (Throwable)e));
            return null;
        }
        if (emfResource.getErrors().size() > 0 || emfResource.getContents().size() == 0) {
            return null;
        }
        return (TYPE)((EObject)emfResource.getContents().get(0));
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private Set<IResource> buildSgens = Sets.newHashSet();

        DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    if (resource instanceof IFile && SCTBuilder.SGEN_FILE_EXTENSION.equals(resource.getFileExtension())) {
                        GenmodelIndex.updateMappingFor((IFile)resource);
                    }
                    SCTBuilder.this.doIt(resource, this.buildSgens);
                    break;
                }
                case 2: {
                    if (!(resource instanceof IFile) || !SCTBuilder.SGEN_FILE_EXTENSION.equals(resource.getFileExtension())) break;
                    GenmodelIndex.removeMapping(resource);
                    break;
                }
                case 4: {
                    if (resource instanceof IFile && SCTBuilder.SGEN_FILE_EXTENSION.equals(resource.getFileExtension())) {
                        GenmodelIndex.updateMappingFor((IFile)resource);
                    }
                    SCTBuilder.this.doIt(resource, this.buildSgens);
                }
            }
            return true;
        }
    }

    class SimpleResourceVisitor
    implements IResourceVisitor {
        private Set<IResource> buildSgens = Sets.newHashSet();

        SimpleResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            SCTBuilder.this.doIt(resource, this.buildSgens);
            return true;
        }
    }
}

