/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.builder.action;

import com.yakindu.sct.generator.builder.BuilderActivator;
import com.yakindu.sct.generator.builder.EclipseContextGeneratorExecutorLookup;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class GenerateModelAction
implements IObjectActionDelegate {
    private ISelection selection;
    private EclipseContextGeneratorExecutorLookup generatorExecutor = new EclipseContextGeneratorExecutorLookup();

    public void run(IAction action) {
        this.unwrap().forEach(file -> {
            if (this.hasError((IFile)file)) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ErrorDialog.openError((Shell)shell, (String)"Generator Error", (String)"Cannot execute Generator", (IStatus)new Status(4, "com.yakindu.sct.generator.core", "The file contains errors"));
            } else {
                this.generatorExecutor.executeGenerator((IFile)file);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasError(IFile file) {
        IMarker[] findMarkers = null;
        try {
            IMarker[] iMarkerArray = findMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                Integer attribute = (Integer)iMarker.getAttribute("severity");
                if (attribute == 2) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            BuilderActivator.getDefault().getLog().log((IStatus)new Status(2, "com.yakindu.sct.builder", "Error in determine, if file contains errors", (Throwable)e));
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        try {
            Diagnostic diagnostic;
            Resource resource = rs.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
            if (resource == null) {
                return false;
            }
            if (!resource.getErrors().isEmpty()) {
                return true;
            }
            if (resource.getContents().isEmpty() || (diagnostic = Diagnostician.INSTANCE.validate((EObject)resource.getContents().get(0))).getSeverity() != 4) return false;
            return true;
        }
        catch (RuntimeException e) {
            BuilderActivator.getDefault().getLog().log((IStatus)new Status(2, "com.yakindu.sct.builder", "Error in opening resource", (Throwable)e));
        }
        return false;
    }

    private List<IFile> unwrap() {
        if (this.selection instanceof StructuredSelection) {
            List list = ((StructuredSelection)this.selection).toList();
            return list.stream().filter(e -> e instanceof IFile).map(e -> (IFile)e).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

