/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.base;

import com.yakindu.base.expressions.interpreter.base.SRuntimeInterpreter;
import com.yakindu.core.IEventDriven;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;

public class InterpreterControl
implements IEventDriven {
    protected Work work;
    protected Jobs jobs;
    private final State[] stateVector = new State[1];
    private Queue<Runnable> inEventQueue = new LinkedList<Runnable>();
    private SRuntimeInterpreter.Job job;
    private boolean isExecuting;
    private OperationCallback operationCallback;
    private boolean terminate;
    private boolean suspend;
    private boolean step;
    private boolean resume;
    private boolean continueEvent;
    private Deque<SRuntimeInterpreter.Job> jobsWaiting;
    private Deque<SRuntimeInterpreter.Job> jobsReady;
    private Deque<SRuntimeInterpreter.Job> jobsDone;
    private SRuntimeInterpreter.Job currentJob;

    protected SRuntimeInterpreter.Job getJob() {
        return this.job;
    }

    protected void setJob(SRuntimeInterpreter.Job value) {
        this.job = value;
    }

    protected boolean getIsExecuting() {
        return this.isExecuting;
    }

    protected void setIsExecuting(boolean value) {
        this.isExecuting = value;
    }

    public InterpreterControl() {
        this.work = new Work(this);
        this.jobs = new Jobs(this);
        int i = 0;
        while (i < 1) {
            this.stateVector[i] = State.$NULLSTATE$;
            ++i;
        }
        this.clearInEvents();
        this.work.setCanContinueWork(false);
        this.work.setCanAcceptNewWork(false);
        this.isExecuting = false;
    }

    public void enter() {
        if (this.operationCallback == null) {
            throw new IllegalStateException("Operation callback must be set.");
        }
        if (this.getIsExecuting()) {
            return;
        }
        this.isExecuting = true;
        this.setJobsDone(new ArrayDeque<SRuntimeInterpreter.Job>());
        this.setJobsReady(new ArrayDeque<SRuntimeInterpreter.Job>());
        this.setJobsWaiting(new ArrayDeque<SRuntimeInterpreter.Job>());
        this.enterSequence_main_default();
        this.isExecuting = false;
    }

    public void exit() {
        if (this.getIsExecuting()) {
            return;
        }
        this.isExecuting = true;
        this.exitSequence_main();
        this.stateVector[0] = State.$NULLSTATE$;
        this.isExecuting = false;
    }

    public boolean isActive() {
        return this.stateVector[0] != State.$NULLSTATE$;
    }

    public boolean isFinal() {
        return false;
    }

    private void clearInEvents() {
        this.terminate = false;
        this.suspend = false;
        this.step = false;
        this.resume = false;
        this.continueEvent = false;
        this.work.begin = false;
        this.work.done = false;
        this.work.suspended = false;
        this.jobs.invoked = false;
        this.jobs.launched = false;
        this.jobs.waiting = false;
        this.jobs.continuing = false;
    }

    private void microStep() {
        switch (this.stateVector[0]) {
            case MAIN_IDLE: {
                this.main_idle_react(-1L);
                break;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_REGULAR: {
                this.main_busy_r_process_invocation__region0_regular_react(-1L);
                break;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS: {
                this.main_busy_r_process_invocation__region0_process_recursive_invocations_react(-1L);
                break;
            }
            case MAIN_BUSY_R_SUSPENDING: {
                this.main_busy_r_suspending_react(-1L);
                break;
            }
            case MAIN_BUSY_R_SUSPENDED: {
                this.main_busy_r_suspended_react(-1L);
                break;
            }
            case MAIN_TERMINATING: {
                this.main_terminating_react(-1L);
                break;
            }
        }
    }

    private void runCycle() {
        if (this.operationCallback == null) {
            throw new IllegalStateException("Operation callback must be set.");
        }
        if (this.getIsExecuting()) {
            return;
        }
        this.isExecuting = true;
        this.nextEvent();
        do {
            this.microStep();
            this.clearInEvents();
        } while (this.nextEvent());
        this.isExecuting = false;
    }

    protected boolean nextEvent() {
        if (!this.inEventQueue.isEmpty()) {
            this.inEventQueue.poll().run();
            return true;
        }
        return false;
    }

    public boolean isStateActive(State state) {
        switch (state) {
            case MAIN_IDLE: {
                return this.stateVector[0] == State.MAIN_IDLE;
            }
            case MAIN_BUSY: {
                return this.stateVector[0].ordinal() >= State.MAIN_BUSY.ordinal() && this.stateVector[0].ordinal() <= State.MAIN_BUSY_R_SUSPENDED.ordinal();
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION: {
                return this.stateVector[0].ordinal() >= State.MAIN_BUSY_R_PROCESS_INVOCATION.ordinal() && this.stateVector[0].ordinal() <= State.MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS.ordinal();
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_REGULAR: {
                return this.stateVector[0] == State.MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_REGULAR;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS: {
                return this.stateVector[0] == State.MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS;
            }
            case MAIN_BUSY_R_SUSPENDING: {
                return this.stateVector[0] == State.MAIN_BUSY_R_SUSPENDING;
            }
            case MAIN_BUSY_R_SUSPENDED: {
                return this.stateVector[0] == State.MAIN_BUSY_R_SUSPENDED;
            }
            case MAIN_TERMINATING: {
                return this.stateVector[0] == State.MAIN_TERMINATING;
            }
        }
        return false;
    }

    public Work work() {
        return this.work;
    }

    public Jobs jobs() {
        return this.jobs;
    }

    public void setOperationCallback(OperationCallback operationCallback) {
        this.operationCallback = operationCallback;
    }

    public void raiseTerminate() {
        this.inEventQueue.add(() -> {
            this.terminate = true;
        });
        this.runCycle();
    }

    public void raiseSuspend() {
        this.inEventQueue.add(() -> {
            this.suspend = true;
        });
        this.runCycle();
    }

    public void raiseStep() {
        this.inEventQueue.add(() -> {
            this.step = true;
        });
        this.runCycle();
    }

    public void raiseResume() {
        this.inEventQueue.add(() -> {
            this.resume = true;
        });
        this.runCycle();
    }

    public void raiseContinue() {
        this.inEventQueue.add(() -> {
            this.continueEvent = true;
        });
        this.runCycle();
    }

    public Deque<SRuntimeInterpreter.Job> getJobsWaiting() {
        return this.jobsWaiting;
    }

    public void setJobsWaiting(Deque<SRuntimeInterpreter.Job> value) {
        this.jobsWaiting = value;
    }

    public Deque<SRuntimeInterpreter.Job> getJobsReady() {
        return this.jobsReady;
    }

    public void setJobsReady(Deque<SRuntimeInterpreter.Job> value) {
        this.jobsReady = value;
    }

    public Deque<SRuntimeInterpreter.Job> getJobsDone() {
        return this.jobsDone;
    }

    public void setJobsDone(Deque<SRuntimeInterpreter.Job> value) {
        this.jobsDone = value;
    }

    public SRuntimeInterpreter.Job getCurrentJob() {
        return this.currentJob;
    }

    public void setCurrentJob(SRuntimeInterpreter.Job value) {
        this.currentJob = value;
    }

    private void exitAction_main_idle() {
        this.operationCallback.resetStatistics();
    }

    private void enterSequence_main_idle_default() {
        this.stateVector[0] = State.MAIN_IDLE;
    }

    private void enterSequence_main_busy_r_process_invocation_default() {
        this.enterSequence_main_busy_r_process_invocation__region0_default();
    }

    private void enterSequence_main_busy_r_process_invocation__region0_regular_default() {
        this.stateVector[0] = State.MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_REGULAR;
    }

    private void enterSequence_main_busy_r_process_invocation__region0_process_recursive_invocations_default() {
        this.stateVector[0] = State.MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS;
    }

    private void enterSequence_main_busy_r_suspending_default() {
        this.stateVector[0] = State.MAIN_BUSY_R_SUSPENDING;
    }

    private void enterSequence_main_busy_r_suspended_default() {
        this.stateVector[0] = State.MAIN_BUSY_R_SUSPENDED;
    }

    private void enterSequence_main_terminating_default() {
        this.stateVector[0] = State.MAIN_TERMINATING;
    }

    private void enterSequence_main_default() {
        this.react_main__entry_Default();
    }

    private void enterSequence_main_busy_r_process_invocation__region0_default() {
        this.react_main_busy_r_process_invocation__region0__entry_Default();
    }

    private void exitSequence_main_idle() {
        this.stateVector[0] = State.$NULLSTATE$;
        this.exitAction_main_idle();
    }

    private void exitSequence_main_busy() {
        this.exitSequence_main_busy_r();
        this.stateVector[0] = State.$NULLSTATE$;
    }

    private void exitSequence_main_busy_r_process_invocation() {
        this.exitSequence_main_busy_r_process_invocation__region0();
        this.stateVector[0] = State.MAIN_BUSY;
    }

    private void exitSequence_main_busy_r_process_invocation__region0_regular() {
        this.stateVector[0] = State.MAIN_BUSY_R_PROCESS_INVOCATION;
    }

    private void exitSequence_main_busy_r_process_invocation__region0_process_recursive_invocations() {
        this.stateVector[0] = State.MAIN_BUSY_R_PROCESS_INVOCATION;
    }

    private void exitSequence_main_busy_r_suspending() {
        this.stateVector[0] = State.MAIN_BUSY;
    }

    private void exitSequence_main_busy_r_suspended() {
        this.stateVector[0] = State.MAIN_BUSY;
    }

    private void exitSequence_main_terminating() {
        this.stateVector[0] = State.$NULLSTATE$;
    }

    private void exitSequence_main() {
        switch (this.stateVector[0]) {
            case MAIN_IDLE: {
                this.exitSequence_main_idle();
                break;
            }
            case MAIN_BUSY: {
                this.exitSequence_main_busy();
                break;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION: {
                this.exitSequence_main_busy_r_process_invocation();
                break;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_REGULAR: {
                this.exitSequence_main_busy_r_process_invocation__region0_regular();
                break;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS: {
                this.exitSequence_main_busy_r_process_invocation__region0_process_recursive_invocations();
                break;
            }
            case MAIN_BUSY_R_SUSPENDING: {
                this.exitSequence_main_busy_r_suspending();
                break;
            }
            case MAIN_BUSY_R_SUSPENDED: {
                this.exitSequence_main_busy_r_suspended();
                break;
            }
            case MAIN_TERMINATING: {
                this.exitSequence_main_terminating();
                break;
            }
        }
    }

    private void exitSequence_main_busy_r() {
        switch (this.stateVector[0]) {
            case MAIN_BUSY_R_PROCESS_INVOCATION: {
                this.exitSequence_main_busy_r_process_invocation();
                break;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_REGULAR: {
                this.exitSequence_main_busy_r_process_invocation__region0_regular();
                break;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS: {
                this.exitSequence_main_busy_r_process_invocation__region0_process_recursive_invocations();
                break;
            }
            case MAIN_BUSY_R_SUSPENDING: {
                this.exitSequence_main_busy_r_suspending();
                break;
            }
            case MAIN_BUSY_R_SUSPENDED: {
                this.exitSequence_main_busy_r_suspended();
                break;
            }
        }
    }

    private void exitSequence_main_busy_r_process_invocation__region0() {
        switch (this.stateVector[0]) {
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_REGULAR: {
                this.exitSequence_main_busy_r_process_invocation__region0_regular();
                break;
            }
            case MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS: {
                this.exitSequence_main_busy_r_process_invocation__region0_process_recursive_invocations();
                break;
            }
        }
    }

    private void react_main__choice_0() {
        this.getJobsDone().offerLast(this.getCurrentJob());
        this.getCurrentJob().done();
        this.setCurrentJob(null);
        this.enterSequence_main_idle_default();
    }

    private void react_main_busy_r_process_invocation__region0__choice_0() {
        if (this.getCurrentJob().getPrevious() == null) {
            this.exitSequence_main_busy_r_process_invocation();
            this.enterSequence_main_busy_r_suspending_default();
            this.main_busy_react(0L);
        } else {
            this.enterSequence_main_busy_r_process_invocation__region0_process_recursive_invocations_default();
        }
    }

    private void react_main__entry_Default() {
        this.enterSequence_main_idle_default();
    }

    private void react_main_busy_r_process_invocation__region0__entry_Default() {
        this.enterSequence_main_busy_r_process_invocation__region0_regular_default();
    }

    private long react(long transitioned_before) {
        return transitioned_before;
    }

    private long main_idle_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && this.jobs.invoked) {
            this.exitSequence_main_idle();
            this.setCurrentJob(this.jobs.getInvokedValue());
            this.getJobsDone().clear();
            this.enterSequence_main_busy_r_process_invocation_default();
            this.react(0L);
            transitioned_after = 0L;
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_busy_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && this.terminate) {
            this.exitSequence_main_busy();
            this.enterSequence_main_terminating_default();
            this.react(0L);
            transitioned_after = 0L;
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_busy_r_process_invocation_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && this.work.done && this.getCurrentJob().getPrevious() == null && this.getJobsReady().isEmpty()) {
            this.exitSequence_main_busy();
            this.react_main__choice_0();
            transitioned_after = 0L;
        }
        if (transitioned_after == transitioned_before) {
            if (this.jobs.invoked) {
                this.setJob(this.jobs.getInvokedValue());
                this.getJob().setPrevious(this.getCurrentJob());
                this.setCurrentJob(this.job);
            }
            if (this.jobs.launched) {
                this.getJobsReady().offerLast(this.jobs.getLaunchedValue());
            }
            if (this.jobs.waiting && this.getCurrentJob() == this.jobs.getWaitingValue()) {
                this.getJobsWaiting().offerLast(this.getCurrentJob());
                this.getCurrentJob().awaiting();
                this.setCurrentJob(null);
            }
            if (this.jobs.continuing) {
                this.setJob(this.jobs.getContinuingValue());
                this.getJobsWaiting().remove(this.getJob());
                this.getJob().ready();
                this.getJobsReady().offerLast(this.getJob());
            }
            if (this.work.done) {
                this.getJobsDone().offerLast(this.getCurrentJob());
                this.getCurrentJob().done();
                this.setCurrentJob(this.currentJob.getPrevious());
            }
            if (this.getCurrentJob() == null) {
                this.setCurrentJob(this.jobsReady.pollFirst());
            }
            transitioned_after = this.main_busy_react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_busy_r_process_invocation__region0_regular_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && this.suspend) {
            this.exitSequence_main_busy_r_process_invocation__region0_regular();
            this.react_main_busy_r_process_invocation__region0__choice_0();
            transitioned_after = 0L;
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.main_busy_r_process_invocation_react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_busy_r_process_invocation__region0_process_recursive_invocations_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && this.continueEvent) {
            this.exitSequence_main_busy_r_process_invocation__region0_process_recursive_invocations();
            this.react_main_busy_r_process_invocation__region0__choice_0();
            transitioned_after = 0L;
        }
        if (transitioned_after == transitioned_before) {
            if (this.work.done) {
                this.raiseContinue();
            }
            transitioned_after = this.main_busy_r_process_invocation_react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_busy_r_suspending_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L) {
            if (this.work.suspended) {
                this.exitSequence_main_busy_r_suspending();
                this.enterSequence_main_busy_r_suspended_default();
                this.main_busy_react(0L);
                transitioned_after = 0L;
            } else if (this.work.done) {
                this.exitSequence_main_busy();
                this.react_main__choice_0();
                transitioned_after = 0L;
            }
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.main_busy_react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_busy_r_suspended_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && this.resume) {
            this.exitSequence_main_busy_r_suspended();
            this.enterSequence_main_busy_r_process_invocation_default();
            this.main_busy_react(0L);
            transitioned_after = 0L;
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.main_busy_react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_terminating_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && (this.work.suspended || this.work.done)) {
            this.exitSequence_main_terminating();
            this.setCurrentJob(null);
            this.getJobsDone().clear();
            this.operationCallback.cleanupMemory();
            this.enterSequence_main_idle_default();
            this.react(0L);
            transitioned_after = 0L;
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.react(transitioned_before);
        }
        return transitioned_after;
    }

    public void triggerWithoutEvent() {
        this.runCycle();
    }

    public static class Jobs {
        private InterpreterControl parent;
        private boolean invoked;
        private SRuntimeInterpreter.Job invokedValue;
        private boolean launched;
        private SRuntimeInterpreter.Job launchedValue;
        private boolean waiting;
        private SRuntimeInterpreter.Job waitingValue;
        private boolean continuing;
        private SRuntimeInterpreter.Job continuingValue;

        public Jobs(InterpreterControl parent) {
            this.parent = parent;
        }

        public void raiseInvoked(SRuntimeInterpreter.Job value) {
            this.parent.inEventQueue.add(() -> {
                this.invokedValue = value;
                this.invoked = true;
            });
            this.parent.runCycle();
        }

        protected SRuntimeInterpreter.Job getInvokedValue() {
            if (!this.invoked) {
                throw new IllegalStateException("Illegal event value access. Event Invoked is not raised!");
            }
            return this.invokedValue;
        }

        public void raiseLaunched(SRuntimeInterpreter.Job value) {
            this.parent.inEventQueue.add(() -> {
                this.launchedValue = value;
                this.launched = true;
            });
            this.parent.runCycle();
        }

        protected SRuntimeInterpreter.Job getLaunchedValue() {
            if (!this.launched) {
                throw new IllegalStateException("Illegal event value access. Event Launched is not raised!");
            }
            return this.launchedValue;
        }

        public void raiseWaiting(SRuntimeInterpreter.Job value) {
            this.parent.inEventQueue.add(() -> {
                this.waitingValue = value;
                this.waiting = true;
            });
            this.parent.runCycle();
        }

        protected SRuntimeInterpreter.Job getWaitingValue() {
            if (!this.waiting) {
                throw new IllegalStateException("Illegal event value access. Event Waiting is not raised!");
            }
            return this.waitingValue;
        }

        public void raiseContinuing(SRuntimeInterpreter.Job value) {
            this.parent.inEventQueue.add(() -> {
                this.continuingValue = value;
                this.continuing = true;
            });
            this.parent.runCycle();
        }

        protected SRuntimeInterpreter.Job getContinuingValue() {
            if (!this.continuing) {
                throw new IllegalStateException("Illegal event value access. Event Continuing is not raised!");
            }
            return this.continuingValue;
        }
    }

    public static interface OperationCallback {
        public void resetStatistics();

        public void cleanupMemory();
    }

    public static enum State {
        MAIN_IDLE,
        MAIN_BUSY,
        MAIN_BUSY_R_PROCESS_INVOCATION,
        MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_REGULAR,
        MAIN_BUSY_R_PROCESS_INVOCATION__REGION0_PROCESS_RECURSIVE_INVOCATIONS,
        MAIN_BUSY_R_SUSPENDING,
        MAIN_BUSY_R_SUSPENDED,
        MAIN_TERMINATING,
        $NULLSTATE$;

    }

    public static class Work {
        private InterpreterControl parent;
        private boolean begin;
        private boolean done;
        private boolean suspended;
        private boolean canContinueWork;
        private boolean canAcceptNewWork;

        public Work(InterpreterControl parent) {
            this.parent = parent;
        }

        public void raiseBegin() {
            this.parent.inEventQueue.add(() -> {
                this.begin = true;
            });
            this.parent.runCycle();
        }

        public void raiseDone() {
            this.parent.inEventQueue.add(() -> {
                this.done = true;
            });
            this.parent.runCycle();
        }

        public void raiseSuspended() {
            this.parent.inEventQueue.add(() -> {
                this.suspended = true;
            });
            this.parent.runCycle();
        }

        public boolean getCanContinueWork() {
            return this.canContinueWork;
        }

        protected void setCanContinueWork(boolean value) {
            this.canContinueWork = value;
        }

        public boolean getCanAcceptNewWork() {
            return this.canAcceptNewWork;
        }

        protected void setCanAcceptNewWork(boolean value) {
            this.canAcceptNewWork = value;
        }
    }
}

