/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.base;

import com.google.common.collect.Iterables;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.InstanceSemantics;
import com.yakindu.base.expressions.interpreter.base.InterpreterAdapter;
import com.yakindu.base.expressions.interpreter.base.InterpreterControl;
import com.yakindu.base.expressions.interpreter.base.InterpreterException;
import com.yakindu.base.expressions.interpreter.base.InterpreterSuspendedException;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionArgument;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import com.yakindu.sct.model.sruntime.SRuntimeFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public abstract class SRuntimeInterpreter
implements IInterpreter,
IInterpreter.Control,
IInterpreter.Context,
InterpreterControl.OperationCallback {
    public static final String HEAP_SLOT_NAME = "heap";
    public static final String JOBS_SLOT_NAME = "#jobs";
    public static final String GLOBALS_SLOT_NAME = "#globals";
    @Extension
    protected SRuntimeFactory runtimeFactory = SRuntimeFactory.eINSTANCE;
    protected ExecutionContext heap;
    protected CompositeSlot jobsSlot;
    protected CompositeSlot globalsSlot;
    protected boolean debug = false;
    protected boolean isProcessing = false;
    protected int externalCallDepth = 0;
    protected InterpreterControl control;
    protected int instructionCount = 0;
    private final HashMap<ArrayList<?>, StringBuffer> _createCache_ident = CollectionLiterals.newHashMap();

    public SRuntimeInterpreter() {
        InterpreterControl _doubleArrow;
        InterpreterControl _interpreterControl = new InterpreterControl();
        Procedures.Procedure1 _function = it -> {
            it.setOperationCallback(this);
            it.enter();
        };
        this.control = _doubleArrow = (InterpreterControl)ObjectExtensions.operator_doubleArrow((Object)_interpreterControl, (Procedures.Procedure1)_function);
    }

    @Override
    public Object evaluate(Object program) {
        return this.evaluate(null, program);
    }

    @Override
    public Object evaluate(Object instance, Object program) {
        Runnable _function = () -> {
            if (instance != null) {
                this.defineVariable(InstanceSemantics.SELF_NAME, instance);
            }
            this.prepareExecution(program);
        };
        return this.process("_evaluate_", _function);
    }

    public abstract void prepareExecution(Object var1);

    @Override
    public void resume() {
        this.control.raiseResume();
        this.doProcess();
        boolean _suspended = this.suspended();
        if (_suspended) {
            throw new InterpreterSuspendedException();
        }
    }

    @Override
    public void suspend() {
        this.control.raiseSuspend();
    }

    @Override
    public void terminate() {
        this.control.raiseTerminate();
    }

    @Override
    public Object popValue() {
        Object v = this.stack().peek();
        if (v instanceof Frame) {
            throw new InterpreterException("No value on stack.");
        }
        this.stack().pop();
        Functions.Function0 _function = () -> {
            StringConcatenation _builder = new StringConcatenation();
            StringBuffer _ident = this.ident();
            _builder.append((Object)_ident);
            _builder.append("    < ");
            CharSequence _description = this.description(v);
            _builder.append((Object)_description);
            _builder.append(" ");
            Functions.Function1 _function_1 = it -> this.description(it);
            Iterable _map = IterableExtensions.map(this.stack(), (Functions.Function1)_function_1);
            _builder.append((Object)_map);
            return _builder.toString();
        };
        this.logDebug(_function);
        return v;
    }

    @Override
    public void pushValue(Object value) {
        if (value != null) {
            this.stack().push(value);
            if (value instanceof Frame) {
                Functions.Function0 _function = () -> {
                    StringConcatenation _builder = new StringConcatenation();
                    StringBuffer _ident = this.ident();
                    _builder.append((Object)_ident);
                    _builder.append(">> ");
                    CharSequence _description = this.description(value);
                    _builder.append((Object)_description);
                    _builder.append("  ");
                    Functions.Function1 _function_1 = it -> this.description(it);
                    Iterable _map = IterableExtensions.map(this.stack(), (Functions.Function1)_function_1);
                    _builder.append((Object)_map);
                    return _builder.toString();
                };
                this.logDebug(_function);
                Job _currentJob = this.control.getCurrentJob();
                _currentJob.frameCount = this.control.getCurrentJob().frameCount + 1;
            } else {
                Functions.Function0 _function_1 = () -> {
                    StringConcatenation _builder = new StringConcatenation();
                    StringBuffer _ident = this.ident();
                    _builder.append((Object)_ident);
                    _builder.append("    > ");
                    CharSequence _description = this.description(value);
                    _builder.append((Object)_description);
                    _builder.append("  ");
                    Functions.Function1 _function_2 = it -> this.description(it);
                    Iterable _map = IterableExtensions.map(this.stack(), (Functions.Function1)_function_2);
                    _builder.append((Object)_map);
                    return _builder.toString();
                };
                this.logDebug(_function_1);
            }
        } else {
            throw new InterpreterException("missing value");
        }
    }

    @Override
    public void _launch(String description, Runnable r) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("launch<");
        _builder.append(description);
        _builder.append(">");
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            this.launch(description, r);
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.nextExecutions().add(this._promise(_builder.toString(), (Functions.Function0<Object>)_function));
    }

    @Override
    public IInterpreter.Result _async(String description, Runnable r) {
        JobResult result = new JobResult();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("async<");
        _builder.append(description);
        _builder.append(">");
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            jobResult.provider = this.launch(description, r);
            jobResult.context = this;
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.nextExecutions().add(this._promise(_builder.toString(), (Functions.Function0<Object>)_function));
        return result;
    }

    @Override
    public void _await(IInterpreter.Result result, String description, Procedures.Procedure1<? super Object> onResult) {
        if (result instanceof JobResult) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("result<");
            _builder.append(description);
            _builder.append(">");
            Functions.Function0 _function = () -> null;
            ((JobResult)result).onResult = this._then(this._promise(_builder.toString(), (Functions.Function0<Object>)_function), onResult);
            ((JobResult)result).receiver = this.control.getCurrentJob();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("await<");
            _builder_1.append(description);
            _builder_1.append(">");
            Functions.Function0 _function_1 = () -> {
                Object _xblockexpression = null;
                this.control.jobs.raiseWaiting(((JobResult)result).receiver);
                this.syncJobs();
                _xblockexpression = null;
                return _xblockexpression;
            };
            this.nextExecutions().add(this._promise(_builder_1.toString(), (Functions.Function0<Object>)_function_1));
        }
    }

    @Override
    public void _provide(IInterpreter.Result result) {
        if (result instanceof JobResult && ((JobResult)result).receiver != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("provide<");
            CharSequence _description = this.description(this);
            _builder.append((Object)_description);
            _builder.append(">");
            Functions.Function0 _function = () -> {
                Object _xblockexpression = null;
                this.control.jobs.raiseContinuing(((JobResult)result).receiver);
                this.syncJobs();
                _xblockexpression = null;
                return _xblockexpression;
            };
            this.nextExecutions().add(this._promise(_builder.toString(), (Functions.Function0<Object>)_function));
        }
    }

    @Override
    public void _execute(String description, Runnable r) {
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            r.run();
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.nextExecutions().add(this._promise(description, (Functions.Function0<Object>)_function));
    }

    @Override
    public void _return(String description, Functions.Function0<?> f) {
        Procedures.Procedure1 _function = v -> this.pushValue(v);
        this.nextExecutions().add(this._then(this._promise(description, f), (Procedures.Procedure1<? super Object>)_function));
    }

    @Override
    public void _try(String description, Runnable doTry, Procedures.Procedure1<? super Throwable> doCatch) {
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            this.enterTry(description, doCatch);
            this._execute("try", doTry);
            Runnable _function_1 = () -> this.exitTry();
            this._execute("end try", _function_1);
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.nextExecutions().add(this._promise("begin try", (Functions.Function0<Object>)_function));
    }

    @Override
    public void _throw(Throwable throwable) {
        try {
            Object stackValue = null;
            while (!((stackValue = this.popAny()) instanceof TryFrame) && !this.stack().isEmpty()) {
            }
            if (!(stackValue instanceof TryFrame)) {
                throw throwable;
            }
            TryFrame tryFrame = (TryFrame)stackValue;
            Runnable _function = () -> tryFrame.catcher.apply((Object)throwable);
            this._execute("catch", _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void enterCall(String opName) {
        StackFrame frame = new StackFrame();
        frame.name = opName;
        this.pushFrame(frame);
    }

    @Override
    public void exitCall(Object returnValue) {
        while (!(this.popAny() instanceof StackFrame)) {
        }
        if (returnValue != null) {
            this.pushValue(returnValue);
        }
    }

    @Override
    public <T> T externalCall(Functions.Function0<T> f) {
        try {
            int _externalCallDepth = this.externalCallDepth;
            this.externalCallDepth = _externalCallDepth + 1;
            Object object = f.apply();
            return (T)object;
        }
        finally {
            int _externalCallDepth_1 = this.externalCallDepth;
            this.externalCallDepth = _externalCallDepth_1 - 1;
        }
    }

    protected boolean isInExternalCall() {
        return this.externalCallDepth > 0;
    }

    @Override
    public Object defineVariable(String name, Object value) {
        ExecutionArgument __variable = this._variable(name, value);
        Procedures.Procedure1 _function = it -> this.localScope().getSlots().add(it);
        return ObjectExtensions.operator_doubleArrow((Object)__variable, (Procedures.Procedure1)_function);
    }

    protected ExecutionArgument _variable(String name, Object value) {
        ExecutionArgument _createExecutionArgument = this.runtimeFactory.createExecutionArgument();
        Procedures.Procedure1 _function = v -> {
            v.setName(name);
            v.setValue(value);
        };
        return (ExecutionArgument)ObjectExtensions.operator_doubleArrow((Object)_createExecutionArgument, (Procedures.Procedure1)_function);
    }

    public ExecutionContext getHeap() {
        return this.heap;
    }

    public ExecutionContext setHeap(ExecutionContext ctx) {
        this.heap = ctx;
        return this.heap;
    }

    @Override
    public void cleanupMemory() {
        ExecutionContext _doubleArrow_2;
        CompositeSlot _doubleArrow_1;
        CompositeSlot _doubleArrow;
        CompositeSlot _createCompositeSlot = this.runtimeFactory.createCompositeSlot();
        Procedures.Procedure1 _function = it -> {
            it.setName(JOBS_SLOT_NAME);
            it.setVisible(true);
        };
        this.jobsSlot = _doubleArrow = (CompositeSlot)ObjectExtensions.operator_doubleArrow((Object)_createCompositeSlot, (Procedures.Procedure1)_function);
        CompositeSlot _createCompositeSlot_1 = this.runtimeFactory.createCompositeSlot();
        Procedures.Procedure1 _function_1 = it -> {
            it.setName(GLOBALS_SLOT_NAME);
            it.setVisible(true);
        };
        this.globalsSlot = _doubleArrow_1 = (CompositeSlot)ObjectExtensions.operator_doubleArrow((Object)_createCompositeSlot_1, (Procedures.Procedure1)_function_1);
        ExecutionContext _createExecutionContext = this.runtimeFactory.createExecutionContext();
        Procedures.Procedure1 _function_2 = it -> {
            it.setName(HEAP_SLOT_NAME);
            it.setFqName(HEAP_SLOT_NAME);
            InterpreterAdapter.adaptInterpreter((EObject)it, this);
            List _slots = it.getSlots();
            _slots.add(this.jobsSlot);
            List _slots_1 = it.getSlots();
            _slots_1.add(this.globalsSlot);
        };
        this.heap = _doubleArrow_2 = (ExecutionContext)ObjectExtensions.operator_doubleArrow((Object)_createExecutionContext, (Procedures.Procedure1)_function_2);
        this.resetStatistics();
    }

    public synchronized Object process(String name, Runnable action) {
        Object _xblockexpression = null;
        Job _job = new Job();
        Procedures.Procedure1 _function = it -> {
            Runnable _function_1;
            it.name = name;
            it.onStart = _function_1 = () -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("process<");
                _builder.append(name);
                _builder.append(">");
                this.enterCall(_builder.toString());
                action.run();
            };
        };
        Job job = (Job)ObjectExtensions.operator_doubleArrow((Object)_job, (Procedures.Procedure1)_function);
        this.control.jobs.raiseInvoked(job);
        _xblockexpression = this.doProcessJob();
        return _xblockexpression;
    }

    public synchronized Job launch(String name, Runnable action) {
        Job _job = new Job();
        Procedures.Procedure1 _function = it -> {
            Runnable _function_1;
            it.name = name;
            it.onStart = _function_1 = () -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("launch<");
                _builder.append(name);
                _builder.append(">");
                this.enterCall(_builder.toString());
                action.run();
            };
        };
        Job job = (Job)ObjectExtensions.operator_doubleArrow((Object)_job, (Procedures.Procedure1)_function);
        this.control.jobs.raiseLaunched(job);
        this.syncJobs();
        return job;
    }

    protected Object doProcessJob() {
        this.control.getCurrentJob().start();
        this.doProcess();
        boolean _suspended = this.suspended();
        if (_suspended) {
            throw new InterpreterSuspendedException();
        }
        Deque<Object> _stack = this.control.getJobsDone().peekLast().stack;
        Object _peek = null;
        if (_stack != null) {
            _peek = _stack.peek();
        }
        return _peek;
    }

    /*
     * Exception decompiling
     */
    protected void doProcess() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean canDoProcess() {
        return this.control.isStateActive(InterpreterControl.State.MAIN_BUSY_R_PROCESS_INVOCATION);
    }

    protected boolean suspended() {
        return this.control.isStateActive(InterpreterControl.State.MAIN_BUSY_R_SUSPENDED);
    }

    protected Job currentJob() {
        return this.control.getCurrentJob();
    }

    protected Deque<Object> stack() {
        Job _currentJob = this.currentJob();
        Deque<Object> _stack = null;
        if (_currentJob != null) {
            _stack = _currentJob.stack;
        }
        return _stack;
    }

    protected List<Promise> nextExecutions() {
        Job _currentJob = this.currentJob();
        List<Promise> _executions = null;
        if (_currentJob != null) {
            _executions = _currentJob.executions;
        }
        return _executions;
    }

    protected void activateNextExecutions() {
        Functions.Function0 _function = () -> {
            String _xifexpression = null;
            boolean _isEmpty = this.nextExecutions().isEmpty();
            if (_isEmpty) {
                _xifexpression = null;
            } else {
                StringConcatenation _builder = new StringConcatenation();
                StringBuffer _ident = this.ident();
                _builder.append((Object)_ident);
                _builder.append("    ");
                Functions.Function1 _function_1 = it -> it.description;
                List _map = ListExtensions.map(this.nextExecutions(), (Functions.Function1)_function_1);
                _builder.append((Object)_map);
                _builder.append(" + ");
                Functions.Function1 _function_2 = it -> it.description;
                Iterable _map_1 = IterableExtensions.map(this.currentFrame().executionQueue, (Functions.Function1)_function_2);
                _builder.append((Object)_map_1);
                _xifexpression = _builder.toString();
            }
            return _xifexpression;
        };
        this.logDebug(_function);
        Consumer<Promise> _function_1 = it -> {
            Frame _currentFrame = this.currentFrame();
            Deque<Promise> _executionQueue = null;
            if (_currentFrame != null) {
                _executionQueue = _currentFrame.executionQueue;
            }
            if (_executionQueue != null) {
                _executionQueue.push((Promise)it);
            }
        };
        ListExtensions.reverseView(this.nextExecutions()).forEach(_function_1);
        this.nextExecutions().clear();
    }

    public StackFrame currentStackFrame() {
        Deque<Object> _stack = this.stack();
        Object _findFirst = null;
        if (_stack != null) {
            Functions.Function1 _function = it -> it instanceof StackFrame;
            _findFirst = IterableExtensions.findFirst(_stack, (Functions.Function1)_function);
        }
        return (StackFrame)_findFirst;
    }

    protected ExecutionContext localScope() {
        StackFrame _currentStackFrame = this.currentStackFrame();
        ExecutionContext _variables = null;
        if (_currentStackFrame != null) {
            _variables = _currentStackFrame.variables;
        }
        return _variables;
    }

    public CompositeSlot SELF() {
        ExecutionContext _localScope = this.localScope();
        Object _resolve = null;
        if (_localScope != null) {
            _resolve = this.resolve(_localScope, InstanceSemantics.SELF_NAME);
        }
        Object _value = this.getValue(_resolve);
        return (CompositeSlot)_value;
    }

    @Override
    public Object getSelf() {
        return this.SELF();
    }

    public Frame currentFrame() {
        Deque<Object> _stack = this.stack();
        Object _findFirst = null;
        if (_stack != null) {
            Functions.Function1 _function = it -> it instanceof Frame;
            _findFirst = IterableExtensions.findFirst(_stack, (Functions.Function1)_function);
        }
        return (Frame)_findFirst;
    }

    protected int pushFrame(Frame value) {
        int _xifexpression = 0;
        if (value == null) {
            throw new InterpreterException("missing value");
        }
        int _xblockexpression = 0;
        this.stack().push(value);
        Functions.Function0 _function = () -> {
            StringConcatenation _builder = new StringConcatenation();
            StringBuffer _ident = this.ident();
            _builder.append((Object)_ident);
            _builder.append(">> ");
            CharSequence _description = this.description(value);
            _builder.append((Object)_description);
            _builder.append("  ");
            Functions.Function1 _function_1 = it -> this.description(it);
            Iterable _map = IterableExtensions.map(this.stack(), (Functions.Function1)_function_1);
            _builder.append((Object)_map);
            return _builder.toString();
        };
        this.logDebug(_function);
        Job _currentJob = this.currentJob();
        _xifexpression = _xblockexpression = (_currentJob.frameCount = this.currentJob().frameCount + 1);
        return _xifexpression;
    }

    protected Object popAny() {
        Object v = this.stack().pop();
        if (v instanceof Frame) {
            Job _currentJob = this.control.getCurrentJob();
            _currentJob.frameCount = this.control.getCurrentJob().frameCount - 1;
            Functions.Function0 _function = () -> {
                StringConcatenation _builder = new StringConcatenation();
                StringBuffer _ident = this.ident();
                _builder.append((Object)_ident);
                _builder.append("<< ");
                CharSequence _description = this.description(v);
                _builder.append((Object)_description);
                _builder.append(" ");
                Functions.Function1 _function_1 = it -> this.description(it);
                Iterable _map = IterableExtensions.map(this.stack(), (Functions.Function1)_function_1);
                _builder.append((Object)_map);
                return _builder.toString();
            };
            this.logDebug(_function);
        } else {
            Functions.Function0 _function_1 = () -> {
                StringConcatenation _builder = new StringConcatenation();
                StringBuffer _ident = this.ident();
                _builder.append((Object)_ident);
                _builder.append("    < ");
                CharSequence _description = this.description(v);
                _builder.append((Object)_description);
                _builder.append(" ");
                Functions.Function1 _function_2 = it -> this.description(it);
                Iterable _map = IterableExtensions.map(this.stack(), (Functions.Function1)_function_2);
                _builder.append((Object)_map);
                return _builder.toString();
            };
            this.logDebug(_function_1);
        }
        return v;
    }

    protected int enterTry(String opName, Procedures.Procedure1<? super Throwable> doCatch) {
        int _xblockexpression = 0;
        TryFrame frame = new TryFrame();
        frame.name = opName;
        frame.catcher = doCatch;
        _xblockexpression = this.pushFrame(frame);
        return _xblockexpression;
    }

    protected void exitTry() {
        Functions.Function1 _function = it -> it instanceof TryFrame;
        Object frame = IterableExtensions.findFirst(this.stack(), (Functions.Function1)_function);
        if (frame != null) {
            this.stack().remove(frame);
            Job _currentJob = this.control.getCurrentJob();
            _currentJob.frameCount = this.control.getCurrentJob().frameCount - 1;
            Functions.Function0 _function_1 = () -> {
                StringConcatenation _builder = new StringConcatenation();
                StringBuffer _ident = this.ident();
                _builder.append((Object)_ident);
                _builder.append("<< ");
                CharSequence _description = this.description(frame);
                _builder.append((Object)_description);
                _builder.append(" ");
                Functions.Function1 _function_2 = it -> this.description(it);
                Iterable _map = IterableExtensions.map(this.stack(), (Functions.Function1)_function_2);
                _builder.append((Object)_map);
                return _builder.toString();
            };
            this.logDebug(_function_1);
        }
    }

    protected boolean hasExecutionItem() {
        return this.currentFrame() != null && !this.currentFrame().executionQueue.isEmpty();
    }

    protected void syncJobs() {
        boolean _tripleNotEquals;
        ArrayList<Job> jobs = new ArrayList<Job>();
        Deque<Job> _jobsDone = this.control.getJobsDone();
        Iterables.addAll(jobs, _jobsDone);
        Job _currentJob = this.control.getCurrentJob();
        boolean bl = _tripleNotEquals = _currentJob != null;
        if (_tripleNotEquals) {
            Job _currentJob_1 = this.control.getCurrentJob();
            jobs.add(_currentJob_1);
        }
        Deque<Job> _jobsReady = this.control.getJobsReady();
        Iterables.addAll(jobs, _jobsReady);
        Deque<Job> _jobsWaiting = this.control.getJobsWaiting();
        Iterables.addAll(jobs, _jobsWaiting);
        this.jobsSlot.getSlots().clear();
        Consumer<Job> _function = job -> {
            List _slots = this.jobsSlot.getSlots();
            ExecutionVariable _createExecutionVariable = this.runtimeFactory.createExecutionVariable();
            Procedures.Procedure1 _function_1 = it -> {
                it.setName(job.name);
                it.setValue(job);
            };
            ExecutionVariable _doubleArrow = (ExecutionVariable)ObjectExtensions.operator_doubleArrow((Object)_createExecutionVariable, (Procedures.Procedure1)_function_1);
            _slots.add(_doubleArrow);
        };
        jobs.forEach(_function);
    }

    protected Promise _promise(String desc, Functions.Function0<Object> f) {
        Promise _promise = new Promise();
        Procedures.Procedure1 _function = it -> {
            it.execution = f;
            it.description = desc;
        };
        return (Promise)ObjectExtensions.operator_doubleArrow((Object)_promise, (Procedures.Procedure1)_function);
    }

    protected Promise _then(Promise it, Procedures.Procedure1<? super Object> then) {
        it.then = then;
        return it;
    }

    @Override
    public void resetStatistics() {
        this.instructionCount = 0;
    }

    protected CharSequence _description(Object it) {
        return it.toString();
    }

    protected CharSequence _description(StackFrame it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("frame<");
        _builder.append(it.name);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _description(TryFrame it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("try<");
        _builder.append(it.name);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _description(ExecutionVariable it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("var<");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _description(ExecutionEvent it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("event<");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _description(CompositeSlot it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("obj<");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _description(ReferenceSlot it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ref<");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _description(ExecutionArgument it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("arg<");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _description(IInterpreter.Null it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("null");
        return _builder;
    }

    public StringBuffer ident() {
        return this.ident(this.control.getCurrentJob().frameCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer ident(int n) {
        StringBuffer _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Integer[]{n});
        HashMap<ArrayList<?>, StringBuffer> hashMap = this._createCache_ident;
        synchronized (hashMap) {
            StringBuffer _stringBuffer;
            if (this._createCache_ident.containsKey(_cacheKey)) {
                return this._createCache_ident.get(_cacheKey);
            }
            _result = _stringBuffer = new StringBuffer();
            this._createCache_ident.put(_cacheKey, _result);
        }
        this._init_ident(_result, n);
        return _result;
    }

    private void _init_ident(StringBuffer it, int n) {
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, n, true);
        for (Integer i : _doubleDotLessThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("    ");
            it.append((CharSequence)_builder);
        }
    }

    public void logDebug(Functions.Function0<?> it) {
        Object output;
        if (this.debug && (output = it.apply()) != null) {
            System.out.println(it.apply());
        }
    }

    @XbaseGenerated
    public CharSequence description(Object it) {
        if (it instanceof ReferenceSlot) {
            return this._description((ReferenceSlot)it);
        }
        if (it instanceof CompositeSlot) {
            return this._description((CompositeSlot)it);
        }
        if (it instanceof ExecutionArgument) {
            return this._description((ExecutionArgument)it);
        }
        if (it instanceof ExecutionEvent) {
            return this._description((ExecutionEvent)it);
        }
        if (it instanceof ExecutionVariable) {
            return this._description((ExecutionVariable)it);
        }
        if (it instanceof StackFrame) {
            return this._description((StackFrame)it);
        }
        if (it instanceof TryFrame) {
            return this._description((TryFrame)it);
        }
        if (it instanceof IInterpreter.Null) {
            return this._description((IInterpreter.Null)it);
        }
        if (it != null) {
            return this._description(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    private /* synthetic */ Object lambda$27(Job job) {
        StringConcatenation _builder = new StringConcatenation();
        StringBuffer _ident = this.ident();
        _builder.append((Object)_ident);
        _builder.append("process job <");
        _builder.append(job.name);
        _builder.append(">");
        return _builder.toString();
    }

    private /* synthetic */ Object lambda$28(Promise promise) {
        StringConcatenation _builder = new StringConcatenation();
        StringBuffer _ident = this.ident();
        _builder.append((Object)_ident);
        _builder.append(promise.description);
        return _builder.toString();
    }

    private /* synthetic */ Object lambda$29(Job job) {
        StringConcatenation _builder = new StringConcatenation();
        StringBuffer _ident = this.ident();
        _builder.append((Object)_ident);
        _builder.append("interrupted job <");
        _builder.append(job.name);
        _builder.append(">");
        return _builder.toString();
    }

    private /* synthetic */ Object lambda$30() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("processed ");
        _builder.append((Object)this.instructionCount);
        _builder.append(" instructions");
        return _builder.toString();
    }

    private /* synthetic */ CharSequence lambda$31(StackFrame it) {
        return this.description(it);
    }

    @Data
    public static class EventInstance {
        public final ExecutionEvent event;
        public final Object value;

        public EventInstance(ExecutionEvent ev, Object value) {
            this.event = ev;
            this.value = value;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
            return 31 * result + (this.value == null ? 0 : this.value.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventInstance other = (EventInstance)obj;
            if (this.event == null ? other.event != null : !this.event.equals(other.event)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("event", (Object)this.event);
            b.add("value", this.value);
            return b.toString();
        }

        @Pure
        public ExecutionEvent getEvent() {
            return this.event;
        }

        @Pure
        public Object getValue() {
            return this.value;
        }
    }

    public static class Frame {
        public String name;
        protected Deque<Promise> executionQueue = new ArrayDeque<Promise>();
    }

    public static class Job {
        @Accessors
        private String name;
        @Accessors(value={AccessorType.PRIVATE_GETTER})
        private State state = State.NEW;
        @Accessors
        private Runnable onStart;
        @Accessors
        private Runnable onContinue;
        @Accessors
        private Deque<Object> stack = new ArrayDeque<Object>();
        @Accessors
        private List<Promise> executions = new ArrayList<Promise>();
        @Accessors
        private Job previous = null;
        @Accessors
        private int frameCount = 0;

        public void start() {
            boolean _equals = Objects.equals((Object)this.state, (Object)State.NEW);
            if (_equals) {
                this.state = State.EXECUTING;
                this.onStart.run();
            } else {
                boolean _equals_1 = Objects.equals((Object)this.state, (Object)State.READY);
                if (_equals_1) {
                    this.state = State.EXECUTING;
                    this.onContinue.run();
                }
            }
        }

        public void awaiting() {
            boolean _equals = Objects.equals((Object)this.state, (Object)State.EXECUTING);
            if (_equals) {
                this.state = State.AWAITING;
            }
        }

        public void done() {
            boolean _equals = Objects.equals((Object)this.state, (Object)State.EXECUTING);
            if (_equals) {
                this.state = State.DONE;
            }
        }

        public void ready() {
            boolean _equals = Objects.equals((Object)this.state, (Object)State.AWAITING);
            if (_equals) {
                this.state = State.READY;
            }
        }

        public String toString() {
            return this.state.name();
        }

        @Pure
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Pure
        private State getState() {
            return this.state;
        }

        @Pure
        public Runnable getOnStart() {
            return this.onStart;
        }

        public void setOnStart(Runnable onStart) {
            this.onStart = onStart;
        }

        @Pure
        public Runnable getOnContinue() {
            return this.onContinue;
        }

        public void setOnContinue(Runnable onContinue) {
            this.onContinue = onContinue;
        }

        @Pure
        public Deque<Object> getStack() {
            return this.stack;
        }

        public void setStack(Deque<Object> stack) {
            this.stack = stack;
        }

        @Pure
        public List<Promise> getExecutions() {
            return this.executions;
        }

        public void setExecutions(List<Promise> executions) {
            this.executions = executions;
        }

        @Pure
        public Job getPrevious() {
            return this.previous;
        }

        public void setPrevious(Job previous) {
            this.previous = previous;
        }

        @Pure
        public int getFrameCount() {
            return this.frameCount;
        }

        public void setFrameCount(int frameCount) {
            this.frameCount = frameCount;
        }

        public static enum State {
            NEW,
            EXECUTING,
            AWAITING,
            READY,
            DONE;

        }
    }

    public static class JobResult
    implements IInterpreter.Result {
        @Accessors
        private Job provider;
        @Accessors
        private Job receiver;
        @Accessors
        private Promise onResult;
        @Accessors
        private IInterpreter.Context context;
        protected Optional<Object> value = Optional.empty();

        @Override
        public void provide(Object value) {
            this.value = Optional.of(value);
            if (this.receiver != null) {
                Runnable _function;
                this.receiver.onContinue = _function = () -> {
                    if (this.context != null) {
                        this.context.pushValue(value);
                    }
                    this.onResult.then.apply(value);
                };
            }
            this.context._provide(this);
        }

        @Override
        public Optional<Object> value() {
            return this.value;
        }

        @Pure
        public Job getProvider() {
            return this.provider;
        }

        public void setProvider(Job provider) {
            this.provider = provider;
        }

        @Pure
        public Job getReceiver() {
            return this.receiver;
        }

        public void setReceiver(Job receiver) {
            this.receiver = receiver;
        }

        @Pure
        public Promise getOnResult() {
            return this.onResult;
        }

        public void setOnResult(Promise onResult) {
            this.onResult = onResult;
        }

        @Pure
        public IInterpreter.Context getContext() {
            return this.context;
        }

        public void setContext(IInterpreter.Context context) {
            this.context = context;
        }
    }

    public static class Promise {
        @Extension
        protected Procedures.Procedure1<? super Object> then = null;
        protected Functions.Function0<?> execution = null;
        protected String description;

        public String getDescription() {
            return this.description;
        }

        public void setThen(Procedures.Procedure1<? super Object> then) {
            this.then = then;
        }

        public Procedures.Procedure1<? super Object> getThen() {
            return this.then;
        }

        public void setExecution(Functions.Function0<?> execution) {
            this.execution = execution;
        }

        public Functions.Function0<?> getExecution() {
            return this.execution;
        }

        public void execute() {
            Object result = this.execution.apply();
            if (this.then != null) {
                this.then.apply(result);
            }
        }
    }

    public static class StackFrame
    extends Frame {
        public ExecutionContext variables = SRuntimeFactory.eINSTANCE.createExecutionContext();
    }

    public static class TryFrame
    extends Frame {
        public Procedures.Procedure1<? super Throwable> catcher;
    }
}

