/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.inferrer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Singleton;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.DomainElement;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.GenericTypeSystem;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sctunit.inferrer.SCTUnitTypeInferrer;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class TypesProvider {
    private LoadingCache<String, ITypeSystemInferrer> typeSystemInferrerCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ITypeSystemInferrer>(){

        public ITypeSystemInferrer load(String id) throws Exception {
            return (ITypeSystemInferrer)DomainRegistry.getDomain((String)id).getInjector("com.yakindu.sct.resource", false, new String[0]).getInstance(ITypeSystemInferrer.class);
        }
    });
    private LoadingCache<String, ITypeSystem> typeSystemCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ITypeSystem>(){

        public ITypeSystem load(String id) throws Exception {
            return (ITypeSystem)DomainRegistry.getDomain((String)id).getInjector("com.yakindu.sct.resource", false, new String[0]).getInstance(ITypeSystem.class);
        }
    });

    public ITypeSystemInferrer getTypeSystemInferrer(EObject context) {
        try {
            String domainId = this.getDomainId(context);
            return (ITypeSystemInferrer)this.typeSystemInferrerCache.get((Object)domainId);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            String baseID = BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral();
            IDomain domain = DomainRegistry.getDomain((String)baseID);
            if (domain != null) {
                return (ITypeSystemInferrer)DomainRegistry.getDomain((String)baseID).getInjector("com.yakindu.sct.resource", false, new String[0]).getInstance(ITypeSystemInferrer.class);
            }
            return new SCTUnitTypeInferrer();
        }
    }

    protected String getDomainId(EObject context) {
        DomainElement domainElement = (DomainElement)EcoreUtil2.getContainerOfType((EObject)context, DomainElement.class);
        return domainElement != null ? domainElement.getDomainID() : BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral();
    }

    public ITypeSystem getTypeSystem(EObject context) {
        try {
            String domainId = this.getDomainId(context);
            return (ITypeSystem)this.typeSystemCache.get((Object)domainId);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            String baseID = BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral();
            IDomain domain = DomainRegistry.getDomain((String)baseID);
            if (domain != null) {
                return (ITypeSystem)DomainRegistry.getDomain((String)baseID).getInjector("com.yakindu.sct.resource", false, new String[0]).getInstance(ITypeSystem.class);
            }
            return GenericTypeSystem.getInstance();
        }
    }
}

