/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.validation;

import com.google.common.collect.Lists;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.Parameter;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.validation.BaseSCTUnitValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SCTUnitNamesAreUniqueValidator
extends BaseSCTUnitValidator {
    @Check
    public void checkUniqueness(VariableDefinition var) {
        SCTUnitOperation containingOperation = (SCTUnitOperation)EcoreUtil2.getContainerOfType((EObject)var, SCTUnitOperation.class);
        if (containingOperation != null) {
            List<NamedElement> parametersWithSameName;
            List allVariablesOfOperation = EcoreUtil2.getAllContentsOfType((EObject)containingOperation, VariableDefinition.class);
            List<NamedElement> variablesWithSameName = this.allObjectsWithSameName(allVariablesOfOperation, (NamedElement)var);
            if (variablesWithSameName.indexOf(var) > 0) {
                this.error("The variable is already defined", (EObject)var, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
            }
            if ((parametersWithSameName = this.allObjectsWithSameName((List<? extends NamedElement>)containingOperation.getParameters(), (NamedElement)var)).size() > 0) {
                this.error("The variable is already defined", (EObject)var, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
            }
        } else {
            List<VariableDefinition> variablesWithSameName;
            SCTUnitClass containingClass = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)var, SCTUnitClass.class);
            if (containingClass != null && (variablesWithSameName = this.findAllGlobalVariablesWithSameName((NamedElement)var, containingClass)).size() > 1 && variablesWithSameName.indexOf(var) > 0) {
                this.error("The variable is already defined", (EObject)var, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
            }
        }
    }

    @Check
    public void checkUniqueness(SCTUnitOperation op) {
        ArrayList allOperations;
        List<NamedElement> allOperationsWithSameName;
        SCTUnitClass containingClass = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)op, SCTUnitClass.class);
        if (containingClass != null && (allOperationsWithSameName = this.allObjectsWithSameName(allOperations = Lists.newArrayList((Iterable)IterableExtensions.filter((Iterable)containingClass.getFeatures(), SCTUnitOperation.class)), (NamedElement)op)).size() > 1 && allOperationsWithSameName.indexOf(op) > 0) {
            this.error("The operation is already defined", (EObject)op, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkUniqueness(Parameter param) {
        List<NamedElement> allParametersWithSameName;
        SCTUnitOperation containingOperation = (SCTUnitOperation)EcoreUtil2.getContainerOfType((EObject)param, SCTUnitOperation.class);
        if (containingOperation != null && (allParametersWithSameName = this.allObjectsWithSameName((List<? extends NamedElement>)containingOperation.getParameters(), (NamedElement)param)).size() > 1 && allParametersWithSameName.indexOf(param) > 0) {
            this.error("The parameter is already defined", (EObject)param, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkShadowing(VariableDefinition var) {
        List<VariableDefinition> allVariablesWithSameName;
        List<VariableDefinition> globalVariablesWithSameName;
        SCTUnitOperation containingOperation = (SCTUnitOperation)EcoreUtil2.getContainerOfType((EObject)var, SCTUnitOperation.class);
        SCTUnitClass containingClass = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)var, SCTUnitClass.class);
        if (containingOperation != null && containingClass != null && (globalVariablesWithSameName = this.findAllGlobalVariablesWithSameName((NamedElement)var, containingClass)).size() > 0) {
            this.warning("There is also a global variable with the same name. The global variable is now not accessible anymore.", (EObject)var, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        }
        if (containingClass != null && (allVariablesWithSameName = this.findStatechartVariablesWithSameName((NamedElement)var, containingClass)).size() > 0) {
            this.warning("There is also a variable in the statechart with the same name. The statechart variable is now not accessible anymore.", (EObject)var, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkShadowing(Parameter param) {
        SCTUnitClass containingClass = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)param, SCTUnitClass.class);
        if (containingClass != null) {
            List<VariableDefinition> allStatechartVariablesWithSameName;
            List<VariableDefinition> globalVariablesWithSameName = this.findAllGlobalVariablesWithSameName((NamedElement)param, containingClass);
            if (globalVariablesWithSameName.size() > 0) {
                this.warning("There is also a global variable with the same name. The global variable is now not accessible anymore.", (EObject)param, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
            }
            if ((allStatechartVariablesWithSameName = this.findStatechartVariablesWithSameName((NamedElement)param, containingClass)).size() > 0) {
                this.warning("There is also a variable in the statechart with the same name. The statechart variable is now not accessible anymore.", (EObject)param, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
            }
        }
    }

    protected List<NamedElement> allObjectsWithSameName(List<? extends NamedElement> objects, NamedElement object) {
        return StreamSupport.stream(objects.spliterator(), false).filter(it -> it.getName().equals(object.getName())).collect(Collectors.toList());
    }

    protected List<VariableDefinition> findAllGlobalVariablesWithSameName(NamedElement ele, SCTUnitClass containingClass) {
        List allGlobalVariables = StreamSupport.stream(containingClass.getVariableDefinitions().spliterator(), false).map(it -> it.getDefinition()).collect(Collectors.toList());
        List<VariableDefinition> variablesWithSameName = StreamSupport.stream(allGlobalVariables.spliterator(), false).filter(it -> it.getName().equals(ele.getName())).collect(Collectors.toList());
        return variablesWithSameName;
    }

    protected List<VariableDefinition> findStatechartVariablesWithSameName(NamedElement ele, SCTUnitClass containingClass) {
        List unnamedScopes;
        Statechart statechart = containingClass.getStatechart();
        List allInterfaceScopes = EcoreUtil2.getAllContentsOfType((EObject)statechart, InterfaceScope.class);
        if (!allInterfaceScopes.isEmpty() && !(unnamedScopes = StreamSupport.stream(allInterfaceScopes.spliterator(), false).filter(it -> it.getName() == null || it.getName().isEmpty()).collect(Collectors.toList())).isEmpty()) {
            InterfaceScope unnamedScope = (InterfaceScope)unnamedScopes.get(0);
            List allVariables = EcoreUtil2.getAllContentsOfType((EObject)unnamedScope, VariableDefinition.class);
            List<VariableDefinition> allVariablesWithSameName = StreamSupport.stream(allVariables.spliterator(), false).filter(it -> it.getName().equals(ele.getName())).collect(Collectors.toList());
            return allVariablesWithSameName;
        }
        return Lists.newArrayList();
    }
}

