/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EntryKind implements Enumerator
{
    INITIAL(0, "initial", "INITIAL"),
    SHALLOW_HISTORY(1, "shallowHistory", "SHALLOW_HISTORY"),
    DEEP_HISTORY(2, "deepHistory", "DEEP_HISTORY");

    public static final String copyright = "Copyright (c) 2011-2022 itemis AG - All rights Reserved\nUnauthorized copying of this file, via any medium is strictly prohibited.";
    public static final int INITIAL_VALUE = 0;
    public static final int SHALLOW_HISTORY_VALUE = 1;
    public static final int DEEP_HISTORY_VALUE = 2;
    private static final EntryKind[] VALUES_ARRAY;
    public static final List<EntryKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EntryKind[]{INITIAL, SHALLOW_HISTORY, DEEP_HISTORY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EntryKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntryKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntryKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntryKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntryKind get(int value) {
        switch (value) {
            case 0: {
                return INITIAL;
            }
            case 1: {
                return SHALLOW_HISTORY;
            }
            case 2: {
                return DEEP_HISTORY;
            }
        }
        return null;
    }

    private EntryKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

