/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.xtext.utils.gmf.experimental;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.LabelEx;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class StyledLabel
extends LabelEx {
    private StyleRange[] ranges = new StyleRange[0];
    private Image image;

    public StyleRange[] getRanges() {
        return this.ranges;
    }

    public void setRanges(StyleRange[] ranges) {
        this.ranges = ranges;
    }

    protected void updateImage() {
        Rectangle bounds = this.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        TextLayout layout = new TextLayout((Device)Display.getDefault());
        layout.setText(this.getText());
        StyleRange[] styleRangeArray = this.ranges;
        int n = this.ranges.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange styleRange = styleRangeArray[n2];
            layout.setStyle((TextStyle)styleRange, styleRange.start, styleRange.start + styleRange.length);
            ++n2;
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = new Image((Device)Display.getDefault(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)this.image);
        gc.setBackground(ColorConstants.red);
        layout.draw(gc, 0, 0);
        this.image.getImageData().transparentPixel = this.image.getImageData().palette.getPixel(ColorConstants.white.getRGB());
        layout.dispose();
        gc.dispose();
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        this.updateImage();
        if (this.image == null || this.ranges == null || this.ranges.length == 0 || this.isOpaque()) {
            return;
        }
        if (this.getIcon() != null) {
            graphics.drawImage(this.getIcon(), this.getIconLocation());
        }
        graphics.drawImage(this.image, this.getTextLocation());
        graphics.translate(-bounds.x, -bounds.y);
    }
}

