/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.core.filesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.generator.core.filesystem.PathUtil;
import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.parser.IEncodingProvider;

@Singleton
public class PathBasedFileSystemAccess
extends JavaIoFileSystemAccess
implements ISCTFileSystemAccess {
    @Inject(optional=true)
    @Named(value="filesystemAccess.absolute.baseDir")
    protected String absoluteBaseDir = "";
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    protected PathUtil util;

    @Override
    public void setContext(String baseDir) {
        this.absoluteBaseDir = baseDir;
    }

    @Override
    public void setOutputPath(String outputName, String path) {
        if (this.absoluteBaseDir.isEmpty()) {
            super.setOutputPath(outputName, this.util.expand(path));
        } else {
            super.setOutputPath(outputName, this.absoluteBaseDir + File.separator + path);
        }
    }

    protected String getEncoding(URI fileURI) {
        return this.encodingProvider.getEncoding(fileURI);
    }
}

