/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.container;

import com.yakindu.core.rx.Observable;
import com.yakindu.sct.simulation.core.SimulationCoreActivator;
import com.yakindu.sct.simulation.core.engine.IExecutionControl;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.emf.common.util.WrappedException;

public abstract class AbstractSimulationEngine
implements ISimulationEngine,
IExecutionControl {
    public static final String ERROR_MSG = "An unexpected error ocurred during simulation.";
    public static final int ERROR_DURING_SIMULATION = 765;
    protected boolean stepping = false;
    protected boolean terminated = false;
    protected boolean suspended = false;
    protected Observable<Void> modeChanged = new Observable();

    protected void handleException(Throwable t) {
        if (t instanceof WrappedException) {
            t = ((WrappedException)t).getCause();
        }
        String statusMessage = t.getMessage() == null ? ERROR_MSG : t.getMessage();
        Status errorStatus = new Status(4, "com.yakindu.sct.simulation.core", 765, statusMessage, t);
        SimulationCoreActivator.getDefault().getLog().log((IStatus)errorStatus);
        IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)errorStatus);
        try {
            statusHandler.handleStatus((IStatus)errorStatus, this.getDebugTarget());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected Object getDebugTarget() {
        IDebugTarget[] debugTargets;
        IDebugTarget[] iDebugTargetArray = debugTargets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int n = debugTargets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget iDebugTarget = iDebugTargetArray[n2];
            if (!iDebugTarget.isTerminated() && iDebugTarget.getAdapter(ISimulationEngine.class) == this) {
                return iDebugTarget;
            }
            ++n2;
        }
        return null;
    }

    public IExecutionControl getExecutionControl() {
        return this;
    }

    public boolean canTerminate() {
        return !this.terminated;
    }

    public void terminate() {
        this.terminated = true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean canResume() {
        return this.suspended && !this.terminated;
    }

    public void resume() {
        this.suspended = false;
    }

    public boolean canSuspend() {
        return !this.suspended && !this.terminated;
    }

    public void suspend() {
        this.suspended = true;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean canStepForward() {
        return this.isSuspended() && !this.isTerminated();
    }

    public boolean canStepBackward() {
        return false;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public Observable<Void> modeChanged() {
        return this.modeChanged;
    }
}

