/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.container;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import com.yakindu.sct.simulation.core.sexec.container.ExecutionFlowSimulationEngine;
import com.yakindu.sct.simulation.core.sexec.container.ISimulationEngineFactory;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DefaultSimulationEngineFactory
implements ISimulationEngineFactory {
    @Inject
    protected Injector injector;
    @Inject
    protected StatechartAnnotations annotations;

    @Override
    public ISimulationEngine createExecutionContainer(Statechart statechart, ILaunch launch) throws CoreException {
        String attribute;
        ISimulationEngine controller = this.createController(statechart);
        this.injector.injectMembers((Object)controller);
        if (launch != null && launch.getLaunchConfiguration() != null && (attribute = launch.getLaunchConfiguration().getAttribute("executionContext", "")) != null && attribute.trim().length() > 0) {
            ExecutionContext context = this.restore(attribute, statechart);
            controller.setExecutionContext(context);
        }
        return controller;
    }

    protected ISimulationEngine createController(Statechart statechart) throws CoreException {
        return new ExecutionFlowSimulationEngine(statechart);
    }

    protected ExecutionContext restore(String context, Statechart statechart) {
        Resource resource;
        ResourceSetImpl set;
        block3: {
            try {
                set = new ResourceSetImpl();
                resource = set.createResource(URI.createURI((String)"snapshot.xmi"));
                if (resource != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        set.getResources().add((Object)resource);
        resource.load((InputStream)new URIConverter.ReadableInputStream(context, "UTF_8"), Collections.emptyMap());
        IDomain domain = DomainRegistry.getDomain((EObject)statechart);
        Injector injector = domain.getInjector("com.yakindu.sct.simulation", new String[0]);
        ITypeSystem typeSystem = (ITypeSystem)injector.getInstance(ITypeSystem.class);
        set.getResources().add((Object)typeSystem.getResource());
        EcoreUtil.resolveAll((Resource)resource);
        ExecutionContext result = (ExecutionContext)resource.getContents().get(0);
        result.setSnapshot(true);
        return result;
    }
}

