/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.create.base.generator.csharp.artifacts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.itemis.create.base.generator.core.artifacts.IContent;
import com.itemis.create.base.generator.core.artifacts.IGenArtifact;
import com.itemis.create.base.generator.core.concepts.TimedInterface;
import com.itemis.create.base.generator.csharp.codepattern.CsharpLiterals;
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries;
import com.yakindu.base.types.Parameter;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class CsharpITimed
implements IContent,
IGenArtifact {
    @Inject
    @Extension
    protected TimedInterface _timedInterface;
    @Inject
    @Extension
    protected CsharpLiterals _csharpLiterals;
    @Inject
    protected GeneratorEntry entry;
    @Inject
    @Extension
    protected CsharpGenmodelEntries _csharpGenmodelEntries;

    public String content() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("namespace ");
        String _timerLibraryPackage = null;
        if (this.entry != null) {
            _timerLibraryPackage = this._csharpGenmodelEntries.getTimerLibraryPackage(this.entry);
        }
        _builder.append(_timerLibraryPackage);
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public interface ITimed");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <summary>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// Callback method if a time event occurred.");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// </summary>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <param name=\"eventID\">The id of the occurred event.</param>");
        _builder.newLine();
        _builder.append("        ");
        String _asLiteral = this._csharpLiterals.asLiteral(this._timedInterface.raiseTimeEventOp().getTypeSpecifier());
        _builder.append(_asLiteral, "        ");
        _builder.append(" ");
        String _name = this._timedInterface.raiseTimeEventOp().getName();
        _builder.append(_name, "        ");
        _builder.append("(");
        EList _parameters = this._timedInterface.raiseTimeEventOp().getParameters();
        boolean _hasElements = false;
        for (Parameter p : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "        ");
            }
            String _asLiteral_1 = this._csharpLiterals.asLiteral(p.getTypeSpecifier());
            _builder.append(_asLiteral_1, "        ");
            _builder.append(" ");
            String _name_1 = p.getName();
            _builder.append(_name_1, "        ");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <summary>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// Set the ITimerService for the state machine. It must be set");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// externally on a timed state machine before Enter() is called.");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// </summary>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <param name=\"timerService\">The timer service implementation to be set.</param>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("void SetTimerService(ITimerService timerService);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

