/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.create.base.generator.csharp.artifacts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.itemis.create.base.generator.core.artifacts.IContent;
import com.itemis.create.base.generator.core.artifacts.IGenArtifact;
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class CsharpITimerService
implements IContent,
IGenArtifact {
    @Inject
    protected GeneratorEntry entry;
    @Inject
    @Extension
    protected CsharpGenmodelEntries _csharpGenmodelEntries;

    public String content() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("namespace ");
        String _timerLibraryPackage = null;
        if (this.entry != null) {
            _timerLibraryPackage = this._csharpGenmodelEntries.getTimerLibraryPackage(this.entry);
        }
        _builder.append(_timerLibraryPackage);
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("public interface ITimerService");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <summary>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// Starts the timing for a given time event id.");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// </summary>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <param name=\"callback\">An ITimed object that is called when the timer expires.</param>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <param name=\"eventID\">The id of the state machine's time event.</param>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <param name=\"time\">Time in milliseconds after which the time event should be triggered.</param>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <param name=\"isPeriodic\">Set to true to trigger the time event periodically.</param>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("void SetTimer(ITimed callback, int eventID, long time, bool isPeriodic);");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <summary>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// Unsets a time event.");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// </summary>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <param name=\"callback\">An ITimed object that is called when the timer expires.</param>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("/// <param name=\"eventID\">The id of the state machine's time event.</param>");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("void UnsetTimer(ITimed callback, int eventID);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

