/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.create.base.generator.csharp.codemodel;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.itemis.create.base.generator.core.concepts.InternallyDefinedTypeAnnotation;
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.sct.types.resource.Statechart2TypeTransformation;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CsharpNaming {
    public static final String[] CSHARP_KEYWORDS = new String[]{"abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while", "value", "object", "_semaphore", "await", "async"};
    public static final String[] CSHARP_SYSTEM_KEYWORDS = new String[]{"System.Threading.Thread.CurrentThread.ManagedThreadId"};
    public static final String[] STATECHART_KEYWORDS = new String[]{"parent", "timerService", "timeEvents", "stateConfVector", "stateConfVectorPosition", "current", "isExecuting", "operationCallback"};
    protected final char separator = (char)95;
    @Inject
    @Extension
    protected CsharpVisibility _csharpVisibility;
    @Inject
    @Extension
    protected InternallyDefinedTypeAnnotation _internallyDefinedTypeAnnotation;
    @Inject
    @Extension
    protected Statechart2TypeTransformation _statechart2TypeTransformation;

    public void applyCsharpNamingConventions(EObject it) {
        Procedures.Procedure1 _function = it_1 -> this.applyCsharpName((NamedElement)it_1);
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)it.eAllContents(), NamedElement.class), (Procedures.Procedure1)_function);
    }

    protected void _applyCsharpName(NamedElement it) {
    }

    protected void _applyCsharpName(Operation it) {
        Object _xifexpression = null;
        boolean _isCsharpKeyword = this.isCsharpKeyword(this.csharpName(it));
        if (_isCsharpKeyword) {
            String _csharpName = this.csharpName(it);
            String _plus = _csharpName + String.valueOf(Character.valueOf('_'));
            _xifexpression = _plus + "ID";
        } else {
            _xifexpression = this.csharpName(it);
        }
        it.setName((String)_xifexpression);
    }

    protected void _applyCsharpName(ComplexType it) {
        boolean _isNamedIface = this._statechart2TypeTransformation.isNamedIface((EObject)it);
        if (_isNamedIface) {
            it.setName(it.getName().replaceFirst("Type", ""));
        }
        Object _xifexpression = null;
        boolean _isCsharpKeyword = this.isCsharpKeyword(this.csharpName(it));
        if (_isCsharpKeyword) {
            String _csharpName = this.csharpName(it);
            String _plus = _csharpName + String.valueOf(Character.valueOf('_'));
            _xifexpression = _plus + "ID";
        } else {
            _xifexpression = this.csharpName(it);
        }
        it.setName((String)_xifexpression);
    }

    protected void _applyCsharpName(Property it) {
        Object _xifexpression = null;
        if ((this.isCsharpKeyword(this.csharpName(it)) || this.isStatechartKeyword(this.csharpName(it))) && !this._internallyDefinedTypeAnnotation.isInternallyDefinedType((AnnotatableElement)it)) {
            String _csharpName = this.csharpName(it);
            String _plus = _csharpName + String.valueOf(Character.valueOf('_'));
            _xifexpression = _plus + "ID";
        } else {
            _xifexpression = this.csharpName(it);
        }
        it.setName((String)_xifexpression);
    }

    public String csharpName(ComplexType it) {
        return StringExtensions.toFirstUpper((String)this.asIdentifier(it.getName()));
    }

    public String csharpName(Operation it) {
        return StringExtensions.toFirstUpper((String)this.asIdentifier(it.getName()));
    }

    public String csharpName(Property it) {
        String _xifexpression = null;
        boolean _isCsharpSystemKeyword = this.isCsharpSystemKeyword(it.getName());
        if (_isCsharpSystemKeyword) {
            _xifexpression = it.getName();
        } else {
            String _xifexpression_1 = null;
            _xifexpression_1 = this._csharpVisibility.isPrivate((AnnotatableElement)it) || this._csharpVisibility.isInternal((AnnotatableElement)it) ? StringExtensions.toFirstLower((String)this.asIdentifier(it.getName())) : StringExtensions.toFirstUpper((String)this.asIdentifier(it.getName()));
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public boolean isCsharpSystemKeyword(String name) {
        Functions.Function1 _function = it -> it.equalsIgnoreCase(name);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((String)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)CSHARP_SYSTEM_KEYWORDS)), (Functions.Function1)_function)));
        return !_isNullOrEmpty;
    }

    public boolean isCsharpKeyword(String name) {
        Functions.Function1 _function = it -> it.equalsIgnoreCase(name);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((String)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)CSHARP_KEYWORDS)), (Functions.Function1)_function)));
        return !_isNullOrEmpty;
    }

    public boolean isStatechartKeyword(String name) {
        Functions.Function1 _function = it -> it.equalsIgnoreCase(name);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((String)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)STATECHART_KEYWORDS)), (Functions.Function1)_function)));
        return !_isNullOrEmpty;
    }

    private String asIdentifier(String string) {
        String _xifexpression = null;
        if (string != null) {
            _xifexpression = string.replaceAll("[[^a-z]&&[^A-Z]&&[^0-9]]", Character.valueOf('_').toString());
        }
        return _xifexpression;
    }

    @XbaseGenerated
    protected void applyCsharpName(NamedElement it) {
        if (it instanceof ComplexType) {
            this._applyCsharpName((ComplexType)it);
            return;
        }
        if (it instanceof Operation) {
            this._applyCsharpName((Operation)it);
            return;
        }
        if (it instanceof Property) {
            this._applyCsharpName((Property)it);
            return;
        }
        if (it != null) {
            this._applyCsharpName(it);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

