/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.simulation.ui.launch;

import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.Declaration;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.part.FileEditorInput;

public class TestMethodExistenceTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IFile unitFile = this.getFile(receiver);
        if (unitFile == null) {
            return false;
        }
        ResourceSetImpl set = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)unitFile.getLocation().toString());
        Resource resource = set.getResource(uri, true);
        if (resource == null || resource.getContents().isEmpty()) {
            return false;
        }
        TestPackage testPkg = (TestPackage)resource.getContents().get(0);
        for (Declaration member : testPkg.getMember()) {
            if (member instanceof SCTUnitClass && this.hasTestOrRunMethod((SCTUnitClass)member)) {
                return true;
            }
            if (!(member instanceof SCTUnitSuite) || !this.hasSCTUnitClasses((SCTUnitSuite)member)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSCTUnitClasses(SCTUnitSuite testSuite) {
        return !testSuite.getAllFeatures().isEmpty() && testSuite.getAllFeatures() != null;
    }

    protected boolean hasTestOrRunMethod(SCTUnitClass testClass) {
        for (Declaration decl : testClass.getAllFeatures()) {
            SCTUnitOperation operation;
            if (!(decl instanceof SCTUnitOperation) || !this.hasTestOrRunAnnotation(operation = (SCTUnitOperation)decl)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasTestOrRunAnnotation(SCTUnitOperation op) {
        for (Annotation a : op.getAnnotation()) {
            if (!a.getType().getName().equals("Test") && !a.getType().getName().equals("Run")) continue;
            return true;
        }
        return false;
    }

    protected IFile getFile(Object receiver) {
        if (receiver instanceof IFile) {
            return (IFile)receiver;
        }
        if (receiver instanceof FileEditorInput) {
            FileEditorInput editorInput = (FileEditorInput)receiver;
            return editorInput.getFile();
        }
        return null;
    }
}

