/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.sct.debugger;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.core.rx.Observer;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.simulation.core.sexec.container.StatechartInterpreterSesionDebugger;
import com.yakindu.yet.core.YETEvent;
import com.yakindu.yet.core.config.IYETConfigParameters;
import com.yakindu.yet.core.protocol.YETAbstractMessagePort;

public class YETDebugger
extends StatechartInterpreterSesionDebugger
implements IYETConfigParameters {
    @Inject
    protected YETAbstractMessagePort messagePort;
    @Inject
    @Named(value="IS_TIME_SLAVE")
    Boolean isTimeSlave = Boolean.FALSE;
    protected Observer<YETEvent<?>> forwardTraceEvent = e -> {
        this.session.doEvaluate().next(e);
        if (this.isTimeSlave.booleanValue()) {
            this.session.getClock().setTime(e.getTimestamp());
        }
    };

    public YETDebugger(Statechart statechart) {
        this(statechart, false);
    }

    public YETDebugger(Statechart statechart, boolean initFromContext) {
        this.statechart = statechart;
        this.initFromContext = initFromContext;
    }

    public void start() {
        super.start();
        if (this.isTimeSlave.booleanValue()) {
            this.session.getClock().setTime(Long.MIN_VALUE);
        }
        try {
            this.messagePort.incomingEvents().subscribe(this.forwardTraceEvent);
            this.messagePort.start();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void terminate() {
        this.messagePort.stop();
        this.messagePort.incomingEvents().unsubscribe(this.forwardTraceEvent);
        super.terminate();
    }
}

