/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.cpp;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator;
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries;
import com.yakindu.sctunit.generator.cpp.extensions.GTest;
import com.yakindu.sctunit.generator.cpp.extensions.Genmodel;
import com.yakindu.sctunit.generator.cpp.extensions.JUnitTest;
import com.yakindu.sctunit.generator.cpp.extensions.TimerService;
import com.yakindu.sctunit.generator.cpp.extensions.TimerServiceDependencies;
import com.yakindu.sctunit.generator.cpp.extensions.TimerServiceHeader;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import java.util.Iterator;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class CppSCTUnitGenerator
implements ISCTUnitGenerator {
    @Inject
    @Extension
    private JUnitTest jUnitTest;
    @Inject
    @Extension
    private GTest gTest;
    @Inject
    @Extension
    private Genmodel _genmodel;
    @Inject
    @Extension
    protected CSCTUnitGenmodelEntries _cSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private TimerService timerService;
    @Inject
    @Extension
    private TimerServiceHeader timerServiceHeader;
    @Inject
    @Extension
    private TimerServiceDependencies timerServiceDependencies;
    @Inject
    protected ICoreLibraryHelper helper;

    public void generate(GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _tripleNotEquals;
        this.prepareGenerator(entry);
        this.generateJUnitWrapper(entry, fsa);
        SCTUnitClass _testClass = this.getTestClass(this._cSCTUnitGenmodelEntries.getTestPackage(entry));
        boolean bl = _tripleNotEquals = _testClass != null;
        if (_tripleNotEquals) {
            SCTUnitClass sctunitClass = this.getTestClass(this._cSCTUnitGenmodelEntries.getTestPackage(entry));
            String gtestOutletFolder = this._cSCTUnitGenmodelEntries.getTargetFolderString(entry);
            this.gTest.generateGTest(sctunitClass, fsa, gtestOutletFolder);
            this.timerService.generateTimerService(sctunitClass, fsa, gtestOutletFolder);
            this.timerServiceHeader.generateTimerServiceHeader(sctunitClass, fsa, gtestOutletFolder);
            this.timerServiceDependencies.generateTimerServiceDependencies(sctunitClass, fsa, gtestOutletFolder);
            boolean _isSGen = this._cSCTUnitGenmodelEntries.isSGen(entry);
            if (_isSGen) {
                this._genmodel.generateGenmodel(sctunitClass, fsa);
            }
        }
    }

    protected void prepareGenerator(GeneratorEntry entry) {
    }

    protected void generateJUnitWrapper(GeneratorEntry entry, IFileSystemAccess fsa) {
        String targetProjectPath = this._cSCTUnitGenmodelEntries.getJavaPackageForProjectName(this.getTargetProject(entry));
        boolean _isJUnitWrapper = this._cSCTUnitGenmodelEntries.isJUnitWrapper(entry);
        if (_isJUnitWrapper) {
            this.jUnitTest.generateJUnitTest(this._cSCTUnitGenmodelEntries.getTestPackage(entry), fsa, targetProjectPath, this, entry);
        }
    }

    public String getTargetProject(GeneratorEntry entry) {
        return this.helper.getTargetProjectValue(entry).getStringValue();
    }

    protected SCTUnitClass getTestClass(TestPackage it) {
        return (SCTUnitClass)IteratorExtensions.head((Iterator)Iterators.filter((Iterator)it.eAllContents(), SCTUnitClass.class));
    }
}

