/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.cpp.extensions;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.generator.cpp.CppFileNaming;
import com.yakindu.sct.generator.cpp.CppNaming;
import com.yakindu.sct.generator.cpp.CppPointers;
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sctunit.generator.c.extensions.GenerationHelper;
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries;
import com.yakindu.sctunit.generator.cpp.extensions.CppMockingExtensions;
import com.yakindu.sctunit.generator.cpp.extensions.CppNavigationExtensions;
import com.yakindu.sctunit.generator.cpp.extensions.CppStatementExtensions;
import com.yakindu.sctunit.generator.cpp.extensions.CppSubchartInitializer;
import com.yakindu.sctunit.generator.cpp.extensions.SCTUnitCppNaming;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GTest {
    public static final String SCTUNIT_INFERRER = "com.yakindu.sctunit.generator.cpp.CPPSCTUnitGenerator.typeInferrer";
    @Inject
    @Extension
    protected SCTUnitCppNaming _sCTUnitCppNaming;
    @Inject
    @Extension
    protected CppFileNaming _cppFileNaming;
    @Inject
    @Extension
    protected CppNaming _cppNaming;
    @Inject
    @Extension
    protected CppPointers _cppPointers;
    @Inject
    @Extension
    protected GenerationHelper _generationHelper;
    @Inject
    @Extension
    protected CppMockingExtensions _cppMockingExtensions;
    @Inject
    @Extension
    private CppNavigationExtensions _cppNavigationExtensions;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private CppStatementExtensions _cppStatementExtensions;
    @Inject
    @Extension
    private CSCTUnitGenmodelEntries _cSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    @Inject
    @Extension
    private CppSubchartInitializer _cppSubchartInitializer;
    @Inject
    protected GenmodelEntriesExtension genModelExtension;
    @Inject
    @Named(value="com.yakindu.sctunit.generator.cpp.CPPSCTUnitGenerator.typeInferrer")
    @Extension
    private ITypeSystemInferrer _iTypeSystemInferrer;
    @Inject
    private GeneratorEntry entry;

    public void generateGTest(SCTUnitClass it, IFileSystemAccess fsa, String outletFolder) {
        StringConcatenation _builder = new StringConcatenation();
        String _cc = this._sCTUnitCppNaming.cc(this._sCTUnitCppNaming.testClassName((SCTUnitElement)it));
        _builder.append(_cc);
        String gTestFileName = _builder.toString();
        CharSequence content = this.generateGTest(it);
        fsa.generateFile(gTestFileName, content);
    }

    private CharSequence generateGTest(SCTUnitClass it) {
        boolean _tripleNotEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._cSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("#include <string>");
        _builder.newLine();
        _builder.append("#include <list>");
        _builder.newLine();
        boolean _isMockingRequired = this._cppMockingExtensions.isMockingRequired(it);
        if (_isMockingRequired) {
            _builder.append("#include <algorithm>");
            _builder.newLine();
        }
        _builder.append("#include \"gtest/gtest.h\"");
        _builder.newLine();
        _builder.append("#include \"");
        String _h = this._cppFileNaming.h(this._cppFileNaming.module(it.getStatechart()));
        _builder.append(_h);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _h_1 = this._cppFileNaming.h(this._sCTUnitCppNaming.timerServiceFileName(it));
        _builder.append(_h_1);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _h_2 = this._cppFileNaming.h(this._cppFileNaming.typesModule());
        _builder.append(_h_2);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#ifndef SC_UNUSED");
        _builder.newLine();
        _builder.append("#define SC_UNUSED(P) (void)P");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        if (this._sCTUnitCppNaming.namespace((Declaration)it) != null && !Objects.equals(this._sCTUnitCppNaming.namespace((Declaration)it), "")) {
            String[] _split;
            String[] stringArray = _split = this._sCTUnitCppNaming.namespace((Declaration)it).toString().split("\\.");
            int n = _split.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                _builder.append("namespace ");
                _builder.append(name);
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                ++n2;
            }
        }
        _builder.newLine();
        CharSequence _generateSetUpTearDownClass = this.generateSetUpTearDownClass(it);
        _builder.append((Object)_generateSetUpTearDownClass);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isEmpty = this._cppMockingExtensions.mockedExternalOperations(it).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _testClassName = this._sCTUnitCppNaming.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName);
            _builder.append("* ");
            String _testClassName_1 = this._sCTUnitCppNaming.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName_1);
            _builder.append("::current = 0;");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Iterable _allAnnotationlessOps = this._cppNavigationExtensions.getAllAnnotationlessOps(it);
        for (SCTUnitOperation operation : _allAnnotationlessOps) {
            CharSequence _generate = this.generate(operation, it);
            _builder.append((Object)_generate);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Iterable _allTestOps = this._cppNavigationExtensions.getAllTestOps(it);
        for (SCTUnitOperation operation_1 : _allTestOps) {
            CharSequence _generate_1 = this.generate(operation_1, it);
            _builder.append((Object)_generate_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _namespace = this._sCTUnitCppNaming.namespace((Declaration)it);
        boolean bl2 = _tripleNotEquals = _namespace != null;
        if (_tripleNotEquals) {
            String[] _split_1;
            String[] stringArray = _split_1 = this._sCTUnitCppNaming.namespace((Declaration)it).toString().split("\\.");
            int n = _split_1.length;
            int n3 = 0;
            while (n3 < n) {
                String name_1 = stringArray[n3];
                _builder.append("}");
                _builder.newLine();
                ++n3;
            }
            _builder.newLine();
            CharSequence _generateRequiredHeaderOperations = this._cppMockingExtensions.generateRequiredHeaderOperations(it);
            _builder.append((Object)_generateRequiredHeaderOperations);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generate(SCTUnitOperation it, SCTUnitClass clazz) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isTest = this._cppNavigationExtensions.isTest((EObject)it);
        if (_isTest) {
            boolean _not;
            boolean _isCalledTestOperation = this.isCalledTestOperation(it);
            boolean bl = _not = !_isCalledTestOperation;
            if (_not) {
                _builder.append("TEST_F(");
                String _testClassName = this._sCTUnitCppNaming.testClassName((SCTUnitElement)this._cppNavigationExtensions.getSCTUnitClass(it));
                _builder.append(_testClassName);
                _builder.append(", ");
                boolean _isIgnore = this._cppNavigationExtensions.isIgnore(it);
                if (_isIgnore) {
                    _builder.append("DISABLED_");
                }
                String _name = it.getName();
                _builder.append(_name);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _generateMethodBody = this.generateMethodBody(it);
                _builder.append((Object)_generateMethodBody, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("void ");
                String _testClassName_1 = this._sCTUnitCppNaming.testClassName((SCTUnitElement)this._cppNavigationExtensions.getSCTUnitClass(it));
                _builder.append(_testClassName_1);
                _builder.append("::");
                String _name_1 = it.getName();
                _builder.append(_name_1);
                _builder.append("() {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _generateMethodBody_1 = this.generateMethodBody(it);
                _builder.append((Object)_generateMethodBody_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
                _builder.append("TEST_F(");
                String _testClassName_2 = this._sCTUnitCppNaming.testClassName((SCTUnitElement)this._cppNavigationExtensions.getSCTUnitClass(it));
                _builder.append(_testClassName_2);
                _builder.append(", ");
                boolean _isIgnore_1 = this._cppNavigationExtensions.isIgnore(it);
                if (_isIgnore_1) {
                    _builder.append("DISABLED_");
                }
                String _name_2 = it.getName();
                _builder.append(_name_2);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _name_3 = it.getName();
                _builder.append(_name_3, "\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
        } else {
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(this._iTypeSystemInferrer.infer((EObject)it).getType());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _testClassName_3 = this._sCTUnitCppNaming.testClassName((SCTUnitElement)this._cppNavigationExtensions.getSCTUnitClass(it));
            _builder.append(_testClassName_3);
            _builder.append("::");
            String _name_4 = it.getName();
            _builder.append(_name_4);
            _builder.append("(");
            CharSequence _generateParams = this.generateParams(it);
            _builder.append((Object)_generateParams);
            _builder.append("){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateMethodBody_2 = this.generateMethodBody(it);
            _builder.append((Object)_generateMethodBody_2, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setupOperationMockInstances(SCTUnitClass it) {
        StringConcatenation _xblockexpression = null;
        List mockOperations = IterableExtensions.toList((Iterable)this._cppMockingExtensions.getAllOperations(this._cppMockingExtensions.getAllMockStatementsInClass(it)));
        StringConcatenation _builder = new StringConcatenation();
        for (Operation op : mockOperations) {
            CharSequence _initializeOperationMock = this._cppMockingExtensions.initializeOperationMock(op, this._cppMockingExtensions.isOperationForStatement(it, op, MockReturnStatement.class));
            _builder.append((Object)_initializeOperationMock);
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateSCUnitMethodDefinitions(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it_1 -> this.isCalledTestOperation((SCTUnitOperation)it_1) || !this._cppNavigationExtensions.isTest((EObject)it_1);
        Iterable _filter = IterableExtensions.filter((Iterable)this._cppNavigationExtensions.getSCTUnitOperations(it), (Functions.Function1)_function);
        for (SCTUnitOperation op : _filter) {
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(this._iTypeSystemInferrer.infer((EObject)op).getType());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _name = op.getName();
            _builder.append(_name);
            _builder.append("(");
            CharSequence _generateParams = this.generateParams(op);
            _builder.append((Object)_generateParams);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateSetUpTearDownClass(SCTUnitClass it) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class ");
        String _testClassName = this._sCTUnitCppNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName);
        _builder.append(" : public ::testing::Test{");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        boolean _isEmpty = this._cppMockingExtensions.mockedExternalOperations(it).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("static ");
            String _testClassName_1 = this._sCTUnitCppNaming.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName_1, "\t");
            _builder.append("* current;");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateSCUnitMethodDefinitions = this.generateSCUnitMethodDefinitions(it);
        _builder.append((Object)_generateSCUnitMethodDefinitions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _sharedPtr = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr, "\t");
        String _typeName = this._sCTUnitCppNaming.typeName((EObject)it.getStatechart());
        _builder.append(_typeName, "\t");
        CharSequence _pointerType = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType, "\t");
        _builder.append(" ");
        CharSequence _identifier = this._sCTUnitCppNaming.getIdentifier();
        _builder.append((Object)_identifier, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _subchartDeclarationSequence = this._cppSubchartInitializer.getSubchartDeclarationSequence(it.getStatechart());
        _builder.append(_subchartDeclarationSequence, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        EList _variableDefinitions = it.getVariableDefinitions();
        for (VariableDefinitionStatement vardef : _variableDefinitions) {
            _builder.append("\t");
            CharSequence _generate = this._cppStatementExtensions.generate((TestStatement)vardef);
            _builder.append((Object)_generate, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateOperationMockClasses = this._cppMockingExtensions.generateOperationMockClasses(it);
        _builder.append((Object)_generateOperationMockClasses, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateMockClasses = this._cppMockingExtensions.generateMockClasses(it);
        _builder.append((Object)_generateMockClasses, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateTimerServiceVars = this.generateTimerServiceVars(it);
        _builder.append((Object)_generateTimerServiceVars, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _defineInterfaceMockObjects = this._cppMockingExtensions.defineInterfaceMockObjects(it);
        _builder.append((Object)_defineInterfaceMockObjects, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void SetUp() {");
        _builder.newLine();
        _builder.append("\t\t");
        boolean _isEmpty_1 = this._cppMockingExtensions.mockedExternalOperations(it).isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append("current = this;");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _identifier_1 = this._sCTUnitCppNaming.getIdentifier();
        _builder.append((Object)_identifier_1, "\t\t");
        _builder.append(" = ");
        CharSequence _makeSharedPtr = this._cppPointers.makeSharedPtr();
        _builder.append((Object)_makeSharedPtr, "\t\t");
        String _typeName_1 = this._sCTUnitCppNaming.typeName((EObject)it.getStatechart());
        _builder.append(_typeName_1, "\t\t");
        CharSequence _makeTypeCloser = this._cppPointers.makeTypeCloser();
        _builder.append((Object)_makeTypeCloser, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        if (this._cppSubchartInitializer.isTimed(it.getStatechart()) || this._generationHelper.hasTimedSubmachines(it.getStatechart())) {
            _builder.append("\t\t");
            _builder.append("size_t ");
            CharSequence _maximalParallelTimeEvents = this._sCTUnitCppNaming.maximalParallelTimeEvents();
            _builder.append((Object)_maximalParallelTimeEvents, "\t\t");
            _builder.append(" = ");
            boolean _isTimed = this._cppSubchartInitializer.isTimed(it.getStatechart());
            if (_isTimed) {
                _builder.append("(size_t)");
                CharSequence _identifier_2 = this._sCTUnitCppNaming.getIdentifier();
                _builder.append((Object)_identifier_2, "\t\t");
                _builder.append("->");
                _builder.append("getNumberOfParallelTimeEvents", "\t\t");
                _builder.append("()");
            } else {
                _builder.append("0");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        String _subchartInitSequence = this._cppSubchartInitializer.getSubchartInitSequence(it.getStatechart());
        _builder.append(_subchartInitSequence, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _generateTimerServiceInit = this.generateTimerServiceInit(it);
        _builder.append((Object)_generateTimerServiceInit, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _setupOperationMockInstances = this.setupOperationMockInstances(it);
        _builder.append((Object)_setupOperationMockInstances, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _setupInterfaceMockInstances = this._cppMockingExtensions.setupInterfaceMockInstances(it);
        _builder.append((Object)_setupInterfaceMockInstances, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _setupInterfaceCallbacks = this._cppMockingExtensions.setupInterfaceCallbacks(it);
        _builder.append((Object)_setupInterfaceCallbacks, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void TearDown() {");
        _builder.newLine();
        List _reverse = ListExtensions.reverse((List)IterableExtensions.toList((Iterable)this._cppMockingExtensions.getAllOperations(this._cppMockingExtensions.getAllMockStatementsInClass(it))));
        for (Operation op : _reverse) {
            _builder.append("\t\t");
            CharSequence _freeOperationMock = this._cppMockingExtensions.freeOperationMock(op);
            _builder.append((Object)_freeOperationMock, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        CharSequence _deletePointer = this._cppPointers.deletePointer();
        _builder.append((Object)_deletePointer, "\t\t");
        _builder.append(" ");
        CharSequence _identifier_3 = this._sCTUnitCppNaming.getIdentifier();
        _builder.append((Object)_identifier_3, "\t\t");
        CharSequence _freePointer = this._cppPointers.freePointer();
        _builder.append((Object)_freePointer, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _subchartTeardownSequence = this._cppSubchartInitializer.getSubchartTeardownSequence(it.getStatechart());
        _builder.append(_subchartTeardownSequence, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _tearDownInterfaceMockInstances = this._cppMockingExtensions.tearDownInterfaceMockInstances(it);
        _builder.append((Object)_tearDownInterfaceMockInstances, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _deletePointer_1 = this._cppPointers.deletePointer();
        _builder.append((Object)_deletePointer_1, "\t\t");
        _builder.append(" runner");
        CharSequence _freePointer_1 = this._cppPointers.freePointer();
        _builder.append((Object)_freePointer_1, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateMethodBody(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _code = it.getBody().getCode();
        for (TestStatement statement : _code) {
            CharSequence _generate = this._cppStatementExtensions.generate(statement);
            _builder.append((Object)_generate);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateTimerServiceVars(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//! The timers are managed by a timer service. */");
        _builder.newLine();
        CharSequence _sharedPtr = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr);
        String _timerServiceClass = this._sCTUnitCppNaming.timerServiceClass(it);
        _builder.append(_timerServiceClass);
        _builder.append(" ");
        CharSequence _pointerType = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType);
        _builder.append(" runner;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public boolean isCalledTestOperation(SCTUnitOperation it) {
        SCTUnitClass clazz = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)it, SCTUnitClass.class);
        List elemRefs = EcoreUtil2.getAllContentsOfType((EObject)clazz, ElementReferenceExpression.class);
        Functions.Function1 _function = ref -> {
            EObject _reference = ref.getReference();
            return _reference instanceof SCTUnitOperation;
        };
        Functions.Function1 _function_1 = ref -> ref.getReference();
        List allOpRefs = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)elemRefs, (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _contains = allOpRefs.contains(it);
        return _contains;
    }

    private CharSequence generateParams(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter param : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(param.getTypeSpecifier());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _name = param.getName();
            _builder.append(_name);
        }
        return _builder;
    }

    protected CharSequence generateTimerServiceInit(SCTUnitClass it) {
        StringConcatenation _xblockexpression = null;
        long cyclePeriod = this._statechartAnnotations.getCyclePeriod((EObject)it.getStatechart());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("runner = ");
        CharSequence _makeSharedPtr = this._cppPointers.makeSharedPtr();
        _builder.append((Object)_makeSharedPtr);
        String _timerServiceClass = this._sCTUnitCppNaming.timerServiceClass(it);
        _builder.append(_timerServiceClass);
        CharSequence _makeTypeCloser = this._cppPointers.makeTypeCloser();
        _builder.append((Object)_makeTypeCloser);
        _builder.append("(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        boolean _isCycleBased = this._statechartAnnotations.isCycleBased(it.getStatechart());
        if (_isCycleBased) {
            CharSequence _identifier = this._sCTUnitCppNaming.getIdentifier();
            _builder.append((Object)_identifier, "\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append((Object)cyclePeriod, "\t");
            if (this._cppSubchartInitializer.isTimed(it.getStatechart()) || this._generationHelper.hasTimedSubmachines(it.getStatechart())) {
                _builder.append(", ");
            }
        }
        _builder.newLineIfNotEmpty();
        if (this._cppSubchartInitializer.isTimed(it.getStatechart()) || this._generationHelper.hasTimedSubmachines(it.getStatechart())) {
            _builder.append("\t");
            CharSequence _maximalParallelTimeEvents = this._sCTUnitCppNaming.maximalParallelTimeEvents();
            _builder.append((Object)_maximalParallelTimeEvents, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(");");
        _builder.newLine();
        boolean _isTimed = this._generationHelper.isTimed(it);
        if (_isTimed) {
            CharSequence _identifier_1 = this._sCTUnitCppNaming.getIdentifier();
            _builder.append((Object)_identifier_1);
            _builder.append("->");
            _builder.append("setTimerService");
            _builder.append("(runner);");
            _builder.newLineIfNotEmpty();
        }
        String _setRunnerSequence = this._cppSubchartInitializer.getSetRunnerSequence(it.getStatechart());
        _builder.append(_setRunnerSequence);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

