/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.java;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.TypeCastExpression;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.generator.java.files.ITimed;
import com.yakindu.sct.generator.java.files.ITimerService;
import com.yakindu.sct.generator.java.files.VirtualTimer;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.stext.OperationDefinition;
import com.yakindu.sct.types.resource.Statechart2TypeTransformation;
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator;
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions;
import com.yakindu.sctunit.generator.base.extensions.StaticExtensions;
import com.yakindu.sctunit.generator.java.JavaSubchartInitializer;
import com.yakindu.sctunit.generator.java.extensions.CallbackExtensions;
import com.yakindu.sctunit.generator.java.extensions.IMockingExtensions;
import com.yakindu.sctunit.generator.java.extensions.JavaExpressionExtensions;
import com.yakindu.sctunit.generator.java.extensions.JavaStatementExtensions;
import com.yakindu.sctunit.generator.java.extensions.SCTUnitJavaNaming;
import com.yakindu.sctunit.generator.java.features.JavaSCTUnitGenmodelEntries;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JavaSCTUnitGenerator
implements ISCTUnitGenerator {
    public static final String SCTUNIT_INFERRER = "com.yakindu.sctunit.generator.java.JavaSCTUnitGenerator.typeInferrer";
    @Inject
    @Extension
    private JavaExpressionExtensions _javaExpressionExtensions;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    @Inject
    @Extension
    private SCTUnitJavaNaming _sCTUnitJavaNaming;
    @Inject
    @Extension
    private StringHelper _stringHelper;
    @Inject
    @Extension
    private JavaStatementExtensions _javaStatementExtensions;
    @Inject
    @Extension
    private StaticExtensions _staticExtensions;
    @Inject
    @Extension
    private IMockingExtensions _iMockingExtensions;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private CallbackExtensions _callbackExtensions;
    @Inject
    @Extension
    private BaseNavigationExtensions _baseNavigationExtensions;
    @Inject
    @Extension
    private JavaSCTUnitGenmodelEntries _javaSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private Naming naming;
    @Inject
    @Extension
    private Statechart2TypeTransformation _statechart2TypeTransformation;
    @Inject
    @Extension
    private VirtualTimer timer;
    @Inject
    @Extension
    private ITimerService iTimerServiceTemplate;
    @Inject
    @Extension
    private ITimed iTimedTemplate;
    @Inject
    @Named(value="com.yakindu.sctunit.generator.java.JavaSCTUnitGenerator.typeInferrer")
    @Extension
    private ITypeSystemInferrer _iTypeSystemInferrer;
    @Inject
    @Extension
    private JavaSubchartInitializer _javaSubchartInitializer;
    private GeneratorEntry entry;

    public void generate(GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _needsTimer;
        this.entry = entry;
        TestPackage testPackage = this._baseNavigationExtensions.getTestPackage(entry);
        String fileName = this.getFileName(testPackage);
        SCTUnitElement element = this._baseNavigationExtensions.getSCTUnitElement(testPackage);
        CharSequence content = this.toCode(element);
        if (element instanceof SCTUnitClass && (_needsTimer = this._javaSubchartInitializer.needsTimer(((SCTUnitClass)element).getStatechart()))) {
            this.timer.generateWithStatechart(((SCTUnitClass)element).getStatechart(), entry, fsa);
            String _path = this._stringHelper.toPath(this._javaSCTUnitGenmodelEntries.getStatechartLibraryPackage(entry));
            String _plus = _path + "/";
            String _java = this.naming.java(this.naming.iTimerService());
            String timerServiceFileName = _plus + _java;
            fsa.generateFile(timerServiceFileName, "LIBRARY_TARGET_FOLDER", this.iTimerServiceTemplate.content(this._javaSCTUnitGenmodelEntries.getLicenseText(entry), this._javaSCTUnitGenmodelEntries.getStatechartLibraryPackage(entry)));
            String _path_1 = this._stringHelper.toPath(this._javaSCTUnitGenmodelEntries.getStatechartLibraryPackage(entry));
            String _plus_1 = _path_1 + "/";
            String _java_1 = this.naming.java(this.naming.iTimed());
            String iTimedFileName = _plus_1 + _java_1;
            fsa.generateFile(iTimedFileName, "LIBRARY_TARGET_FOLDER", this.iTimedTemplate.content(this._javaSCTUnitGenmodelEntries.getLicenseText(entry), this._javaSCTUnitGenmodelEntries.getStatechartLibraryPackage(entry)));
        }
        fsa.generateFile(fileName, content);
    }

    protected CharSequence _toCode(SCTUnitSuite it) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._javaSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("package ");
        String _classPackage = this.classPackage((SCTUnitElement)it);
        _builder.append(_classPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("import org.junit.runner.RunWith;");
        _builder.newLine();
        _builder.append("import org.junit.runners.Suite;");
        _builder.newLine();
        _builder.append("import org.junit.runners.Suite.SuiteClasses;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@RunWith(Suite.class)");
        _builder.newLine();
        _builder.append("@SuiteClasses({");
        _builder.newLine();
        Iterable _sCTUnitClasses = this._baseNavigationExtensions.getSCTUnitClasses(it);
        boolean _hasElements = false;
        for (SCTUnitClass group : _sCTUnitClasses) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            String _testClassName = this._sCTUnitJavaNaming.testClassName((SCTUnitElement)group);
            _builder.append(_testClassName, "\t");
            _builder.append(".class");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("})");
        _builder.newLine();
        _builder.append("public class ");
        String _testClassName_1 = this._sCTUnitJavaNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName_1);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _toCode(SCTUnitClass it) {
        try {
            String _statechartBasePackage_1;
            String _classPackage_2;
            boolean _notEquals_1;
            boolean _isCycleBased;
            boolean _needsTimer;
            boolean _notEquals;
            boolean _not;
            StringConcatenation _builder = new StringConcatenation();
            String _licenseText = this._javaSCTUnitGenmodelEntries.getLicenseText(this.entry);
            _builder.append(_licenseText);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.classPackage((SCTUnitElement)it));
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                _builder.append("package ");
                String _classPackage = this.classPackage((SCTUnitElement)it);
                _builder.append(_classPackage);
                _builder.append(";");
            }
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            String _mockingImports = this._iMockingExtensions.mockingImports(it, this.entry);
            _builder.append(_mockingImports);
            _builder.newLineIfNotEmpty();
            _builder.append("import org.junit.*;");
            _builder.newLine();
            _builder.append("import static org.junit.Assert.*;");
            _builder.newLine();
            String _classPackage_1 = this.classPackage((SCTUnitElement)it);
            String _statechartBasePackage = this._javaSCTUnitGenmodelEntries.getStatechartBasePackage(this.entry);
            boolean bl2 = _notEquals = !Objects.equals(_classPackage_1, _statechartBasePackage);
            if (_notEquals) {
                _builder.append("import ");
                String _dot = this._stringHelper.dot(this._javaSCTUnitGenmodelEntries.getStatechartBasePackage(this.entry), this._sCTUnitJavaNaming.statemachineClassName(it));
                _builder.append(_dot);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("import ");
                String string = this._stringHelper.dot(this._javaSCTUnitGenmodelEntries.getStatechartBasePackage(this.entry), this._sCTUnitJavaNaming.statemachineClassName(it));
                _builder.append(string);
                _builder.append(".State;");
                _builder.newLineIfNotEmpty();
            }
            if (_needsTimer = this._javaSubchartInitializer.needsTimer(it.getStatechart())) {
                _builder.append("import ");
                String _statechartLibraryPackage = this._javaSCTUnitGenmodelEntries.getStatechartLibraryPackage(this.entry);
                _builder.append(_statechartLibraryPackage);
                _builder.append(".VirtualTimer;");
                _builder.newLineIfNotEmpty();
            }
            if (_isCycleBased = this._statechartAnnotations.isCycleBased(it.getStatechart())) {
                _builder.append("import ");
                String _statechartLibraryPackage_1 = this._javaSCTUnitGenmodelEntries.getStatechartLibraryPackage(this.entry);
                _builder.append(_statechartLibraryPackage_1);
                _builder.append(".VirtualTimer.VirtualTimeTask;");
                _builder.newLineIfNotEmpty();
                _builder.append("import ");
                String _statechartLibraryPackage_2 = this._javaSCTUnitGenmodelEntries.getStatechartLibraryPackage(this.entry);
                _builder.append(_statechartLibraryPackage_2);
                _builder.append(".VirtualTimer.CycleTimeEventTask;");
                _builder.newLineIfNotEmpty();
            }
            boolean bl3 = _notEquals_1 = !Objects.equals(_classPackage_2 = this.classPackage((SCTUnitElement)it), _statechartBasePackage_1 = this._javaSCTUnitGenmodelEntries.getStatechartBasePackage(this.entry));
            if (_notEquals_1) {
                Set _entrySet = this._javaSubchartInitializer.getSubchartImports(it.getStatechart()).entrySet();
                for (Map.Entry entry : _entrySet) {
                    _builder.append("import ");
                    String _dot_2 = this._stringHelper.dot(this._javaSCTUnitGenmodelEntries.getStatechartBasePackage(this.entry, (Statechart)entry.getKey()), ((CharSequence)entry.getValue()).toString());
                    _builder.append(_dot_2);
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
            }
            List<String> _importsForReferencedTypes = this.importsForReferencedTypes(it);
            for (String typeImport : _importsForReferencedTypes) {
                _builder.append("import ");
                _builder.append(typeImport);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            CharSequence _author = this._staticExtensions.author(it);
            _builder.append((Object)_author);
            _builder.newLineIfNotEmpty();
            _builder.append("@SuppressWarnings(\"all\")");
            _builder.newLine();
            _builder.append("public class ");
            String _testClassName = this._sCTUnitJavaNaming.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            EList _scopes = it.getStatechart().getScopes();
            for (Scope scope : _scopes) {
                boolean _not_1;
                _builder.append("\t");
                boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)Iterables.filter((Iterable)scope.getMembers(), OperationDefinition.class));
                boolean bl4 = _not_1 = !_isNullOrEmpty_1;
                if (_not_1) {
                    CharSequence _setCallBack = this._callbackExtensions.setCallBack(scope);
                    _builder.append((Object)_setCallBack, "\t");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private ");
            String _statemachineClassName = this._sCTUnitJavaNaming.statemachineClassName(it);
            _builder.append(_statemachineClassName, "\t");
            _builder.append(" statemachine;\t");
            _builder.newLineIfNotEmpty();
            boolean _needsTimer_1 = this._javaSubchartInitializer.needsTimer(it.getStatechart());
            if (_needsTimer_1) {
                _builder.append("\t");
                _builder.append("private VirtualTimer timer;");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.newLine();
            EList _variableDefinitions = it.getVariableDefinitions();
            for (VariableDefinitionStatement variableDefinitionStatement : _variableDefinitions) {
                _builder.append("\t");
                _builder.append("protected ");
                String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(variableDefinitionStatement.getDefinition().getType());
                _builder.append(_targetLanguageName, "\t");
                _builder.append(" ");
                String _name = variableDefinitionStatement.getDefinition().getName();
                _builder.append(_name, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _setup = this.setup(it);
            _builder.append((Object)_setup, "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@After");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void ");
            String string = StringExtensions.toFirstLower((String)it.getName());
            _builder.append(string, "\t");
            _builder.append("_tearDown() {");
            _builder.newLineIfNotEmpty();
            EList _scopes_1 = it.getStatechart().getScopes();
            for (Scope scope_1 : _scopes_1) {
                boolean _not_2;
                _builder.append("\t\t");
                boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)Iterables.filter((Iterable)scope_1.getMembers(), OperationDefinition.class));
                boolean bl5 = _not_2 = !_isNullOrEmpty_2;
                if (_not_2) {
                    CharSequence _unsetOperationCallback = this._callbackExtensions.unsetOperationCallback(scope_1);
                    _builder.append((Object)_unsetOperationCallback, "\t\t");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("statemachine = null;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            boolean _needsTimer_2 = this._javaSubchartInitializer.needsTimer(it.getStatechart());
            if (_needsTimer_2) {
                _builder.append("\t\t");
                _builder.append("timer = null;");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            List _sCTUnitOperations = this._baseNavigationExtensions.getSCTUnitOperations(it);
            boolean _hasElements = false;
            for (SCTUnitOperation operation : _sCTUnitOperations) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "\t");
                }
                _builder.append("\t");
                CharSequence _code = this.toCode(operation);
                _builder.append((Object)_code, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
            return _builder;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence _toCode(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isIgnore = this._baseNavigationExtensions.isIgnore(it);
        if (_isIgnore) {
            _builder.append("@Ignore");
        }
        _builder.newLineIfNotEmpty();
        boolean _isTest = this._baseNavigationExtensions.isTest((EObject)it);
        if (_isTest) {
            _builder.append("@Test");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(this._iTypeSystemInferrer.infer((EObject)it).getType());
        _builder.append(_targetLanguageName);
        _builder.append(" ");
        String _methodName = this._sCTUnitJavaNaming.methodName(it);
        _builder.append(_methodName);
        _builder.append("(");
        CharSequence _generateParameter = this.generateParameter(it);
        _builder.append((Object)_generateParameter);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        EList _code = it.getBody().getCode();
        for (TestStatement statement : _code) {
            _builder.append("\t");
            CharSequence _generate = this._javaStatementExtensions.generate(statement);
            _builder.append((Object)_generate, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _toCode(List<VariableDefinitionStatement> varDefs) {
        StringConcatenation _builder = new StringConcatenation();
        for (VariableDefinitionStatement varDef : varDefs) {
            CharSequence _code = this.toCode(varDef);
            _builder.append((Object)_code);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _toCode(VariableDefinitionStatement it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generate = this._javaStatementExtensions.generate((TestStatement)it);
        _builder.append((Object)_generate);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence setup(SCTUnitClass it) throws Exception {
        boolean _isTimed;
        boolean _isCycleBased;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@Before");
        _builder.newLine();
        _builder.append("public void ");
        String _firstLower = StringExtensions.toFirstLower((String)it.getName());
        _builder.append(_firstLower);
        _builder.append("_setUp() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("statemachine = new ");
        String _statemachineClassName = this._sCTUnitJavaNaming.statemachineClassName(it);
        _builder.append(_statemachineClassName, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        boolean _needsTimer = this._javaSubchartInitializer.needsTimer(it.getStatechart());
        if (_needsTimer) {
            _builder.append("\t");
            _builder.append("timer = new VirtualTimer(");
            long _cyclePeriod = this._javaStatementExtensions.getCyclePeriod(it);
            _builder.append((Object)_cyclePeriod, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        if (_isCycleBased = this._statechartAnnotations.isCycleBased(it.getStatechart())) {
            _builder.append("\t");
            _builder.append("timer.schedulePeriodicalTask(new CycleTimeEventTask(statemachine), ");
            long _cyclePeriod_1 = this._javaStatementExtensions.getCyclePeriod(it);
            _builder.append((Object)_cyclePeriod_1, "\t");
            _builder.append(", ");
            long _cyclePeriod_2 = this._javaStatementExtensions.getCyclePeriod(it);
            _builder.append((Object)_cyclePeriod_2, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        if (_isTimed = this._javaSubchartInitializer.isTimed(it.getStatechart())) {
            _builder.append("\t");
            _builder.append("statemachine.setTimerService(timer);");
            _builder.newLine();
        }
        EList _scopes = it.getStatechart().getScopes();
        for (Scope scope : _scopes) {
            boolean _not;
            _builder.append("\t");
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)Iterables.filter((Iterable)scope.getMembers(), OperationDefinition.class));
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                String _mockOperationCallbacks = this._iMockingExtensions.mockOperationCallbacks(scope);
                _builder.append(_mockOperationCallbacks, "\t");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _subchartInitSequence = this._javaSubchartInitializer.getSubchartInitSequence(it.getStatechart());
        _builder.append(_subchartInitSequence, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        Functions.Function1 _function = it_1 -> {
            Expression _initialValue = it_1.getDefinition().getInitialValue();
            return _initialValue != null;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)it.getVariableDefinitions(), (Functions.Function1)_function);
        for (VariableDefinitionStatement variable : _filter) {
            _builder.append("\t");
            String _name = variable.getDefinition().getName();
            _builder.append(_name, "\t");
            _builder.append(" = ");
            CharSequence _code = this._javaExpressionExtensions.code((EObject)variable.getDefinition().getInitialValue());
            _builder.append((Object)_code, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected String getFileName(TestPackage it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _path = this._stringHelper.toPath(this._javaSCTUnitGenmodelEntries.getBasePackage(this.entry));
        _builder.append(_path);
        _builder.append("/");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._sCTUnitJavaNaming.namespace((Declaration)it).toString());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _namespaceFolder = this._sCTUnitJavaNaming.namespaceFolder(it);
            _builder.append(_namespaceFolder);
            _builder.append("/");
        }
        String _testClassName = this._sCTUnitJavaNaming.testClassName(this._baseNavigationExtensions.getSCTUnitElement(it));
        _builder.append(_testClassName);
        _builder.append(".java");
        return _builder.toString();
    }

    protected String classPackage(SCTUnitElement it) {
        return this._stringHelper.dot(this._javaSCTUnitGenmodelEntries.getBasePackage(this.entry), this._sCTUnitJavaNaming.namespace((Declaration)it).toString());
    }

    protected CharSequence generateParameter(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter param : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(param.getType());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _name = param.getName();
            _builder.append(_name);
        }
        return _builder;
    }

    public List<String> importsForReferencedTypes(SCTUnitClass it) {
        List _xblockexpression = null;
        Functions.Function1 _function = it_1 -> it_1.toString();
        Set statechartImports = IterableExtensions.toSet((Iterable)IterableExtensions.map(this._javaSubchartInitializer.getSubchartImports(it.getStatechart()).values(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it_1 -> this.typesToImport((EObject)it_1).iterator();
        Functions.Function1 _function_2 = it_1 -> !(it_1 instanceof PrimitiveType) && !this._statechart2TypeTransformation.isStatechartType((EObject)it_1) && !this._statechart2TypeTransformation.isStatechartStateEnum((EObject)it_1) && !this._statechart2TypeTransformation.isNamedIface((EObject)it_1);
        Functions.Function1 _function_3 = it_1 -> this.fqn((EObject)it_1);
        Functions.Function1 _function_4 = it_1 -> {
            boolean _contains = statechartImports.contains(it_1);
            return !_contains;
        };
        _xblockexpression = IterableExtensions.sort((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IteratorExtensions.toSet((Iterator)Iterators.concat((Iterator)IteratorExtensions.map((Iterator)it.eAllContents(), (Functions.Function1)_function_1))), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        return _xblockexpression;
    }

    protected String _fqn(NamedElement it) {
        String _xblockexpression = null;
        String parentName = this.fqn(it.eContainer());
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)parentName);
        if (_isNullOrEmpty) {
            _xifexpression = it.getName();
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(parentName);
            _builder.append(".");
            String _name = it.getName();
            _builder.append(_name);
            _xifexpression = _builder.toString();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String _fqn(EObject it) {
        return "";
    }

    protected String _fqn(Void it) {
        return "";
    }

    protected List<Type> _typesToImport(EObject it) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected List<Type> _typesToImport(TypeSpecifier it) {
        Functions.Function1 _function = it_1 -> this.typesToImport((EObject)it_1);
        List _list = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)it.getTypeArguments(), (Functions.Function1)_function)));
        Procedures.Procedure1 _function_1 = types -> {
            Type _type = it.getType();
            types.add(_type);
        };
        return (List)ObjectExtensions.operator_doubleArrow((Object)_list, (Procedures.Procedure1)_function_1);
    }

    protected List<Type> _typesToImport(ElementReferenceExpression it) {
        List<Object> _xifexpression = null;
        EObject _reference = it.getReference();
        if (_reference instanceof Type) {
            EObject _reference_1 = it.getReference();
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Type[]{(Type)_reference_1}));
        } else {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _xifexpression;
    }

    protected List<Type> _typesToImport(FeatureCall it) {
        List<Object> _xifexpression = null;
        EObject _feature = it.getFeature();
        if (_feature instanceof Type) {
            EObject _feature_1 = it.getFeature();
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Type[]{(Type)_feature_1}));
        } else {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _xifexpression;
    }

    protected List<Type> _typesToImport(TypeCastExpression it) {
        Type _type = it.getType();
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Type[]{_type}));
    }

    @XbaseGenerated
    protected CharSequence toCode(Object it) {
        if (it instanceof SCTUnitClass) {
            return this._toCode((SCTUnitClass)it);
        }
        if (it instanceof SCTUnitSuite) {
            return this._toCode((SCTUnitSuite)it);
        }
        if (it instanceof SCTUnitOperation) {
            return this._toCode((SCTUnitOperation)it);
        }
        if (it instanceof VariableDefinitionStatement) {
            return this._toCode((VariableDefinitionStatement)it);
        }
        if (it instanceof List) {
            return this._toCode((List)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected String fqn(EObject it) {
        if (it instanceof NamedElement) {
            return this._fqn((NamedElement)it);
        }
        if (it != null) {
            return this._fqn(it);
        }
        return this._fqn((Void)null);
    }

    @XbaseGenerated
    protected List<Type> typesToImport(EObject it) {
        if (it instanceof ElementReferenceExpression) {
            return this._typesToImport((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._typesToImport((FeatureCall)it);
        }
        if (it instanceof TypeCastExpression) {
            return this._typesToImport((TypeCastExpression)it);
        }
        if (it instanceof TypeSpecifier) {
            return this._typesToImport((TypeSpecifier)it);
        }
        if (it != null) {
            return this._typesToImport(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

