/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.java.extensions;

import com.google.inject.Inject;
import com.yakindu.base.types.Expression;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions;
import com.yakindu.sctunit.generator.java.extensions.IMockingExtensions;
import com.yakindu.sctunit.generator.java.extensions.JavaExpressionExtensions;
import com.yakindu.sctunit.sCTUnit.AssertionStatement;
import com.yakindu.sctunit.sCTUnit.ExpressionStatement;
import com.yakindu.sctunit.sCTUnit.IfStatement;
import com.yakindu.sctunit.sCTUnit.LoopStatement;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.ReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JavaStatementExtensions
extends BaseStatementExtensions {
    @Inject
    @Extension
    private JavaExpressionExtensions _javaExpressionExtensions;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private IMockingExtensions _iMockingExtensions;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;

    protected CharSequence _generate(AssertionStatement stm) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("assertTrue(");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)stm.getErrorMsg());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\"");
            String _errorMsg = stm.getErrorMsg();
            _builder.append(_errorMsg);
            _builder.append("\",");
        }
        CharSequence _code = this._javaExpressionExtensions.code((EObject)stm.getExpression());
        _builder.append((Object)_code);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generate(VariableDefinitionStatement stm) {
        boolean _tripleNotEquals;
        StringConcatenation _xifexpression = null;
        Expression _initialValue = stm.getDefinition().getInitialValue();
        boolean bl = _tripleNotEquals = _initialValue != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(stm.getDefinition().getType());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _name = stm.getDefinition().getName();
            _builder.append(_name);
            _builder.append(" = ");
            CharSequence _code = this._javaExpressionExtensions.code((EObject)stm.getDefinition().getInitialValue());
            _builder.append((Object)_code);
            _builder.append(";");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(stm.getDefinition().getType());
            _builder_1.append(_targetLanguageName_1);
            _builder_1.append(" ");
            String _name_1 = stm.getDefinition().getName();
            _builder_1.append(_name_1);
            _builder_1.append(";");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected CharSequence _generate(VerifyCalledStatement it) {
        String _xifexpression = null;
        boolean _isNegated = it.isNegated();
        boolean _not = !_isNegated;
        _xifexpression = _not ? this._iMockingExtensions.generatePositiveVerify(it) : this._iMockingExtensions.generateNegativeVerify(it);
        return _xifexpression;
    }

    protected CharSequence _generate(MockReturnStatement it) {
        return this._iMockingExtensions.generateMockReturn(it);
    }

    public long getCyclePeriod(SCTUnitClass it) {
        return this._statechartAnnotations.getCyclePeriod((EObject)it.getStatechart());
    }

    @XbaseGenerated
    public CharSequence generate(TestStatement it) {
        if (it instanceof MockReturnStatement) {
            return this._generate((MockReturnStatement)it);
        }
        if (it instanceof VerifyCalledStatement) {
            return this._generate((VerifyCalledStatement)it);
        }
        if (it instanceof AssertionStatement) {
            return this._generate((AssertionStatement)it);
        }
        if (it instanceof ExpressionStatement) {
            return this._generate((ExpressionStatement)it);
        }
        if (it instanceof IfStatement) {
            return this._generate((IfStatement)it);
        }
        if (it instanceof LoopStatement) {
            return this._generate((LoopStatement)it);
        }
        if (it instanceof ReturnStatement) {
            return this._generate((ReturnStatement)it);
        }
        if (it instanceof VariableDefinitionStatement) {
            return this._generate((VariableDefinitionStatement)it);
        }
        if (it != null) {
            return this._generate(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

