/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.dialogs;

import com.xformation.lmx.LmxFeatureInfo;
import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DeleteDialog
extends MessageDialog {
    private static final String[] MSG_DIALOG_BUTTON_LABELS = new String[]{"OK", "Cancel"};
    private static final String DELETE_DIALOG_MESSAGE = "Do you really want to delete license file \"%s\"?%n%nIt contains licenses for the following feature(s):";
    private final Set<ILicenseManager> relatedLicenseManagers = new HashSet<ILicenseManager>();
    private final File licenseFile;

    public DeleteDialog(Shell parentShell, File file) {
        super(parentShell, "Confirm Delete", null, "", 6, MSG_DIALOG_BUTTON_LABELS, 0);
        this.licenseFile = file;
        this.init();
    }

    public Set<ILicenseManager> getRelatedLicenseManagers() {
        return this.relatedLicenseManagers;
    }

    private void init() {
        String msg = String.format(DELETE_DIALOG_MESSAGE, this.licenseFile.getName());
        List<AbstractLicenseFeature> licenseFeatures = LicenseManagementUiActivator.getDefault().getLicenseFeatures();
        HashSet<String> featureNames = new HashSet<String>();
        for (AbstractLicenseFeature feature : licenseFeatures) {
            LmxFeatureInfo licenseInfo = null;
            try {
                IEclipseLicenseManager licManager = EclipseLicenseHelper.INSTANCE.getLicenseManager(feature);
                licenseInfo = licManager.getFeatureInfo();
            }
            catch (LicenseException e) {
                LoggingHelper.warn((String)"Unable to get a license manager for feature '%s'. Error:\n%s", (Object[])new Object[]{feature, e.getMessage()});
            }
            if (licenseInfo == null || !this.licenseFile.getAbsolutePath().equals(licenseInfo.getPath())) continue;
            if (feature != null) {
                featureNames.add(String.valueOf(feature.getProductName()) + " " + feature.getFeatureName());
                this.addRelatedLicenseManager(feature);
                continue;
            }
            featureNames.add(licenseInfo.getFeatureName());
        }
        ArrayList sortedFeatureNames = new ArrayList(featureNames);
        Collections.sort(sortedFeatureNames);
        for (String featureName : sortedFeatureNames) {
            msg = String.valueOf(msg) + String.format("%n - %s", featureName);
        }
        this.message = msg;
    }

    private void addRelatedLicenseManager(AbstractLicenseFeature licenseFeature) {
        try {
            IEclipseLicenseManager manager = EclipseLicenseHelper.INSTANCE.getLicenseManager(licenseFeature);
            this.relatedLicenseManagers.add((ILicenseManager)manager);
        }
        catch (LicenseException e) {
            LicenseManagementUiActivator.log(e.getMessage(), 4, null, false, false);
        }
    }
}

