/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.model;

import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.ILicenseChangedListener;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;

public class LicenseTableModel
extends Observable
implements ILicenseChangedListener {
    private static List<AbstractLicenseFeature> licensesFeatures;
    private static LicenseTableModel instance;
    private final Set<TableItemData> model = new HashSet<TableItemData>();
    private volatile boolean listenerEnabled = true;

    public static LicenseTableModel getInstance() {
        if (instance == null) {
            instance = new LicenseTableModel();
            licensesFeatures = LicenseManagementUiActivator.getDefault().getLicenseFeatures();
        }
        return instance;
    }

    public Set<TableItemData> getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModel(Shell shell) {
        LicenseTableModel licenseTableModel = this;
        synchronized (licenseTableModel) {
            this.clearModel();
            int i = 0;
            while (i < licensesFeatures.size()) {
                AbstractLicenseFeature licenseFeature = licensesFeatures.get(i);
                try {
                    IEclipseLicenseManager licenseManager = EclipseLicenseHelper.INSTANCE.getLicenseManager(licenseFeature);
                    licenseManager.addListener((ILicenseChangedListener)this);
                    this.model.add(new TableItemData(licenseFeature, licenseManager));
                }
                catch (LicenseException e) {
                    LoggingHelper.warn((String)"Unable to get a license manager for feature '%s'. Error:\n%s", (Object[])new Object[]{licenseFeature, e.getMessage()});
                }
                ++i;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void clearModel() {
        for (TableItemData data : this.model) {
            data.getLicenseManager().removeListener((ILicenseChangedListener)this);
        }
        this.model.clear();
    }

    public void notify(ILicenseChangedListener.LicenseNotificationEvent event, ILicenseManager licenseManagerWithChangedLicenseStatus) {
        if (!this.listenerEnabled) {
            return;
        }
        this.updateModel(null);
    }

    public void setListenerEnabled(boolean enabled) {
        this.listenerEnabled = enabled;
    }
}

