/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.model;

import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxLicenseType;
import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.LicenseStatus;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;

public class TableItemData {
    private final AbstractLicenseFeature licenseFeature;
    private final IEclipseLicenseManager licenseManager;
    private final ActionType actionType;
    private final LicenseStatus status;

    public TableItemData(AbstractLicenseFeature licenseFeature, IEclipseLicenseManager licenseManager) {
        this.licenseFeature = licenseFeature;
        this.licenseManager = licenseManager;
        this.actionType = TableItemData.computeActionType(licenseManager);
        this.status = licenseManager.getLicenseStatus();
    }

    private static ActionType computeActionType(IEclipseLicenseManager licenseManager) {
        LmxFeatureInfo featureInfo = licenseManager.getFeatureInfo();
        if (featureInfo != null) {
            switch (featureInfo.getLicenseType()) {
                case LMX_TYPE_LOCAL: {
                    return ActionType.DELETABLE;
                }
                case LMX_TYPE_NETWORK: {
                    if (((LicenseService)ILicenseService.INSTANCE).getSettings().isAutoBorrowingEnabled()) {
                        return ActionType.NONE;
                    }
                    return ActionType.BORROWABLE;
                }
                case LMX_TYPE_BORROW: {
                    if (((LicenseService)ILicenseService.INSTANCE).getSettings().isAutoBorrowingEnabled()) {
                        return ActionType.NONE;
                    }
                    return ActionType.RETURNABLE;
                }
            }
            if (LicenseService.DEBUG) {
                if (licenseManager.getLicenseStatus() == LicenseStatus.VALID) {
                    return ActionType.RELEASABLE;
                }
                if (featureInfo.getLicenseType().equals((Object)LmxLicenseType.LMX_TYPE_TRIAL)) {
                    return ActionType.RETRYABLE;
                }
            }
        } else {
            if (TableItemData.isLicenseCheckoutFailed((ILicenseManager)licenseManager)) {
                return ActionType.RETRYABLE;
            }
            if (LicenseService.DEBUG && (licenseManager.getLicenseStatus() == LicenseStatus.UNCHECKED || licenseManager.getLicenseStatus() == LicenseStatus.UNUSED)) {
                return ActionType.ACQUIREABLE;
            }
        }
        return ActionType.NONE;
    }

    private static boolean isLicenseCheckoutFailed(ILicenseManager licenseManager) {
        LicenseStatus licenseStatus = licenseManager.getLicenseStatus();
        if (licenseStatus == LicenseStatus.MISSING || licenseStatus == LicenseStatus.EXPIRED) {
            return true;
        }
        String statusMessage = licenseManager.getStatusMessage();
        return !licenseStatus.text.equals(statusMessage);
    }

    public AbstractLicenseFeature getLicenseFeature() {
        return this.licenseFeature;
    }

    public IEclipseLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public LmxFeatureInfo getFeatureInfo() {
        return this.licenseManager.getFeatureInfo();
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public LicenseStatus getStatus() {
        return this.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionType == null ? 0 : this.actionType.hashCode());
        result = 31 * result + (this.getFeatureInfo() == null ? 0 : this.getFeatureInfo().getFeatureName().hashCode());
        result = 31 * result + (this.licenseFeature == null ? 0 : this.licenseFeature.getLicenseFeatureId().hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableItemData other = (TableItemData)obj;
        if (this.actionType != other.actionType) {
            return false;
        }
        LmxFeatureInfo featureInfo = this.getFeatureInfo();
        if (featureInfo == null) {
            if (other.getFeatureInfo() != null) {
                return false;
            }
        } else {
            if (other.getFeatureInfo() == null) {
                return false;
            }
            if (featureInfo.getFeatureName() != null && !featureInfo.getFeatureName().equals(other.getFeatureInfo().getFeatureName())) {
                return false;
            }
        }
        if (this.licenseFeature == null) {
            if (other.licenseFeature != null) {
                return false;
            }
        } else {
            if (other.licenseFeature == null) {
                return false;
            }
            if (this.licenseFeature.getLicenseFeatureId() != null && !this.licenseFeature.getLicenseFeatureId().equals(other.licenseFeature.getLicenseFeatureId())) {
                return false;
            }
        }
        return this.status == other.status;
    }

    public static enum ActionType {
        DELETABLE,
        BORROWABLE,
        RETURNABLE,
        ACQUIREABLE,
        RETRYABLE,
        RELEASABLE,
        NONE;

    }
}

