/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences;

import com.yakindu.licmgmt.internal.preferences.ILicensePreferences;
import com.yakindu.licmgmt.internal.preferences.LicensePreferences;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.dialogs.LicenseDetailsDialog;
import com.yakindu.licmgmt.ui.internal.model.LicenseTableModel;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import com.yakindu.licmgmt.ui.internal.preferences.NotificationSelectionListener;
import com.yakindu.licmgmt.ui.internal.preferences.providers.ActionLabelProvider;
import com.yakindu.licmgmt.ui.internal.preferences.providers.FeatureLabelProvider;
import com.yakindu.licmgmt.ui.internal.preferences.providers.LicenseEnabledProvider;
import com.yakindu.licmgmt.ui.internal.preferences.providers.LicenseViewerComparator;
import com.yakindu.licmgmt.ui.internal.preferences.providers.NotificationLabelProvider;
import com.yakindu.licmgmt.ui.internal.preferences.providers.ProductLabelProvider;
import com.yakindu.licmgmt.ui.internal.preferences.providers.StatusLabelProvider;
import com.yakindu.licmgmt.ui.internal.preferences.providers.TypeLabelProvider;
import com.yakindu.licmgmt.ui.internal.utils.LicenseUiHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class LicenseTableFieldEditor
extends FieldEditor
implements ILicensePreferences {
    private static final String FIELD_EDITOR_KEY = "yakinduLicenses";
    private static final String LICENSE_INFO_LABEL_TOP = "";
    private static final String LICENSE_INFO_LABEL_BOTTOM = "Double click a license to open details; click bell to toggle notification popups.";
    private static final int TABLE_CELL_PADDING = 5;
    private CheckboxTableViewer tableViewer;
    private final Map<String, Boolean> notifications = new HashMap<String, Boolean>();
    private final Map<String, Boolean> licensesEnabled = new HashMap<String, Boolean>();
    private final Map<String, Boolean> savedNotifications = new HashMap<String, Boolean>();
    private final Map<String, Boolean> savedLicensesEnabled = new HashMap<String, Boolean>();
    private Observer modelObserver;
    private final NotificationLabelProvider notificationLabelProvider = new NotificationLabelProvider(this.notifications);
    private final LicenseEnabledProvider licenseEnabledProvider = new LicenseEnabledProvider(this.licensesEnabled);
    private ColumnLabelProvider actionLabelProvider;
    private int actionColumnIndex;
    private ICheckStateListener checkedStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object changedElement = event.getElement();
            if (changedElement instanceof TableItemData) {
                TableItemData itemData = (TableItemData)changedElement;
                String licenseFeatureID = itemData.getLicenseFeature().getLicenseFeatureId();
                boolean isChecked = event.getChecked();
                boolean wasChecked = false;
                if (LicenseTableFieldEditor.this.licensesEnabled.containsKey(licenseFeatureID)) {
                    wasChecked = LicenseTableFieldEditor.this.licensesEnabled.get(licenseFeatureID);
                }
                if (wasChecked != isChecked) {
                    LicenseTableFieldEditor.this.licensesEnabled.put(licenseFeatureID, isChecked);
                    LicenseTableFieldEditor.this.fireValueChanged("field_editor_value", wasChecked, isChecked);
                    LicenseTableFieldEditor.this.tableViewer.refresh();
                }
            }
        }
    };

    public LicenseTableFieldEditor(Composite parent) {
        this.init(FIELD_EDITOR_KEY, LICENSE_INFO_LABEL_TOP);
        this.createControl(parent);
        this.tableViewer.setInput(LicenseTableModel.getInstance().getModel());
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        GridData gd = new GridData(4, 4, true, true);
        parent.setLayoutData((Object)gd);
        Label label = this.getLabelControl(parent);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = numColumns;
        label.setLayoutData((Object)gd);
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayout((Layout)new GridLayout(2, true));
        buttonBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.initButtons(buttonBar);
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayout((Layout)new FillLayout(256));
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = numColumns;
        tableComposite.setLayoutData((Object)gd);
        this.initTableControl(tableComposite);
        new Label(parent, 0).setText(LICENSE_INFO_LABEL_BOTTOM);
        parent.layout(true);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.tableViewer.getTable().getLayoutData()).horizontalSpan = numColumns;
    }

    public void initTableControl(Composite parent) {
        if (this.tableViewer == null) {
            this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68352);
            ColumnLabelProvider productLabelProvider = this.createColumnsAndReturnProductLabelProvider();
            this.packColumns();
            this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)new NotificationSelectionListener((TableViewer)this.tableViewer, 4, this.notifications));
            this.tableViewer.addDoubleClickListener(event -> {
                int n = new LicenseDetailsDialog(parent.getShell(), (TableItemData)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement()).open();
            });
            this.tableViewer.addCheckStateListener(this.checkedStateListener);
            this.tableViewer.setCheckStateProvider((ICheckStateProvider)this.licenseEnabledProvider);
            this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.tableViewer.setComparator((ViewerComparator)new LicenseViewerComparator(productLabelProvider));
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
            Table table = this.tableViewer.getTable();
            table.setFont(parent.getFont());
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            this.addObserver(table);
        } else {
            this.checkParent((Control)this.tableViewer.getTable(), parent);
        }
    }

    private void addObserver(Table table) {
        this.modelObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Display.getDefault().syncExec(() -> {
                    LicenseTableFieldEditor.this.refreshTable();
                    if (!LicenseTableFieldEditor.this.tableViewer.getSelection().isEmpty()) {
                        LicenseTableFieldEditor.this.tableViewer.setSelection(null, false);
                    }
                });
            }
        };
        LicenseTableModel.getInstance().addObserver(this.modelObserver);
        table.addDisposeListener(event -> LicenseTableModel.getInstance().deleteObserver(this.modelObserver));
    }

    private ColumnLabelProvider createColumnsAndReturnProductLabelProvider() {
        ProductLabelProvider productLabelProvider = new ProductLabelProvider(this.licensesEnabled);
        this.addColumn((TableViewer)this.tableViewer, "Product", 100, 16384, productLabelProvider);
        this.addColumn((TableViewer)this.tableViewer, "Feature", 150, 16384, new FeatureLabelProvider(this.licensesEnabled));
        this.addColumn((TableViewer)this.tableViewer, "Status", 200, 16384, new StatusLabelProvider(this.licensesEnabled));
        this.addColumn((TableViewer)this.tableViewer, "Type", 120, 16384, new TypeLabelProvider(this.licensesEnabled));
        this.addColumn((TableViewer)this.tableViewer, "Notification", 100, 16384, this.notificationLabelProvider);
        this.actionLabelProvider = new ActionLabelProvider();
        TableViewerColumn actionCol = this.addColumn((TableViewer)this.tableViewer, "Actions", 100, 16384, this.actionLabelProvider);
        actionCol.getColumn().setResizable(false);
        this.actionColumnIndex = this.tableViewer.getTable().getColumnCount() - 1;
        return productLabelProvider;
    }

    private TableViewerColumn addColumn(final TableViewer viewer, String name, int width, int style, final ColumnLabelProvider labelProvider) {
        final TableViewerColumn column = new TableViewerColumn(viewer, style);
        column.getColumn().setText(name);
        column.getColumn().setWidth(width);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
            boolean ascending = true;

            public void widgetSelected(SelectionEvent e) {
                this.ascending = !this.ascending;
                viewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        String label1 = this.getColumnText(labelProvider, e1);
                        String label2 = this.getColumnText(labelProvider, e2);
                        if (ascending) {
                            return label1.compareTo(label2);
                        }
                        return label2.compareTo(label1);
                    }

                    private String getColumnText(ColumnLabelProvider labelProvider2, Object element) {
                        String label = labelProvider2.getText(element);
                        if (label == null || label.isEmpty() && labelProvider2.getToolTipText(element) != null) {
                            label = labelProvider2.getToolTipText(element);
                        }
                        return label == null ? LicenseTableFieldEditor.LICENSE_INFO_LABEL_TOP : label;
                    }
                });
                viewer.getTable().setSortColumn(column.getColumn());
                viewer.getTable().setSortDirection(this.ascending ? 1024 : 128);
                LicenseTableFieldEditor.this.refreshTable();
            }
        });
        column.getColumn().setToolTipText("Click on column header for sorting the table.");
        return column;
    }

    private void initButtons(final Composite parent) {
        Button importButton = new Button(parent, 8);
        importButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        importButton.setText("Import License File...");
        importButton.setToolTipText("Import new license files into the application or user home directory");
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LicenseUiHelper.importLicense(parent.getShell())) {
                    parent.layout();
                }
            }
        });
        Button diagnoseButton = new Button(parent, 8);
        diagnoseButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        diagnoseButton.setText("Create Diagnose Information");
        diagnoseButton.setToolTipText("Gather information about the current system, product, and available licenses");
        diagnoseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseUiHelper.createDiagnosticFile(LicenseTableFieldEditor.this.getShell());
            }
        });
    }

    protected void doStore() {
        this.saveFeatureSettings();
        this.savedLicensesEnabled.putAll(this.licensesEnabled);
        this.savedNotifications.putAll(this.notifications);
    }

    protected void doLoad() {
        this.notifications.clear();
        this.licensesEnabled.clear();
        this.loadFeatureSettings();
        this.refreshModel();
    }

    protected void doLoadDefault() {
        this.doLoad();
    }

    public void refreshModel() {
        LicenseTableModel.getInstance().updateModel(this.getShell());
    }

    private void saveFeatureSettings() {
        for (AbstractLicenseFeature feature : LicenseManagementUiActivator.getDefault().getLicenseFeatures()) {
            String licenseFeatureID = feature.getLicenseFeatureId();
            LicensePreferences.setLicenseEnabled((String)licenseFeatureID, (boolean)this.licensesEnabled.get(licenseFeatureID));
            LicensePreferences.setLicenseNotification((String)licenseFeatureID, (boolean)this.notifications.get(licenseFeatureID));
        }
    }

    public void loadFeatureSettings() {
        for (AbstractLicenseFeature feature : LicenseManagementUiActivator.getDefault().getLicenseFeatures()) {
            String licenseFeatureID = feature.getLicenseFeatureId();
            this.licensesEnabled.put(licenseFeatureID, LicensePreferences.isLicenseEnabled((String)licenseFeatureID));
            this.notifications.put(licenseFeatureID, LicensePreferences.isLicenseNotification((String)licenseFeatureID));
        }
        this.savedLicensesEnabled.putAll(this.licensesEnabled);
        this.savedNotifications.putAll(this.notifications);
    }

    private Shell getShell() {
        return this.getPage().getShell();
    }

    public void store() {
        if (this.getPreferenceStore() != null) {
            this.doStore();
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    private void refreshTable() {
        this.actionLabelProvider.dispose();
        this.tableViewer.refresh();
        this.packColumns();
    }

    private void packColumns() {
        Table table = this.tableViewer.getTable();
        int amountOfColumns = table.getColumnCount();
        int i = 0;
        while (i < amountOfColumns) {
            if (i != this.actionColumnIndex) {
                TableColumn col = table.getColumn(i);
                col.pack();
                col.setWidth(col.getWidth() + 10);
            }
            ++i;
        }
    }

    public boolean hasChangedEnableStates() {
        return !this.licensesEnabled.equals(this.savedLicensesEnabled) || !this.notifications.equals(this.savedNotifications);
    }
}

