/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.perspective;

import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class SCTPerspectiveManager
extends PerspectiveManager
implements ILaunchListener,
IDebugEventSetListener {
    private static final String SIMULATION_VIEW_ID = "com.yakindu.sct.simulation.ui.declarationview";
    private static final String LAUNCH_TYPE = "com.yakindu.sct.simulation.core.launch.statechart";

    public SCTPerspectiveManager() {
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.activate_debug_view", false);
    }

    public void launchAdded(ILaunch launch) {
        try {
            ILaunchConfigurationType type = launch.getLaunchConfiguration().getType();
            if (type.getIdentifier().equals(LAUNCH_TYPE)) {
                this.schedulePerspectiveSwitchJob("com.yakindu.sct.ui.SimulationPerspective");
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent debugEvent = debugEventArray[n2];
            if (debugEvent.getSource().getClass().equals(SCTDebugTarget.class)) {
                switch (debugEvent.getKind()) {
                    case 8: {
                        if (!this.allTargetsTerminated()) break;
                        this.schedulePerspectiveSwitchJob("com.yakindu.sct.ui.ModelingPerspective");
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    protected boolean allTargetsTerminated() {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
            int n3 = iDebugTargetArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IDebugTarget target = iDebugTargetArray[n4];
                if (!target.isTerminated()) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    protected void schedulePerspectiveSwitchJob(final String perspectiveID) {
        UIJob switchJob = new UIJob(DebugUIPlugin.getStandardDisplay(), "Perspective Switch Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null && !SCTPerspectiveManager.this.isCurrentPerspective(window, perspectiveID)) {
                    SCTPerspectiveManager.this.switchToPerspective(window, perspectiveID);
                }
                if (window != null) {
                    try {
                        window.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(SCTPerspectiveManager.SIMULATION_VIEW_ID);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        switchJob.setSystem(true);
        switchJob.setPriority(10);
        switchJob.setRule(AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule((Object)this));
        switchJob.schedule();
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }
}

