/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.image.renderer;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramImageGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramSVGGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.swt.widgets.Shell;

public class CopyToImageUtil2
extends CopyToImageUtil {
    protected DiagramGenerator getDiagramGenerator(DiagramEditPart diagramEP, ImageFileFormat format) {
        if (format.equals((Object)ImageFileFormat.SVG) || format.equals((Object)ImageFileFormat.PDF)) {
            return new DiagramSVGGenerator(diagramEP){

                protected Collection<ConnectionEditPart> findConnectionsToPaint(IGraphicalEditPart editPart) {
                    LinkedHashSet editParts = new LinkedHashSet();
                    LinkedHashSet<ConnectionEditPart> connectionEPs = new LinkedHashSet<ConnectionEditPart>();
                    LinkedHashSet<ConnectionEditPart> connectionsToPaint = new LinkedHashSet<ConnectionEditPart>();
                    this.getNestedEditParts(editPart, editParts);
                    Iterator editPartsItr = editParts.iterator();
                    while (editPartsItr.hasNext()) {
                        connectionEPs.addAll(this.getAllConnectionsFrom((GraphicalEditPart)editPartsItr.next()));
                    }
                    while (!connectionEPs.isEmpty()) {
                        Stack<ConnectionEditPart> connectionsPath = new Stack<ConnectionEditPart>();
                        ConnectionEditPart conn = (ConnectionEditPart)connectionEPs.iterator().next();
                        connectionEPs.remove(conn);
                        connectionsPath.add(conn);
                        EditPart target = conn.getTarget();
                        while (connectionEPs.contains(target)) {
                            ConnectionEditPart targetConn = (ConnectionEditPart)target;
                            connectionEPs.remove(targetConn);
                            connectionsPath.add(targetConn);
                            target = targetConn.getTarget();
                        }
                        if (!editParts.contains(target) && !connectionsToPaint.contains(target)) continue;
                        connectionsToPaint.addAll(connectionsPath);
                    }
                    return connectionsToPaint;
                }

                private void getNestedEditParts(IGraphicalEditPart childEditPart, Collection editParts) {
                    for (IGraphicalEditPart child : childEditPart.getChildren()) {
                        editParts.add(child);
                        this.getNestedEditParts(child, editParts);
                    }
                }

                private List<ConnectionEditPart> getAllConnectionsFrom(GraphicalEditPart ep) {
                    LinkedList<ConnectionEditPart> connections = new LinkedList<ConnectionEditPart>();
                    for (ConnectionEditPart sourceConn : ep.getSourceConnections()) {
                        connections.add(sourceConn);
                        connections.addAll(this.getAllConnectionsFrom((GraphicalEditPart)sourceConn));
                    }
                    return connections;
                }
            };
        }
        return new DiagramImageGenerator(diagramEP);
    }

    public byte[] copyToImageByteArray(Diagram diagram, int maxWidth, int maxHeight, ImageFileFormat format, IProgressMonitor monitor, PreferencesHint preferencesHint, boolean useMargins) throws CoreException {
        Shell shell = null;
        try {
            DiagramEditPart diagramEditPart;
            TransactionalEditingDomain editingDomain;
            shell = new Shell();
            if (diagram == null) {
                System.err.println("[ERROR] Diagram is null! Cannot render image.");
            }
            if ((editingDomain = TransactionUtil.getEditingDomain((EObject)diagram)) == null) {
                TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(diagram.eResource().getResourceSet());
            }
            if ((diagramEditPart = this.createDiagramEditPart(diagram, shell, preferencesHint)) == null) {
                System.err.println("[ERROR] DiagramEditPart is null! Rendering cannot proceed.");
            }
            byte[] byArray = this.copyToImageByteArray(diagramEditPart, null, maxWidth, maxHeight, format, monitor, useMargins);
            return byArray;
        }
        catch (Throwable t) {
            System.err.println("[ERROR] Exception during renderImage: " + t.getMessage());
            t.printStackTrace();
        }
        finally {
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
        }
        System.err.println("[ERROR] Final result is null, image generation failed!");
        return this.copyToImageByteArray(null, null, maxWidth, maxHeight, format, monitor, useMargins);
    }
}

