/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.base;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.concepts.SubchartTraversal;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public abstract class AbstractSubchartInitializer
extends SubchartTraversal {
    @Inject
    @Extension
    protected BaseNamingExtensions _baseNamingExtensions;
    @Inject
    @Extension
    protected StatechartAnnotations _statechartAnnotations;
    public String initSequence = null;
    public String teardownSequence = null;
    public Map<Statechart, CharSequence> imports = null;

    public abstract void buildInitSequence(Statechart var1, VariableDefinition var2);

    public abstract void buildTeardownSequence(Statechart var1, VariableDefinition var2);

    public void buildImports(Statechart subchart) {
    }

    protected void build(Statechart subchart, VariableDefinition element) {
        this.buildImports(subchart);
        this.buildInitSequence(subchart, element);
        this.buildTeardownSequence(subchart, element);
    }

    protected Object setUp() {
        HashMap _xblockexpression = null;
        super.setUp();
        this.initSequence = "";
        this.teardownSequence = "";
        _xblockexpression = this.imports = Maps.newHashMap();
        return _xblockexpression;
    }

    public String getSubchartInitSequence(Statechart it) {
        String _elvis = null;
        if (this.initSequence != null) {
            _elvis = this.initSequence;
        } else {
            String _xblockexpression = null;
            this.perform(it);
            _elvis = _xblockexpression = this.initSequence;
        }
        return _elvis;
    }

    public String getSubchartTeardownSequence(Statechart it) {
        String _elvis = null;
        if (this.teardownSequence != null) {
            _elvis = this.teardownSequence;
        } else {
            String _xblockexpression = null;
            this.perform(it);
            _elvis = _xblockexpression = this.teardownSequence;
        }
        return _elvis;
    }

    public Map<Statechart, CharSequence> getSubchartImports(Statechart it) {
        Map<Statechart, CharSequence> _elvis = null;
        if (this.imports != null) {
            _elvis = this.imports;
        } else {
            Map<Statechart, CharSequence> _xblockexpression = null;
            this.perform(it);
            _elvis = _xblockexpression = this.imports;
        }
        return _elvis;
    }

    public boolean hasTimedSubchart(Statechart it) {
        Functions.Function1 _function = it_1 -> this.isTimed((Statechart)it_1);
        return IterableExtensions.exists((Iterable)this.getSubchartTypes(it), (Functions.Function1)_function);
    }

    public boolean hasCycleBasedSubchart(Statechart it) {
        Functions.Function1 _function = it_1 -> this._statechartAnnotations.isCycleBased(it_1);
        return IterableExtensions.exists((Iterable)this.getSubchartTypes(it), (Functions.Function1)_function);
    }

    public boolean needsTimer(Statechart it) {
        return this._statechartAnnotations.isCycleBased(it) || this.isTimed(it) || this.hasCycleBasedSubchart(it) || this.hasTimedSubchart(it);
    }

    public boolean isTimed(Statechart it) {
        int _size = IteratorExtensions.size((Iterator)Iterators.filter((Iterator)it.eAllContents(), TimeEventSpec.class));
        return _size > 0;
    }
}

