/*
 * Decompiled with CFR 0.152.
 */
package com.xformation.lmx;

import com.xformation.lmx.LmxException;
import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxHostid;
import com.xformation.lmx.LmxHostidType;
import com.xformation.lmx.LmxKeyHostidType;
import com.xformation.lmx.LmxLicenseInfo;
import com.xformation.lmx.LmxSettings;
import com.xformation.lmx.LmxStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class Lmx {
    private long[] lmxHandle = new long[]{0L};
    private static CustomHostidCallback customHostidFunction = null;
    private static HostidCompareCallback hostidCompareFunction = null;
    private static HeartbeatConnectionLostCallback heartbeatConnectionLostConsumer = null;
    private static HeartbeatCheckoutFailureCallback heartbeatCheckoutFailureConsumer = null;
    private static HeartbeatCheckoutSuccessCallback heartbeatCheckoutSuccessConsumer = null;
    private static HeartbeatRetryFeatureCallback heartbeatRetryFeatureConsumer = null;
    private static HeartbeatExitCallback heartbeatExitConsumer = null;
    public static final String LMX_ALL_FEATURES = "";
    public static final int LMX_ALL_LICENSES = 0;
    public static final int LMX_SHARE_NONE = 0;
    public static final int LMX_SHARE_HOST = 1;
    public static final int LMX_SHARE_USER = 2;
    public static final int LMX_SHARE_CUSTOM = 4;
    public static final int LMX_SHARE_TS = 256;
    public static final int LMX_SHARE_VIRTUAL = 4096;
    public static final int LMX_SHARE_SINGLE = 8192;
    public static final int LMX_UNLIMITED_COUNT = -1;
    public static final int LMX_LOGICAL_CPU_COUNT = -2;
    public static final int LMX_PHYSICAL_CPU_COUNT = -3;
    public static final int LMX_MAX_BORROW_HOURS = 8760;
    public static final int LMX_MAX_GRACE_HOURS = 168;

    public Lmx() {
        this.lmxHandle[0] = 0L;
    }

    private native int jniCInit(long[] var1);

    private native void jniCFree(long var1);

    private native int jniCGetVersion();

    private native int jniCHostidSimple(long var1, int var3, String[] var4);

    private native LmxHostid[] jniCHostid(long var1, LmxHostidType var3);

    private native int jniCClientStoreSave(long var1, String var3, String var4);

    private native int jniCClientStoreLoad(long var1, String var3, String[] var4);

    private native int jniCCheckout(long var1, String var3, int var4, int var5, int var6);

    private native int jniCCheckin(long var1, String var3, int var4);

    private native int jniCHeartbeat(long var1, String var3);

    private native int jniCSetOptionInt(long var1, LmxSettings var3, int var4);

    private native int jniCSetOptionStr(long var1, LmxSettings var3, String var4);

    private native int jniCSetOptionEnumHostidType(long var1, LmxSettings var3, LmxHostidType var4);

    private native int jniCGetExpireTime(long var1, String var3);

    private native int jniCGetFeatureInfo(long var1, String var3, LmxFeatureInfo var4);

    private native int jniCGetLicenseInfo(long var1, List<LmxLicenseInfo> var3);

    private native int jniCPutenv(String var1);

    private native int jniCServerLog(long var1, String var3, String var4);

    private native int jniCServerFunction(long var1, String var3, String var4, String[] var5);

    private native int jniCGetSystemClockTime(long var1, String var3, long[] var4);

    public void init() throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCInit(this.lmxHandle));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void free() {
        this.jniCFree(this.lmxHandle[0]);
        this.lmxHandle[0] = 0L;
    }

    public int getVersion() {
        return this.jniCGetVersion();
    }

    public String getHostidSimple(LmxHostidType hostidType) throws LmxException {
        String[] strHostid = new String[1];
        LmxStatus error = LmxStatus.valueOf(this.jniCHostidSimple(this.lmxHandle[0], hostidType.ordinal(), strHostid));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
        return strHostid[0];
    }

    public LmxHostid[] getHostid(LmxHostidType hostidType) throws LmxException {
        return this.jniCHostid(this.lmxHandle[0], hostidType);
    }

    public void clientStoreSave(String virtualFilename, String content) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCClientStoreSave(this.lmxHandle[0], virtualFilename, content));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public String clientStoreLoad(String virtualFilename) throws LmxException {
        String[] content = new String[1];
        LmxStatus error = LmxStatus.valueOf(this.jniCClientStoreLoad(this.lmxHandle[0], virtualFilename, content));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
        return content[0];
    }

    public void checkout(String featureName, int verMajor, int verMinor, int count) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCCheckout(this.lmxHandle[0], featureName, verMajor, verMinor, count));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void checkin(String featureName, int count) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCCheckin(this.lmxHandle[0], featureName, count));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void heartbeat(String featureName) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCHeartbeat(this.lmxHandle[0], featureName));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void setOption(LmxSettings setting, String strOption) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCSetOptionStr(this.lmxHandle[0], setting, strOption));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void setOption(LmxSettings setting, int option) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCSetOptionInt(this.lmxHandle[0], setting, option));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void setOption(LmxSettings setting, boolean option) throws LmxException {
        this.setOption(setting, option ? 1 : 0);
    }

    public void setOption(LmxSettings setting, LmxHostidType option) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCSetOptionEnumHostidType(this.lmxHandle[0], setting, option));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public int getExpireTime(String featureName) {
        return this.jniCGetExpireTime(this.lmxHandle[0], featureName);
    }

    public LmxFeatureInfo getFeatureInfo(String featureName) throws LmxException {
        LmxFeatureInfo featureInfo = new LmxFeatureInfo();
        LmxStatus error = LmxStatus.valueOf(this.jniCGetFeatureInfo(this.lmxHandle[0], featureName, featureInfo));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
        return featureInfo;
    }

    public void putEnv(String variable) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCPutenv(variable));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public void serverLog(String featureName, String message) throws LmxException {
        LmxStatus error = LmxStatus.valueOf(this.jniCServerLog(this.lmxHandle[0], featureName, message));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
    }

    public String serverFunction(String featureName, String message) throws LmxException {
        String[] response = new String[1];
        LmxStatus error = LmxStatus.valueOf(this.jniCServerFunction(this.lmxHandle[0], featureName, message, response));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
        return response[0];
    }

    public long getSystemClockTime(String featureName) throws LmxException {
        long[] time = new long[1];
        LmxStatus error = LmxStatus.valueOf(this.jniCGetSystemClockTime(this.lmxHandle[0], featureName, time));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
        return time[0];
    }

    public List<LmxLicenseInfo> getLicenseInfo() throws LmxException {
        ArrayList<LmxLicenseInfo> licenseInfoList = new ArrayList<LmxLicenseInfo>();
        LmxStatus error = LmxStatus.valueOf(this.jniCGetLicenseInfo(this.lmxHandle[0], licenseInfoList));
        if (error != LmxStatus.LMX_SUCCESS) {
            throw new LmxException(error, this.lmxHandle[0]);
        }
        return licenseInfoList;
    }

    public void setCustomHostidCallback(CustomHostidCallback function) throws LmxException {
        customHostidFunction = function;
        this.setOption(LmxSettings.LMX_OPT_CUSTOM_HOSTID_FUNCTION, function != null);
    }

    public void setHostidCompareCallback(HostidCompareCallback function) throws LmxException {
        hostidCompareFunction = function;
        this.setOption(LmxSettings.LMX_OPT_HOSTID_COMPARE_FUNCTION, function != null);
    }

    public void setHeartbeatConnectionLostCallback(HeartbeatConnectionLostCallback consumer) throws LmxException {
        heartbeatConnectionLostConsumer = consumer;
        this.setOption(LmxSettings.LMX_OPT_HEARTBEAT_CONNECTION_LOST_FUNCTION, consumer != null);
    }

    public void setHeartbeatCheckoutFailureCallback(HeartbeatCheckoutFailureCallback consumer) throws LmxException {
        heartbeatCheckoutFailureConsumer = consumer;
        this.setOption(LmxSettings.LMX_OPT_HEARTBEAT_CHECKOUT_FAILURE_FUNCTION, consumer != null);
    }

    public void setHeartbeatCheckoutSuccessCallback(HeartbeatCheckoutSuccessCallback consumer) throws LmxException {
        heartbeatCheckoutSuccessConsumer = consumer;
        this.setOption(LmxSettings.LMX_OPT_HEARTBEAT_CHECKOUT_SUCCESS_FUNCTION, consumer != null);
    }

    public void setHeartbeatRetryFeatureCallback(HeartbeatRetryFeatureCallback consumer) throws LmxException {
        heartbeatRetryFeatureConsumer = consumer;
        this.setOption(LmxSettings.LMX_OPT_HEARTBEAT_RETRY_FEATURE_FUNCTION, consumer != null);
    }

    public void setHeartbeatExitCallback(HeartbeatExitCallback consumer) throws LmxException {
        heartbeatExitConsumer = consumer;
        this.setOption(LmxSettings.LMX_OPT_HEARTBEAT_EXIT_FUNCTION, consumer != null);
    }

    static LmxStatus customHostidCallback(List<LmxHostid> hostidList) {
        if (customHostidFunction != null) {
            return (LmxStatus)((Object)customHostidFunction.apply(hostidList));
        }
        return LmxStatus.LMX_NOT_IMPLEMENTED;
    }

    static LmxStatus hostidCompareCallback(LmxKeyHostidType hostidType, LmxHostid[] licenseHostids, LmxHostid[] systemHostids) {
        if (hostidCompareFunction != null) {
            return (LmxStatus)((Object)hostidCompareFunction.apply(hostidType, licenseHostids, systemHostids));
        }
        return LmxStatus.LMX_NOT_IMPLEMENTED;
    }

    static void heartbeatConnectionLost(String host, int port, int failedHeartbeats) {
        if (heartbeatConnectionLostConsumer != null) {
            heartbeatConnectionLostConsumer.accept(host, port, failedHeartbeats);
        }
    }

    static void heartbeatCheckoutFailure(String featureName, int usedLicCount, int lmxStat) {
        if (heartbeatCheckoutFailureConsumer != null) {
            heartbeatCheckoutFailureConsumer.accept(featureName, usedLicCount, LmxStatus.valueOf(lmxStat));
        }
    }

    static void heartbeatCheckoutSuccess(String featureName, int usedLicCount) {
        if (heartbeatCheckoutSuccessConsumer != null) {
            heartbeatCheckoutSuccessConsumer.accept(featureName, usedLicCount);
        }
    }

    static void heartbeatRetryFeature(String featureName, int usedLicCount) {
        if (heartbeatRetryFeatureConsumer != null) {
            heartbeatRetryFeatureConsumer.accept(featureName, usedLicCount);
        }
    }

    static void heartbeatExit() {
        if (heartbeatExitConsumer != null) {
            heartbeatExitConsumer.accept();
        }
    }

    static {
        System.loadLibrary("lmxjava");
    }

    @FunctionalInterface
    public static interface HeartbeatExitCallback {
        public void accept();
    }

    @FunctionalInterface
    public static interface HeartbeatRetryFeatureCallback
    extends BiConsumer<String, Integer> {
    }

    @FunctionalInterface
    public static interface HeartbeatCheckoutSuccessCallback
    extends BiConsumer<String, Integer> {
    }

    @FunctionalInterface
    public static interface HeartbeatCheckoutFailureCallback
    extends TriConsumer<String, Integer, LmxStatus> {
    }

    @FunctionalInterface
    public static interface HeartbeatConnectionLostCallback
    extends TriConsumer<String, Integer, Integer> {
    }

    @FunctionalInterface
    public static interface HostidCompareCallback
    extends TriFunction<LmxKeyHostidType, LmxHostid[], LmxHostid[], LmxStatus> {
    }

    @FunctionalInterface
    public static interface CustomHostidCallback
    extends Function<List<LmxHostid>, LmxStatus> {
    }

    @FunctionalInterface
    private static interface TriFunction<A, B, C, T> {
        public T apply(A var1, B var2, C var3);
    }

    @FunctionalInterface
    private static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

