/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.terminals;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class LongValueConverter
extends AbstractLexerBasedConverter<Long> {
    protected String toEscapedString(Long value) {
        return value.toString();
    }

    protected void assertValidValue(Long value) {
        super.assertValidValue((Object)value);
        if (value < 0L) {
            throw new ValueConverterException(this.getRuleName() + "-value may not be negative (value: " + String.valueOf(value) + ").", null, null);
        }
    }

    public Long toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to a long value.", node, null);
        }
        try {
            long longValue = Long.parseLong(string, 10);
            return longValue;
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to a long value.", node, (Exception)e);
        }
    }
}

