/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.scoping;

import com.google.inject.ImplementedBy;
import com.yakindu.base.types.scoping.PackageImport2URIMultiMapper;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

@ImplementedBy(value=PackageImport2URIMultiMapper.class)
public interface IPackageImport2URIMapper {
    public Optional<PackageImport> findPackageImport(Resource var1, String var2);

    public Set<PackageImport> getAllImports(Resource var1);

    default public boolean canHandle(Resource context, String packageImport) {
        return true;
    }

    public static class PackageImport {
        private String namespace;
        private String name;
        private URI uri;
        private URI fileURI;

        public PackageImport(String name, URI uri, String namespace) {
            this.name = name;
            this.uri = uri;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public URI getUri() {
            return this.uri;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setFileURI(URI fileURI) {
            this.fileURI = fileURI;
        }

        public URI getFileURI() {
            if (this.fileURI != null) {
                return this.fileURI;
            }
            return this.getUri();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageImport other = (PackageImport)obj;
            return this.attributesEqual(other);
        }

        private boolean attributesEqual(PackageImport other) {
            return this.nameEquals(other) && this.namespaceEquals(other) && this.uriEquals(other);
        }

        private boolean uriEquals(PackageImport other) {
            return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
        }

        private boolean namespaceEquals(PackageImport other) {
            return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
        }

        private boolean nameEquals(PackageImport other) {
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

