/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.license;

import com.yakindu.sct.license.ILicenseService;
import com.yakindu.sct.license.LicenseStatus;
import java.util.Map;

public class LicenseChecker {
    private static final String MISSING_LICENSE_SERIVCE_MSG = "No license service available.";
    private static ILicenseService licenseService;
    private static Integer currentServiceRanking;

    static {
        currentServiceRanking = Integer.MIN_VALUE;
    }

    public LicenseStatus checkStandardLicense() {
        return this.check("com_yakindu_sct_standard");
    }

    public LicenseStatus checkProfessionalLicense() {
        return this.check("com_yakindu_sct_professional");
    }

    protected LicenseStatus check(String licensedFeatureId) {
        if (licenseService == null) {
            return new LicenseStatus(LicenseStatus.Status.ERROR, MISSING_LICENSE_SERIVCE_MSG);
        }
        return licenseService.getLicenseStatus(licensedFeatureId, "26.2");
    }

    public void bindService(ILicenseService service, Map<String, Object> properties) {
        Integer ranking = (Integer)properties.get("service.ranking");
        if (ranking == null) {
            ranking = 0;
        }
        if (ranking > currentServiceRanking) {
            currentServiceRanking = ranking;
            licenseService = service;
        }
    }

    public void unbindService(ILicenseService service) {
        if (licenseService == service) {
            licenseService = null;
            currentServiceRanking = Integer.MIN_VALUE;
        }
    }
}

