/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.coverage.persistence;

import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sctunit.coverage.io.MeasurementToJSON;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;

public class CoverageStore {
    private Measurement measurement;
    private MeasurementToJSON measurementToJSON = new MeasurementToJSON();
    private Pattern coverageFileNamePattern = Pattern.compile("(\\.?)(.*)-(\\d{4}-\\d{2}-\\d{2}-\\d{6})\\.cov");
    private String jsonString = "";
    private String filename = "";

    public void store(Measurement measurement, String filename, int numberOfTestCases, boolean hideCoverageFiles, int maxNumberOfFiles) {
        this.measurement = measurement;
        this.filename = filename;
        this.measurement.getMeasures().add(new Measurement.TestCaseCount(numberOfTestCases));
        this.jsonString = this.measurementToJSON.generate(this.measurement);
        this.deletePreviousCoverageFiles(maxNumberOfFiles, hideCoverageFiles);
        String path = this.getCurrentWorkingFolder(filename) + "/" + (hideCoverageFiles ? "." : "") + this.getCoverageFileName(measurement);
        try {
            FileWriter writer = new FileWriter(path);
            writer.write(this.jsonString);
            writer.flush();
            writer.close();
            this.refreshEditor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCoverageFileName(Measurement measurement) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        long timestamp = measurement.getTimestamp() != 0L ? measurement.getTimestamp() : System.currentTimeMillis();
        String formattedDate = dateFormat.format(new Date(timestamp));
        return measurement.getName() + "-" + formattedDate + ".cov";
    }

    public boolean isCoverageFile(Measurement measurement, String filePath) {
        Path path = new Path(filePath);
        String fileName = path.lastSegment();
        Matcher matcher = this.coverageFileNamePattern.matcher(fileName);
        return matcher.matches() && matcher.group(2).equals(measurement.getName());
    }

    public boolean isCoverageFile(String filePath) {
        Path path = new Path(filePath);
        String fileName = path.lastSegment();
        Matcher matcher = this.coverageFileNamePattern.matcher(fileName);
        return matcher.matches();
    }

    protected void refreshEditor() {
        try {
            URI uri = URI.createURI((String)this.filename).trimSegments(1);
            IFolder folder = this.getProjectFromFilePath(this.filename).getFolder(uri.lastSegment());
            if (folder.exists()) {
                folder.refreshLocal(2, null);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void deletePreviousCoverageFiles(int maxNumberOfFiles, boolean hideCoverageFiles) {
        ArrayList<Object> filteredFiles = new ArrayList();
        String currentFolderPath = this.getCurrentWorkingFolder(this.filename);
        File folder = new File(currentFolderPath);
        File[] filesInFolder = folder.listFiles();
        filteredFiles = this.filterFiles(filesInFolder, hideCoverageFiles);
        if (filteredFiles.size() > maxNumberOfFiles - 1) {
            while (filteredFiles.size() != maxNumberOfFiles - 1) {
                File oldestFile = this.searchForOldestFile(filteredFiles, hideCoverageFiles);
                if (oldestFile == null) continue;
                oldestFile.delete();
                filteredFiles.remove(oldestFile);
            }
        }
    }

    protected ArrayList<File> filterFiles(File[] filesInFolder, boolean hideCoverageFiles) {
        ArrayList<File> filteredFiles = new ArrayList<File>();
        if (filesInFolder != null) {
            File[] fileArray = filesInFolder;
            int n = filesInFolder.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (this.isCoverageFile(this.measurement, file.getName())) {
                    filteredFiles.add(file);
                }
                ++n2;
            }
        }
        return filteredFiles;
    }

    protected File searchForOldestFile(ArrayList<File> files, boolean hiddenFile) {
        File oldestFile = null;
        long earliestTime = 0L;
        for (File file : files) {
            long modifiedTime = file.lastModified();
            if (earliestTime != 0L && modifiedTime >= earliestTime) continue;
            earliestTime = modifiedTime;
            oldestFile = file;
        }
        return oldestFile;
    }

    public String getCurrentWorkingFolder(String filename) {
        IPath filepath;
        URI uri = URI.createPlatformResourceURI((String)filename, (boolean)true);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        if (file != null && file.exists() && (filepath = file.getLocation()) != null) {
            File osFile = filepath.toFile();
            return osFile.getParentFile().toString();
        }
        return null;
    }

    protected IProject getProjectFromFilePath(String filePath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    public ILaunchConfiguration getCoverageLaunchConfiguration(String fileName) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
        ILaunchConfiguration targetConfig = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
            if (launchConfig.getName().replace(".sctunit", "").equals(fileName)) {
                targetConfig = launchConfig;
            }
            ++n2;
        }
        return targetConfig;
    }

    public String getCurrentWorkingFolder2(String filePath) {
        URI uri = URI.createURI((String)filePath);
        URI workingFolder = uri.trimSegments(1);
        return workingFolder.toString() + "/";
    }

    public File searchForNewestFile(ArrayList<File> files, boolean hiddenFile) {
        File newestFile = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        Date newestDate = null;
        for (File file : files) {
            String fileName = file.getName();
            String fileDateString = this.extractFileDateString(fileName);
            try {
                Date fileDate = dateFormat.parse(fileDateString);
                if (newestDate != null && !fileDate.after(newestDate)) continue;
                newestDate = fileDate;
                newestFile = file;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return newestFile;
    }

    private String extractFileDateString(String fileName) {
        int startIndex = fileName.startsWith(".") ? fileName.indexOf(46) + 1 : 0;
        int endIndex = fileName.indexOf(46, startIndex);
        return fileName.substring(startIndex, endIndex).replaceAll("[^0-9-]", "");
    }
}

