/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.application;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.log4j.Logger;

public class CommandLineOptions {
    private static final int HELP_WIDTH = 120;
    private Options cmdOptions;
    Logger LOG = Logger.getLogger(CommandLineOptions.class);
    private CommandLine cmd;
    private static final String OPT_HELP = "h";
    private static final String OPT_HELP_LONG = "help";
    private static final String OPT_PATH_ARG_NAME = "path";
    private static final String OPT_WS = "d";
    private static final String OPT_WS_LONG = "baseDir";
    private static final String OPT_WS_DESC = "Relative or absolute path to the working directory that contains your statechart projects. If not set, the current directory is used.";
    private static final String OPT_MODEL = "m";
    private static final String OPT_MODEL_LONG = "model";
    private static final String OPT_MODEL_DESC = "A list of comma-separated relative or absolute paths to model(s) used during execution. If not set, the runtime value of baseDir is used.";
    private static final String OPT_VARIABLE = "v";
    private static final String OPT_VARIABLE_LONG = "variables";
    private static final String OPT_VARIABLE_DESC = "A list of comma-separated key/value pairs to override variables in SGen models. Example: -v key1=value1,key2=value2";

    public CommandLineOptions() {
        this.createOptions();
    }

    public void parse(String[] args) {
        this.cmd = this.parseCmdLine(args, this.cmdOptions);
    }

    protected void createOptions() {
        this.cmdOptions = new Options();
        OptionBuilder.withArgName((String)OPT_HELP_LONG);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Shows help content.");
        OptionBuilder.withLongOpt((String)OPT_HELP_LONG);
        this.cmdOptions.addOption(OptionBuilder.create((String)OPT_HELP));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPT_PATH_ARG_NAME);
        OptionBuilder.withDescription((String)OPT_WS_DESC);
        OptionBuilder.withLongOpt((String)OPT_WS_LONG);
        this.cmdOptions.addOption(OptionBuilder.create((String)OPT_WS));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"path(s)");
        OptionBuilder.withDescription((String)OPT_MODEL_DESC);
        OptionBuilder.withLongOpt((String)OPT_MODEL_LONG);
        this.cmdOptions.addOption(OptionBuilder.create((String)OPT_MODEL));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)OPT_VARIABLE_LONG);
        OptionBuilder.withDescription((String)OPT_VARIABLE_DESC);
        this.cmdOptions.addOption(OptionBuilder.create((String)OPT_VARIABLE));
    }

    public String getBaseDir() {
        return this.cmd.hasOption(OPT_WS) ? this.cmd.getOptionValue(OPT_WS) : System.getProperty("user.dir");
    }

    public Map<String, String> getVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        if (this.cmd.hasOption(OPT_VARIABLE)) {
            String[] optionValues;
            String[] stringArray = optionValues = this.cmd.getOptionValues(OPT_VARIABLE);
            int n = optionValues.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String[] split = string.split("=");
                if (split.length == 2) {
                    variables.put(split[0], split[1]);
                }
                ++n2;
            }
        }
        return variables;
    }

    public String[] getModelPaths() {
        if (this.cmd.hasOption(OPT_MODEL)) {
            return this.cmd.getOptionValues(OPT_MODEL);
        }
        return new String[]{"." + File.separator};
    }

    protected void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(new PrintWriter(System.out), 120, "SCT Headless", this.cmdOptions);
        formatter.printHelp(120, "scc", "", this.cmdOptions, "", true);
    }

    public CommandLine parseCmdLine(String[] args, Options options) {
        CommandLine cmd = null;
        try {
            BasicParser parser = new BasicParser(){

                protected void processOption(String arg, ListIterator iter) throws ParseException {
                    boolean hasOption = this.getOptions().hasOption(arg);
                    if (hasOption) {
                        super.processOption(arg, iter);
                    }
                }
            };
            cmd = parser.parse(options, args, false);
        }
        catch (UnrecognizedOptionException e) {
            this.handleUnsupportedOption(options, e);
        }
        catch (ParseException e) {
            this.handleParseException(args, options);
        }
        return cmd;
    }

    protected void handleUnsupportedOption(Options options, UnrecognizedOptionException e) {
        this.LOG.error((Object)("Unsupported option : " + e.getOption()));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)e);
        }
        this.printHelp();
    }

    protected void handleParseException(String[] args, Options options) {
        this.LOG.error((Object)String.format("Command line arguments %s cant be parsed.", Arrays.toString(args)));
        this.printHelp();
    }

    public boolean containsHelp() {
        return this.cmd.hasOption(OPT_HELP) || this.cmd.hasOption(OPT_HELP_LONG);
    }

    public boolean isValid() {
        return this.cmd != null;
    }
}

