/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.c.files;

import com.google.inject.Inject;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.sct.generator.c.IncludeProvider;
import com.yakindu.sct.generator.c.extensions.FileNaming;
import com.yakindu.sct.generator.c.extensions.GenmodelEntries;
import com.yakindu.sct.generator.c.extensions.Naming;
import com.yakindu.sct.generator.core.artifacts.IContentTemplate;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TypedRxCHeader
implements IContentTemplate<ExecutionFlow> {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    protected FileNaming _fileNaming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    private TypesUtil tu = new TypesUtil();
    private TypeSpecifier ts;
    private Set<IncludeProvider> includeProviders;

    public TypedRxCHeader(TypeSpecifier ts, Naming naming, FileNaming fileNaming, GenmodelEntries genmodelEntries, Set<IncludeProvider> includeProviders) {
        this._naming = naming;
        this._fileNaming = fileNaming;
        this._genmodelEntries = genmodelEntries;
        this.ts = ts;
        this.includeProviders = includeProviders;
    }

    public String content(ExecutionFlow it, GeneratorEntry entry, @Extension IGenArtifactConfigurations locations) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#ifndef ");
        String _define = this._fileNaming.define(this._fileNaming.getTypedRxcModule(this.ts));
        _builder.append(_define);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        String _define_1 = this._fileNaming.define(this._fileNaming.getTypedRxcModule(this.ts));
        _builder.append(_define_1);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _relativeTo = locations.relativeTo(this._fileNaming.h(this._fileNaming.rxcModule()), this._fileNaming.h(this._fileNaming.getTypedRxcModule(this.ts)));
        _builder.append(_relativeTo);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        CharSequence _typeAliasInclude = this.getTypeAliasInclude(it, locations);
        _builder.append((Object)_typeAliasInclude);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#ifdef __cplusplus");
        _builder.newLine();
        _builder.append("extern \"C\" {");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        CharSequence _pointerTypedef = this.pointerTypedef();
        _builder.append((Object)_pointerTypedef);
        _builder.newLineIfNotEmpty();
        _builder.append("declare_sc_reactive_extensions(");
        String _typeName = this._naming.getTypeName(this.ts);
        _builder.append(_typeName);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#ifdef __cplusplus");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /* ");
        String _define_2 = this._fileNaming.define(this._fileNaming.getTypedRxcModule(this.ts));
        _builder.append(_define_2);
        _builder.append("_H_ */");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public CharSequence pointerTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isPointer = this.isPointer(this.ts.getType());
        if (_isPointer) {
            _builder.append("typedef ");
            String _pointerType = this._naming.getPointerType(this.ts);
            _builder.append(_pointerType);
            _builder.append(" ");
            String _typeName = this._naming.getTypeName(this.ts);
            _builder.append(_typeName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getTypeAliasInclude(ExecutionFlow flow, IGenArtifactConfigurations locations) {
        Type payloadType = this.getBaseType(this.ts);
        if (payloadType instanceof PrimitiveType) {
            StringConcatenation _builder = new StringConcatenation();
            return _builder.toString();
        }
        Package package_ = (Package)EcoreUtil2.getContainerOfType((EObject)payloadType, Package.class);
        String _xifexpression = null;
        String _name = package_.getName();
        boolean _tripleNotEquals = _name != null;
        _xifexpression = _tripleNotEquals ? this._fileNaming.h((String)this.tu.lastOrNull((Iterable)Conversions.doWrapArray((Object)package_.getName().split("\\.")))) : payloadType.getName();
        String header = _xifexpression;
        for (IncludeProvider i : this.includeProviders) {
            Functions.Function1 _function;
            List<CharSequence> includes = i.getIncludes(flow, locations);
            boolean _exists = IterableExtensions.exists(includes, (Functions.Function1)(_function = include -> include.toString().contains(header)));
            if (!_exists) continue;
            Functions.Function1 _function_1 = include -> include.toString().contains(header);
            return (CharSequence)IterableExtensions.findFirst(includes, (Functions.Function1)_function_1);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("// Can not find include for ");
        String _name_1 = payloadType.getName();
        _builder_1.append(_name_1);
        return _builder_1.toString();
    }

    public Type getBaseType(TypeSpecifier it) {
        boolean _isPointer = this.isPointer(it.getType());
        if (_isPointer) {
            return this.getBaseType((TypeSpecifier)IterableExtensions.head((Iterable)it.getTypeArguments()));
        }
        return it.getType();
    }

    public boolean isPointer(Type it) {
        String _name = it.getName();
        return Objects.equals(_name, "pointer");
    }
}

