/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.c.submodules;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Parameter;
import com.yakindu.sct.generator.c.FlowCode;
import com.yakindu.sct.generator.c.codepattern.MethodCode;
import com.yakindu.sct.generator.c.extensions.Naming;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.sexec.LocalVariableDefinition;
import com.yakindu.sct.model.sexec.Method;
import com.yakindu.sct.model.sexec.Step;
import com.yakindu.sct.model.sexec.naming.INamingService;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class MethodGenerator {
    @Inject
    @Extension
    protected INamingService _iNamingService;
    @Inject
    @Extension
    protected ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    protected Naming _naming;
    @Inject
    @Extension
    protected MethodCode _methodCode;
    @Inject
    @Extension
    protected FlowCode _flowCode;

    public CharSequence declarations(Iterable<Operation> steps) {
        StringConcatenation _builder = new StringConcatenation();
        for (Operation s : steps) {
            CharSequence _declaration = this.declaration(s);
            _builder.append((Object)_declaration);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _declaration(Method it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getBody().getComment());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("/*! ");
            String _comment = it.getBody().getComment();
            _builder.append(_comment);
            _builder.append(" */");
        }
        _builder.newLineIfNotEmpty();
        CharSequence _declarationModifier = this._methodCode.declarationModifier((Operation)it);
        _builder.append((Object)_declarationModifier);
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getTypeSpecifier());
        _builder.append(_targetLanguageName);
        _builder.append(" ");
        String _methodShortName = this._methodCode.methodShortName((Operation)it);
        _builder.append(_methodShortName);
        _builder.append("(");
        String _scHandleDecl = this._naming.scHandleDecl((EObject)it);
        _builder.append(_scHandleDecl);
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter p : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(", ");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            boolean _isVarArgs = p.isVarArgs();
            if (_isVarArgs) {
                _builder.append("...");
                continue;
            }
            _builder.append("const ");
            String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(p.getTypeSpecifier());
            _builder.append(_targetLanguageName_1);
            _builder.append(" ");
            String _asIdentifier = this._iNamingService.asIdentifier(p.getName());
            _builder.append(_asIdentifier);
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _declaration(Operation it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _methodDeclarationCode = this._methodCode.methodDeclarationCode(it);
        _builder.append((Object)_methodDeclarationCode);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence implementation(Iterable<Operation> methods) {
        StringConcatenation _builder = new StringConcatenation();
        for (Operation m : methods) {
            CharSequence _definition = this.definition(m);
            _builder.append((Object)_definition);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _definition(Method it) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _implementationModifier = this._methodCode.implementationModifier((Operation)it);
        _builder.append(_implementationModifier);
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getTypeSpecifier());
        _builder.append(_targetLanguageName);
        _builder.append(" ");
        String _methodShortName = this._methodCode.methodShortName((Operation)it);
        _builder.append(_methodShortName);
        _builder.append("(");
        String _scHandleDecl = this._naming.scHandleDecl((EObject)it);
        _builder.append(_scHandleDecl);
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter p : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(", ");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            boolean _isVarArgs = p.isVarArgs();
            if (_isVarArgs) {
                _builder.append("...");
                continue;
            }
            _builder.append("const ");
            String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(p.getTypeSpecifier());
            _builder.append(_targetLanguageName_1);
            _builder.append(" ");
            String _asIdentifier = this._iNamingService.asIdentifier(p.getName());
            _builder.append(_asIdentifier);
        }
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getBody().getSteps());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            CharSequence _stepComment = this._flowCode.stepComment((Step)it.getBody());
            _builder.append((Object)_stepComment, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append(" \t\t\t");
        Functions.Function1 _function = s -> this._flowCode.code((NamedElement)s);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)it.getBody().getSteps(), LocalVariableDefinition.class), (Functions.Function1)_function));
        _builder.append(_join, " \t\t\t");
        _builder.newLineIfNotEmpty();
        boolean _requiresHandles = this._flowCode.requiresHandles((Step)it.getBody());
        boolean bl2 = _not_1 = !_requiresHandles;
        if (_not_1) {
            _builder.append("\t");
            CharSequence _unusedParam = this._flowCode.unusedParam(this._naming.scHandle());
            _builder.append((Object)_unusedParam, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        Functions.Function1 _function_1 = s -> !(s instanceof LocalVariableDefinition);
        Functions.Function1 _function_2 = s -> this._flowCode.code((NamedElement)s);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)it.getBody().getSteps(), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        _builder.append(_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _definition(Operation it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _methodDefinitionCode = this._methodCode.methodDefinitionCode(it);
        _builder.append((Object)_methodDefinitionCode);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @XbaseGenerated
    public CharSequence declaration(Operation it) {
        if (it instanceof Method) {
            return this._declaration((Method)it);
        }
        if (it != null) {
            return this._declaration(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence definition(Operation it) {
        if (it instanceof Method) {
            return this._definition((Method)it);
        }
        if (it != null) {
            return this._definition(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

