/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.c.submodules;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Property;
import com.yakindu.sct.generator.c.GeneratorPredicate;
import com.yakindu.sct.generator.c.codepattern.ScopeTypeDeclarationCode;
import com.yakindu.sct.generator.c.extensions.EventNaming;
import com.yakindu.sct.generator.c.extensions.GenmodelEntries;
import com.yakindu.sct.generator.c.extensions.Naming;
import com.yakindu.sct.generator.c.types.CTypes;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.ExecutionState;
import com.yakindu.sct.model.sexec.TimeEvent;
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class StatechartTypes {
    @Inject
    @Extension
    protected ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    protected Naming _naming;
    @Inject
    @Extension
    protected SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    protected StatechartAnnotations _statechartAnnotations;
    @Inject
    @Extension
    private ShadowEventExtensions _shadowEventExtensions;
    @Inject
    @Extension
    protected EventNaming _eventNaming;
    @Inject
    @Extension
    protected GeneratorEntry entry;
    @Inject
    @Extension
    private GeneratorPredicate _generatorPredicate;
    @Inject
    @Extension
    protected GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    protected ShadowMemberScope _shadowMemberScope;
    @Inject
    @Extension
    protected CTypes _cTypes;
    @Inject
    @Extension
    protected ScopeTypeDeclarationCode _scopeTypeDeclarationCode;

    public CharSequence forwardDeclarations(ExecutionFlow it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*!");
        _builder.newLine();
        _builder.append("* Forward declaration for the ");
        String _type = this._naming.type((Notifier)it);
        _builder.append(_type);
        _builder.append(" state machine.");
        _builder.newLineIfNotEmpty();
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef struct ");
        String _type_1 = this._naming.type((Notifier)it);
        _builder.append(_type_1);
        _builder.append(" ");
        String _type_2 = this._naming.type((Notifier)it);
        _builder.append(_type_2);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function = s -> {
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.typeRelevantDeclarations((Scope)s));
            return !_isNullOrEmpty;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)it.getScopes(), (Functions.Function1)_function);
        for (Scope scope : _filter) {
            _builder.newLine();
            _builder.append("/*!");
            _builder.newLine();
            _builder.append("* Forward declaration of the data structure for the ");
            String _type_3 = this._naming.type((Notifier)scope);
            _builder.append(_type_3);
            _builder.append(" interface scope.");
            _builder.newLineIfNotEmpty();
            _builder.append("*/");
            _builder.newLine();
            _builder.append("typedef struct ");
            String _type_4 = this._naming.type((Notifier)scope);
            _builder.append(_type_4);
            _builder.append(" ");
            String _type_5 = this._naming.type((Notifier)scope);
            _builder.append(_type_5);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence statemachineStruct(ExecutionFlow it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Type declaration of the data structure for the ");
        String _type = this._naming.type((Notifier)it);
        _builder.append(_type, " ");
        _builder.append(" state machine.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* This data structure has to be allocated by the client code. ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct ");
        String _type_1 = this._naming.type((Notifier)it);
        _builder.append(_type_1);
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _statemachineStructContent = this.statemachineStructContent(it);
        _builder.append((Object)_statemachineStructContent, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    public CharSequence statemachineStructContent(ExecutionFlow it) {
        StringConcatenation _builder = new StringConcatenation();
        String _statesEnumType = this._naming.statesEnumType(it);
        _builder.append(_statesEnumType);
        _builder.append(" ");
        _builder.append("stateConfVector");
        _builder.append("[");
        CharSequence _maxOrthogonalStates = this._naming.maxOrthogonalStates(it);
        _builder.append((Object)_maxOrthogonalStates);
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        boolean _hasHistory = this._sExecExtensions.hasHistory(it);
        if (_hasHistory) {
            String _statesEnumType_1 = this._naming.statesEnumType(it);
            _builder.append(_statesEnumType_1);
            _builder.append(" ");
            _builder.append("historyVector");
            _builder.append("[");
            CharSequence _maxHistoryStates = this._naming.maxHistoryStates(it);
            _builder.append((Object)_maxHistoryStates);
            _builder.append("];");
        }
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function = it_1 -> {
            boolean _isEmpty = IterableExtensions.isEmpty(this.typeRelevantDeclarations((Scope)it_1));
            return !_isEmpty;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)it.getScopes(), (Functions.Function1)_function);
        for (Scope iScope : _filter) {
            String _type = this._naming.type((Notifier)iScope);
            _builder.append(_type);
            _builder.append(" ");
            String _instance = this._naming.instance(iScope);
            _builder.append(_instance);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        boolean _tracingGeneric = this._genmodelEntries.getTracingGeneric(this.entry);
        if (_tracingGeneric) {
            _builder.append("sc_trace_handler");
            _builder.append(" *");
            _builder.append("trace_handler");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        Iterable _properties = this._sExecExtensions.getProperties(it);
        for (Property p : _properties) {
            CharSequence _structMember = this.structMember((Declaration)p);
            _builder.append((Object)_structMember);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence statesEnumDecl(ExecutionFlow it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! Enumeration of all states */ ");
        _builder.newLine();
        _builder.append("typedef enum");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _null_state = this._naming.null_state((NamedElement)it);
        _builder.append(_null_state, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        EList _states = it.getStates();
        boolean _hasElements = false;
        for (ExecutionState state : _states) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            String _stateName = this._naming.stateName(state);
            _builder.append(_stateName, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("} ");
        String _statesEnumType = this._naming.statesEnumType(it);
        _builder.append(_statesEnumType);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence featuresEnumDecl(ExecutionFlow it) {
        StringConcatenation _xifexpression = null;
        boolean _tracingGeneric = this._genmodelEntries.getTracingGeneric(this.entry);
        if (_tracingGeneric) {
            StringConcatenation _xblockexpression = null;
            Functions.Function1 _function = f -> {
                StringConcatenation _builder = new StringConcatenation();
                String _featureEnumMemberName = this._naming.featureEnumMemberName((NamedElement)f);
                _builder.append(_featureEnumMemberName);
                return _builder.toString();
            };
            List featureEnumeratorNames = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)this._sExecExtensions.getAllEventAndVariables(it), (Functions.Function1)_function));
            StringConcatenation _builder = new StringConcatenation();
            String _enumMemberNamePrefix = this._naming.enumMemberNamePrefix((EObject)it);
            _builder.append(_enumMemberNamePrefix);
            _builder.append("_no_feature = ");
            _builder.append("SC_NO_FEATURE");
            featureEnumeratorNames.add(0, _builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("/*! Enumeration of all features of the statechart */ ");
            _builder_1.newLine();
            _builder_1.append("typedef enum");
            _builder_1.newLine();
            _builder_1.append("{");
            _builder_1.newLine();
            boolean _hasElements = false;
            for (String feature : featureEnumeratorNames) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_1.appendImmediate((Object)",", "\t");
                }
                _builder_1.append("\t");
                _builder_1.append(feature, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("} ");
            String _featuresEnumType = this._naming.featuresEnumType(it);
            _builder_1.append(_featuresEnumType);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _xifexpression = _xblockexpression = _builder_1;
        } else {
            StringConcatenation _builder;
            _xifexpression = _builder = new StringConcatenation();
        }
        return _xifexpression;
    }

    public CharSequence scopeTypeDecl(Scope scope) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        List typeRelevantDeclarations = IterableExtensions.toList(this.typeRelevantDeclarations(scope));
        _builder.newLineIfNotEmpty();
        Iterable shadowEvents = this._shadowEventExtensions.getShadowEvents(this._sExecExtensions.flow((EObject)scope));
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = typeRelevantDeclarations.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("/*! Type declaration of the data structure for the ");
            String _type = this._naming.type((Notifier)scope);
            _builder.append(_type);
            _builder.append(" interface scope. */");
            _builder.newLineIfNotEmpty();
            _builder.append("struct ");
            String _type_1 = this._naming.type((Notifier)scope);
            _builder.append(_type_1);
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            for (Declaration d : typeRelevantDeclarations) {
                _builder.append("\t");
                CharSequence _scopeTypeDeclMember = this._scopeTypeDeclarationCode.scopeTypeDeclMember(d);
                _builder.append((Object)_scopeTypeDeclMember, "\t");
                _builder.newLineIfNotEmpty();
            }
            if (scope instanceof InternalScope && this._shadowMemberScope.isShadowMemberScope(scope)) {
                for (Event d_1 : shadowEvents) {
                    _builder.append("\t");
                    CharSequence _scopeShadowEventMember = this._naming.scopeShadowEventMember(d_1);
                    _builder.append((Object)_scopeShadowEventMember, "\t");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("};");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence scopeConstDecl(Scope scope) {
        StringConcatenation _builder = new StringConcatenation();
        if (!(scope instanceof InternalScope) && !IterableExtensions.isEmpty(this.constDeclarations(scope))) {
            _builder.append("/* Declaration of constants for scope ");
            String _type = this._naming.type((Notifier)scope);
            _builder.append(_type);
            _builder.append(". */");
            _builder.newLineIfNotEmpty();
            Iterable<VariableDefinition> _constDeclarations = this.constDeclarations(scope);
            boolean _hasElements = false;
            for (VariableDefinition d : _constDeclarations) {
                String _name;
                boolean _notEquals;
                if (!_hasElements) {
                    _hasElements = true;
                }
                boolean bl = _notEquals = !Objects.equals(_name = d.getType().getName(), "void");
                if (_notEquals) {
                    _builder.append("extern const ");
                    String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(d.getTypeSpecifier());
                    _builder.append(_targetLanguageName);
                    _builder.append(" ");
                    String _constantName = this._naming.constantName(d);
                    _builder.append(_constantName);
                    _builder.append(";");
                }
                _builder.newLineIfNotEmpty();
            }
            if (_hasElements) {
                String _newLine = Strings.newLine();
                _builder.append(_newLine);
            }
        }
        return _builder;
    }

    public Iterable<Declaration> typeRelevantDeclarations(Scope scope) {
        Functions.Function1 _function = it -> {
            boolean _switchResult = false;
            boolean _matched = false;
            if (it instanceof Event) {
                _matched = true;
                _switchResult = true;
            }
            if (!_matched && it instanceof VariableDefinition) {
                _matched = true;
                boolean _isConst = ((VariableDefinition)it).isConst();
                boolean bl = _switchResult = !_isConst;
            }
            if (!_matched) {
                _switchResult = false;
            }
            return _switchResult;
        };
        return IterableExtensions.filter((Iterable)scope.getDeclarations(), (Functions.Function1)_function);
    }

    public Iterable<VariableDefinition> constDeclarations(Scope scope) {
        Functions.Function1 _function = it -> it.isConst();
        return IterableExtensions.filter((Iterable)Iterables.filter((Iterable)scope.getDeclarations(), VariableDefinition.class), (Functions.Function1)_function);
    }

    public CharSequence typeDeclaration(ComplexType type, ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _cType = this._naming.cType((EObject)type);
        _builder.append(_cType);
        _builder.append(" ");
        String _cType_1 = this._naming.cType((EObject)type);
        _builder.append(_cType_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence structDeclaration(ComplexType type, ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        String _cType = this._naming.cType((EObject)type);
        _builder.append(_cType);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList _features = type.getFeatures();
        for (Declaration f : _features) {
            _builder.append("\t");
            CharSequence _structMember = this.structMember(f);
            _builder.append((Object)_structMember, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _structMember(Event it) {
        StringConcatenation _builder = new StringConcatenation();
        if (this._generatorPredicate.useOutEventObservables() && Objects.equals(it.getDirection(), Direction.OUT)) {
            String _name = this._cTypes.sc_observable().name();
            _builder.append(_name);
            String _eventType = this._eventNaming.eventType(it);
            _builder.append(_eventType);
            _builder.append(" ");
            String _eventName = this._naming.eventName(it);
            _builder.append(_eventName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (this._generatorPredicate.useOutEventGetters() && Objects.equals(it.getDirection(), Direction.OUT) || Objects.equals(it.getDirection(), Direction.IN) || Objects.equals(it.getDirection(), Direction.LOCAL)) {
            String _fqName = this._cTypes.sc_bool().fqName();
            _builder.append(_fqName);
            _builder.append(" ");
            String _eventRaisedFlag = this._naming.eventRaisedFlag(it);
            _builder.append(_eventRaisedFlag);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            if (it.getType() != null && !Objects.equals(it.getType().getName(), "void")) {
                String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getTypeSpecifier());
                _builder.append(_targetLanguageName);
                _builder.append(" ");
                String _eventValueVariable = this._naming.eventValueVariable(it);
                _builder.append(_eventValueVariable);
                _builder.append(";");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _structMember(TimeEvent it) {
        StringConcatenation _builder = new StringConcatenation();
        String _fqName = this._cTypes.sc_bool().fqName();
        _builder.append(_fqName);
        _builder.append(" ");
        String _timeEventRaisedFlag = this._naming.timeEventRaisedFlag(it);
        _builder.append(_timeEventRaisedFlag);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _structMember(Property it) {
        StringConcatenation _builder = new StringConcatenation();
        String _cType = this._naming.cType((EObject)it.getType());
        _builder.append(_cType);
        _builder.append(" ");
        String _variable = this._naming.variable(it);
        _builder.append(_variable);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _structMember(Declaration it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    @XbaseGenerated
    public CharSequence structMember(Declaration it) {
        if (it instanceof TimeEvent) {
            return this._structMember((TimeEvent)it);
        }
        if (it instanceof Event) {
            return this._structMember((Event)it);
        }
        if (it instanceof Property) {
            return this._structMember((Property)it);
        }
        if (it != null) {
            return this._structMember(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

