/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.c.types;

import com.google.inject.Inject;
import com.itemis.create.base.generator.core.types.Literals;
import com.itemis.create.base.model.bindings.ReactiveModel;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeAlias;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.annotations.TypeAnnotations;
import com.yakindu.base.types.typesystem.ITypeSemantics;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.generator.c.GeneratorPredicate;
import com.yakindu.sct.generator.c.extensions.Naming;
import com.yakindu.sct.generator.c.types.CTypeAnnotations;
import com.yakindu.sct.generator.c.types.CTypes;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.sexec.concepts.EventBuffer;
import com.yakindu.sct.model.sexec.concepts.PropertyBinder;
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions;
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CTypeSystemAccess
implements ICodegenTypeSystemAccess {
    @Inject
    @Extension
    protected ITypeSemantics _iTypeSemantics;
    @Inject
    @Extension
    protected ITypeSystem _iTypeSystem;
    @Inject
    @Extension
    protected StatechartUtil _statechartUtil;
    @Inject
    @Extension
    protected GeneratorPredicate _generatorPredicate;
    @Inject
    @Extension
    protected ShadowEventExtensions _shadowEventExtensions;
    @Inject
    @Extension
    protected Naming _naming;
    @Inject
    @Extension
    protected CTypeAnnotations _cTypeAnnotations;
    @Inject
    @Extension
    protected TypeAnnotations _typeAnnotations;
    @Inject
    @Extension
    protected Literals _literals;
    @Inject
    @Extension
    protected CTypes _cTypes;
    @Inject
    @Extension
    protected EventBuffer _eventBuffer;
    @Inject
    @Extension
    protected ReactiveModel _reactiveModel;
    @Inject
    @Extension
    protected PropertyBinder _propertyBinder;
    @Inject
    @Extension
    protected StatemachineTypes _statemachineTypes;
    protected static final String ARRAY = "array";
    protected static final String POINTER = "pointer";
    protected static final String SHARED_POINTER = "shared_ptr";
    protected static final String WEAK_POINTER = "weak_ptr";
    public static final String UNIQUE_POINTER = "unique_ptr";
    public static final List<String> POINTER_TYPES = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"pointer", "shared_ptr", "weak_ptr", "unique_ptr"}));

    public String getTargetLanguageName(Type type) {
        return this.targetLanguageName(type);
    }

    public String getTargetLanguageName(TypeSpecifier typeSpecifier) {
        Type _type = null;
        if (typeSpecifier != null) {
            _type = typeSpecifier.getType();
        }
        return this.targetLanguageName(_type, typeSpecifier);
    }

    protected String _targetLanguageName(Type it) {
        return this._literals.asLiteral((Object)it);
    }

    protected String _targetLanguageName(Void it) {
        return this._cTypes.sc_void().name;
    }

    protected String _targetLanguageName(TypeAlias it) {
        EObject _eContainer = it.eContainer();
        if (_eContainer instanceof Scope) {
            return this.targetLanguageName(it.getOriginType());
        }
        return this._literals.asLiteral((Object)it);
    }

    protected String _targetLanguageName(PrimitiveType it) {
        boolean _isString;
        boolean _isStringLiteral;
        boolean _isBoolean;
        boolean _isReal;
        boolean _isInteger;
        boolean _isVoid;
        String _switchResult = null;
        boolean _matched = false;
        boolean _isSame = this._iTypeSystem.isSame((Type)it, this._iTypeSystem.getType("bool"));
        if (_isSame) {
            _matched = true;
            _switchResult = this._cTypes.sc_bool().name;
        }
        if (!_matched && (_isVoid = this._iTypeSystem.isVoid((Type)it))) {
            _matched = true;
            _switchResult = this._cTypes.sc_void().name;
        }
        if (!_matched && (_isInteger = this._iTypeSystem.isInteger((Type)it))) {
            _matched = true;
            _switchResult = this._cTypes.sc_integer().name;
        }
        if (!_matched && (_isReal = this._iTypeSystem.isReal((Type)it))) {
            _matched = true;
            _switchResult = this._cTypes.sc_real().name;
        }
        if (!_matched && (_isBoolean = this._iTypeSystem.isBoolean((Type)it))) {
            _matched = true;
            _switchResult = this._cTypes.sc_bool().name;
        }
        if (!_matched && (_isStringLiteral = this._iTypeSystem.isStringLiteral((Type)it))) {
            _matched = true;
            _switchResult = this._cTypes.sc_string().name;
        }
        if (!_matched && (_isString = this._iTypeSystem.isString((Type)it))) {
            _matched = true;
            _switchResult = this._cTypes.sc_string().name;
        }
        if (!_matched) {
            _switchResult = this._literals.asLiteral((Object)it);
        }
        return _switchResult;
    }

    protected String _targetLanguageName(EnumerationType it) {
        boolean _isCEnum;
        Object _switchResult = null;
        boolean _matched = false;
        boolean _isOriginStatechart = this._statechartUtil.isOriginStatechart((EObject)it);
        if (_isOriginStatechart) {
            _matched = true;
            _switchResult = this.printStateEnumType(it);
        }
        if (!_matched && (_isCEnum = this._cTypeAnnotations.isCEnum((Type)it))) {
            _matched = true;
            String _asLiteral = this._literals.asLiteral((Object)it);
            _switchResult = "enum " + _asLiteral;
        }
        if (!_matched) {
            _switchResult = this._literals.asLiteral((Object)it);
        }
        return _switchResult;
    }

    protected String _targetLanguageName(ComplexType it) {
        boolean _isReferenceType;
        boolean _isNullOrEmpty;
        boolean _isCUnion;
        boolean _isCStruct;
        Object _switchResult = null;
        boolean _matched = false;
        boolean _isOriginStatechart = this._statechartUtil.isOriginStatechart((EObject)it);
        if (_isOriginStatechart) {
            _matched = true;
            _switchResult = this.printStatechartType(it);
        }
        if (!_matched && (_isCStruct = this._cTypeAnnotations.isCStruct((Type)it))) {
            _matched = true;
            String _asLiteral = this._literals.asLiteral((Object)it);
            _switchResult = "struct " + _asLiteral;
        }
        if (!_matched && (_isCUnion = this._cTypeAnnotations.isCUnion((Type)it))) {
            _matched = true;
            String _asLiteral_1 = this._literals.asLiteral((Object)it);
            _switchResult = "union " + _asLiteral_1;
        }
        if (!_matched && (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getName()))) {
            _matched = true;
            _switchResult = null;
        }
        if (!_matched && (_isReferenceType = this.isReferenceType(it))) {
            _matched = true;
            _switchResult = this.printReferenceType(it);
        }
        if (!_matched) {
            _switchResult = this._literals.asLiteral((Object)it);
        }
        return _switchResult;
    }

    public boolean isReferenceType(ComplexType it) {
        if (this._reactiveModel.isObservableType((Type)it) || this._reactiveModel.isObserverType((Type)it) || this._reactiveModel.isSimpleObserverType((Type)it) || this._propertyBinder.isBinderType((Type)it)) {
            return false;
        }
        return !this._iTypeSemantics.isValueType((Type)it) && !this._eventBuffer.isEventBuffer((Type)it);
    }

    protected boolean _isPointerType(TypeSpecifier it) {
        Functions.Function1 _function = t -> {
            String _name = it.getType().getName();
            return Objects.equals(_name, t);
        };
        return IterableExtensions.exists(POINTER_TYPES, (Functions.Function1)_function);
    }

    protected boolean _isPointerType(Type it) {
        Functions.Function1 _function = t -> {
            String _name = it.getName();
            return Objects.equals(_name, t);
        };
        return IterableExtensions.exists(POINTER_TYPES, (Functions.Function1)_function);
    }

    protected boolean _isPointerType(EObject it) {
        return false;
    }

    protected String _targetLanguageName(Void it, TypeSpecifier tspec) {
        return this._cTypes.sc_void().name;
    }

    protected String _targetLanguageName(Type it, TypeSpecifier tspec) {
        boolean _isInternalStatemachineType;
        Object _switchResult = null;
        boolean _matched = false;
        boolean _isBuiltInType = this._iTypeSemantics.isBuiltInType(it);
        if (_isBuiltInType) {
            _matched = true;
            _switchResult = this.printBuiltInType(tspec);
        }
        if (!_matched && (_isInternalStatemachineType = this._statemachineTypes.isInternalStatemachineType((EObject)it))) {
            _matched = true;
            CharSequence _structName = this._naming.structName(it);
            _switchResult = String.valueOf(_structName) + "_t*";
        }
        if (!_matched) {
            _switchResult = this.targetLanguageSpecifier(tspec, this.targetLanguageName(it));
        }
        return _switchResult;
    }

    protected String _targetLanguageName(TypeAlias it, TypeSpecifier tspec) {
        EObject _eContainer = it.eContainer();
        if (_eContainer instanceof Scope) {
            return this.targetLanguageName(it.getOriginType(), tspec);
        }
        return this.targetLanguageSpecifier(tspec, this.targetLanguageName((Type)it));
    }

    protected String targetLanguageSpecifier(TypeSpecifier tspec) {
        Type _type = null;
        if (tspec != null) {
            _type = tspec.getType();
        }
        return this.targetLanguageSpecifier(tspec, this.targetLanguageName(_type));
    }

    protected String targetLanguageSpecifier(TypeSpecifier tspec, String typeLiteral) {
        return typeLiteral;
    }

    protected String printBuiltInType(TypeSpecifier typeSpecifier) {
        boolean _isPointerType = this.isPointerType((EObject)typeSpecifier);
        if (_isPointerType) {
            StringConcatenation _builder = new StringConcatenation();
            String _targetLanguageName = this.getTargetLanguageName((TypeSpecifier)IterableExtensions.head((Iterable)typeSpecifier.getTypeArguments()));
            _builder.append(_targetLanguageName);
            String _pointerSymbol = this.pointerSymbol(typeSpecifier);
            _builder.append(_pointerSymbol);
            return _builder.toString();
        }
        String _name = typeSpecifier.getType().getName();
        boolean _equals = Objects.equals(_name, ARRAY);
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _asLiteral = this._literals.asLiteral((Object)((TypeSpecifier)IterableExtensions.head((Iterable)typeSpecifier.getTypeArguments())).getType());
            _builder_1.append(_asLiteral);
            return _builder_1.toString();
        }
        return null;
    }

    protected String printStateEnumType(EnumerationType type) {
        return type.getName();
    }

    protected String printStatechartType(ComplexType type) {
        String _type = this._naming.type((Notifier)this._statechartUtil.getOriginStatechart((EObject)type));
        return _type + "*";
    }

    protected String printReferenceType(ComplexType type) {
        String _asLiteral = this._literals.asLiteral((Object)type);
        return _asLiteral + "*";
    }

    protected String printType(TypeSpecifier typeSpecifier) {
        Type _type = null;
        if (typeSpecifier != null) {
            _type = typeSpecifier.getType();
        }
        return this.getTargetLanguageName(_type);
    }

    public String pointerSymbol(TypeSpecifier it) {
        Event event;
        boolean _useOutEventObservables = this._generatorPredicate.useOutEventObservables();
        if (_useOutEventObservables && (event = (Event)EcoreUtil2.getContainerOfType((EObject)it, Event.class)) != null && (event.getDirection() == Direction.OUT || this._shadowEventExtensions.getOutEvent(event) != null)) {
            return "_pointer";
        }
        return "*";
    }

    @XbaseGenerated
    protected String targetLanguageName(Type it) {
        if (it instanceof EnumerationType) {
            return this._targetLanguageName((EnumerationType)it);
        }
        if (it instanceof ComplexType) {
            return this._targetLanguageName((ComplexType)it);
        }
        if (it instanceof PrimitiveType) {
            return this._targetLanguageName((PrimitiveType)it);
        }
        if (it instanceof TypeAlias) {
            return this._targetLanguageName((TypeAlias)it);
        }
        if (it != null) {
            return this._targetLanguageName(it);
        }
        return this._targetLanguageName((Void)null);
    }

    @XbaseGenerated
    public boolean isPointerType(EObject it) {
        if (it instanceof Type) {
            return this._isPointerType((Type)it);
        }
        if (it instanceof TypeSpecifier) {
            return this._isPointerType((TypeSpecifier)it);
        }
        if (it != null) {
            return this._isPointerType(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected String targetLanguageName(Type it, TypeSpecifier tspec) {
        if (it instanceof TypeAlias) {
            return this._targetLanguageName((TypeAlias)it, tspec);
        }
        if (it != null) {
            return this._targetLanguageName(it, tspec);
        }
        if (it == null) {
            return this._targetLanguageName((Void)null, tspec);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, tspec).toString());
    }
}

