/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.c.typesystem;

import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.ArrayTypeSpecifier;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.typesystem.GenericTypeSystem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class CTypeSystem
extends GenericTypeSystem {
    private static final CTypeSystem INSTANCE = new CTypeSystem();
    public static final String DOUBLE = "double";
    public static final String UINT8_T = "uint8_t";
    public static final String INT8_T = "int8_t";
    public static final String INT16_T = "int16_t";
    public static final String UINT16_T = "uint16_t";
    public static final String INT32_T = "int32_t";
    public static final String INT64_T = "int64_t";
    public static final String UINT32_T = "uint32_t";
    public static final String UINT64_T = "uint64_t";
    public static final String FLOAT = "float";
    public static final String BOOL = "bool";
    public static final String UNSUPPORTED_TYPE = "UnsupportedType";
    public static final String POINTER = "pointer";
    public static final String SHARED_POINTER = "shared_ptr";
    public static final String WEAK_POINTER = "weak_ptr";
    public static final String UNIQUE_POINTER = "unique_ptr";
    public static final List<String> SMART_POINTER_TYPES = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"shared_ptr", "weak_ptr", "unique_ptr"}));
    public static final List<String> POINTER_PROPERTY = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"pointer", "shared_ptr", "weak_ptr", "unique_ptr"}));
    public static final List<String> POINTER_TYPES = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"pointer", "shared_ptr", "weak_ptr", "unique_ptr"}));
    public static final String POINTER_VALUE_PROPERTY = "value";

    protected CTypeSystem() {
    }

    public static CTypeSystem getInstance() {
        return INSTANCE;
    }

    public void initRegistries() {
        super.initRegistries();
        Type _type = this.getType("boolean");
        _type.setAbstract(true);
        Type _type_1 = this.getType("integer");
        _type_1.setAbstract(true);
        this.declareRangedInteger(INT8_T, -128L, 127L);
        this.declareRangedInteger(INT16_T, -32768L, 32767L);
        this.declareRangedInteger(INT32_T, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.declareRangedInteger(INT64_T, 0L, 0L);
        this.declareRangedInteger(UINT8_T, 0L, 255L);
        this.declareRangedInteger(UINT16_T, 0L, 65535L);
        this.declareRangedInteger(UINT32_T, 0L, 0xFFFFFFFFL);
        this.declareRangedInteger(UINT64_T, 0L, 0L);
        this.declareSuperType(this.getType(INT64_T), this.getType("integer"));
        this.declareSuperType(this.getType(INT32_T), this.getType(INT64_T));
        this.declareSuperType(this.getType(INT16_T), this.getType(INT32_T));
        this.declareSuperType(this.getType(INT8_T), this.getType(INT16_T));
        this.declareSuperType(this.getType(UINT64_T), this.getType("unsigned integer"));
        this.declareSuperType(this.getType(UINT32_T), this.getType(UINT64_T));
        this.declareSuperType(this.getType(UINT16_T), this.getType(UINT32_T));
        this.declareSuperType(this.getType(UINT8_T), this.getType(UINT16_T));
        this.declarePrimitive(FLOAT);
        this.declarePrimitive(DOUBLE);
        this.declarePrimitive(BOOL);
        this.declarePrimitive(UNSUPPORTED_TYPE);
        Type _type_2 = this.getType(UNSUPPORTED_TYPE);
        _type_2.setAbstract(true);
        this.declareSuperType(this.getType(DOUBLE), this.getType("real"));
        this.declareSuperType(this.getType(FLOAT), this.getType(DOUBLE));
        this.declareSuperType(this.getType(BOOL), this.getType("boolean"));
        this.declareSuperType(this.getType("integer"), this.getType(FLOAT));
        this.declareSuperType(this.getType("any"), this.getType(UINT8_T));
        this.declareSuperType(this.getType("any"), this.getType(INT8_T));
        this.declareSuperType(this.getType("any"), this.getType(BOOL));
        this.declareSuperType(this.getType("any"), this.getType("string"));
        this.declarePointerType(POINTER);
        this.declarePointerType(SHARED_POINTER);
        this.declarePointerType(WEAK_POINTER);
        this.declarePointerType(UNIQUE_POINTER);
        this.declareSuperType(this.getType("array"), this.getType(POINTER));
        this.declareSuperType(this.getType("array"), this.getType(SHARED_POINTER));
        this.declareSuperType(this.getType("array"), this.getType(WEAK_POINTER));
        this.declareSuperType(this.getType("array"), this.getType(UNIQUE_POINTER));
    }

    protected boolean declarePointerType(String pointerType) {
        boolean _xblockexpression = false;
        ComplexType pointer = this.createPointerType(pointerType);
        this.declareType((Type)pointer, pointer.getName());
        EList _contents = this.getResource().getContents();
        _contents.add((Object)pointer);
        Property _createProperty = TypesFactory.eINSTANCE.createProperty();
        Procedures.Procedure1 _function = it -> {
            it.setName(pointerType);
            ArrayTypeSpecifier _createArrayTypeSpecifier = TypesFactory.eINSTANCE.createArrayTypeSpecifier();
            Procedures.Procedure1 _function_1 = it_1 -> it_1.setType((Type)pointer);
            ArrayTypeSpecifier _doubleArrow = (ArrayTypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createArrayTypeSpecifier, (Procedures.Procedure1)_function_1);
            it.setTypeSpecifier((TypeSpecifier)_doubleArrow);
        };
        Property pointerExtension = (Property)ObjectExtensions.operator_doubleArrow((Object)_createProperty, (Procedures.Procedure1)_function);
        EList _contents_1 = this.getResource().getContents();
        _contents_1.add((Object)pointerExtension);
        _xblockexpression = this.extensionPropertyRegistry.put((Object)this.getType("any"), (Object)pointerExtension);
        return _xblockexpression;
    }

    protected ComplexType createPointerType(String pointerType) {
        ComplexType _createComplexType = TypesFactory.eINSTANCE.createComplexType();
        Procedures.Procedure1 _function = type -> {
            type.setName(pointerType);
            EList _annotations = type.getAnnotations();
            Annotation _createAnnotation = TypesFactory.eINSTANCE.createAnnotation();
            Procedures.Procedure1 _function_1 = it -> it.setType(this.typeAnnotations.createBuiltInTypeAnnotationType());
            Annotation _doubleArrow = (Annotation)ObjectExtensions.operator_doubleArrow((Object)_createAnnotation, (Procedures.Procedure1)_function_1);
            _annotations.add((Object)_doubleArrow);
            EList _typeParameters = type.getTypeParameters();
            TypeParameter _createTypeParameter = TypesFactory.eINSTANCE.createTypeParameter();
            Procedures.Procedure1 _function_2 = it -> it.setName("baseType");
            TypeParameter _doubleArrow_1 = (TypeParameter)ObjectExtensions.operator_doubleArrow((Object)_createTypeParameter, (Procedures.Procedure1)_function_2);
            _typeParameters.add((Object)_doubleArrow_1);
            EList _features = type.getFeatures();
            Property _createProperty = TypesFactory.eINSTANCE.createProperty();
            Procedures.Procedure1 _function_3 = it -> {
                it.setName(POINTER_VALUE_PROPERTY);
                TypeSpecifier _createTypeSpecifier = TypesFactory.eINSTANCE.createTypeSpecifier();
                Procedures.Procedure1 _function_4 = it_1 -> it_1.setType((Type)IterableExtensions.head((Iterable)type.getTypeParameters()));
                TypeSpecifier _doubleArrow_2 = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_4);
                it.setTypeSpecifier(_doubleArrow_2);
            };
            Property _doubleArrow_2 = (Property)ObjectExtensions.operator_doubleArrow((Object)_createProperty, (Procedures.Procedure1)_function_3);
            _features.add((Object)_doubleArrow_2);
        };
        return (ComplexType)ObjectExtensions.operator_doubleArrow((Object)_createComplexType, (Procedures.Procedure1)_function);
    }

    public List<Operation> getOperationExtensions(Type type) {
        List _xblockexpression = null;
        List result = super.getOperationExtensions(type);
        List _operationExtensions = super.getOperationExtensions(this.getType("any"));
        Iterables.addAll((Collection)result, (Iterable)_operationExtensions);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public List<Property> getPropertyExtensions(Type type) {
        List _xblockexpression = null;
        List result = super.getPropertyExtensions(type);
        List _propertyExtensions = super.getPropertyExtensions(this.getType("any"));
        Iterables.addAll((Collection)result, (Iterable)_propertyExtensions);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public Type declareRangedInteger(String name, long lowerBound, long upperBound) {
        Type type;
        Type _xblockexpression = null;
        _xblockexpression = type = this.declarePrimitive(name);
        return _xblockexpression;
    }
}

