/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.gmf.runtime.router;

import com.yakindu.base.gmf.runtime.router.ConnData;
import com.yakindu.base.gmf.runtime.router.GeometryUtil;
import com.yakindu.base.gmf.runtime.router.MaxMoveDelta;
import com.yakindu.base.gmf.runtime.router.RelativeBendpointUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class RubberBandRoutingSupport {
    protected RelativeBendpointUtil relbpUtil = new RelativeBendpointUtil();
    protected GeometryUtil geom = new GeometryUtil();
    protected Map<Connection, ConnData> conn = new HashMap<Connection, ConnData>();
    private Rectangle origDraggedBoundsAbs;
    private MaxMoveDelta[] mmds = new MaxMoveDelta[4];

    public void abortBoxDrag() {
        for (ConnData cd : this.conn.values()) {
            this.forceInitialLocations(cd);
        }
        this.clearState();
    }

    private double clamp(boolean isVertical, PrecisionPoint p, double dv, Rectangle box, double sideDistance) {
        double y;
        double top;
        if (isVertical) {
            double x;
            double left;
            double c = p.preciseX() + dv;
            if (c < (left = (x = box.preciseX()) + sideDistance)) {
                return left;
            }
            double right = x + box.preciseWidth() - sideDistance;
            if (c > right) {
                return right;
            }
            return c;
        }
        double c = p.preciseY() + dv;
        if (c < (top = (y = box.preciseY()) + sideDistance)) {
            return top;
        }
        double bot = y + box.preciseHeight() - sideDistance;
        if (c > bot) {
            return bot;
        }
        return c;
    }

    protected void clearState() {
        this.conn.clear();
    }

    public void commitBoxDrag() {
        this.clearState();
    }

    protected List<RelativeBendpoint> createConstraint(Connection conn, List<PrecisionPoint> list) {
        ArrayList<RelativeBendpoint> constraint = new ArrayList<RelativeBendpoint>();
        for (Point point : list) {
            RelativeBendpoint relbp = new RelativeBendpoint();
            relbp.setConnection(conn);
            this.relbpUtil.forceLocation(conn, relbp, point.preciseX(), point.preciseY());
            constraint.add(relbp);
        }
        return constraint;
    }

    protected void cutOffEnd(List<PrecisionPoint> points, Rectangle rect, boolean isSelfAssoc) {
        int startIndex;
        List<GeometryUtil.Line> segs = this.geom.getOutlineSegments(this.geom.toRectangle(rect));
        int n = startIndex = isSelfAssoc ? 3 : 1;
        if (startIndex >= points.size()) {
            return;
        }
        PrecisionPoint p1 = this.geom.toPP((Point)points.get(startIndex - 1));
        int i = startIndex;
        while (i < points.size()) {
            PrecisionPoint p2 = this.geom.toPP((Point)points.get(i));
            GeometryUtil.Line line = new GeometryUtil.Line(p1, p2);
            PrecisionPoint poi = this.geom.findNearestIntersection(line, segs, p1);
            if (poi != null) {
                int j = points.size() - 1;
                while (j >= i) {
                    points.remove(j);
                    --j;
                }
                if (p1.preciseX() == p2.preciseX()) {
                    poi.setPreciseX(p1.preciseX());
                } else {
                    poi.setPreciseY(p1.preciseY());
                }
                points.add(poi);
                return;
            }
            p1 = p2;
            ++i;
        }
    }

    protected void cutOffStart(List<PrecisionPoint> points, Rectangle rect, boolean isSelfAssoc) {
        int startIndex;
        List<GeometryUtil.Line> segs = this.geom.getOutlineSegments(this.geom.toRectangle(rect));
        int n = startIndex = isSelfAssoc ? points.size() - 4 : points.size() - 2;
        if (startIndex < 0 || startIndex + 1 >= points.size()) {
            return;
        }
        PrecisionPoint p2 = this.geom.toPP((Point)points.get(startIndex + 1));
        int i = startIndex;
        while (i >= 0) {
            PrecisionPoint p1 = this.geom.toPP((Point)points.get(i));
            GeometryUtil.Line line = new GeometryUtil.Line(p1, p2);
            PrecisionPoint poi = this.geom.findNearestIntersection(line, segs, p2);
            if (poi != null) {
                int j = i;
                while (j >= 0) {
                    points.remove(j);
                    --j;
                }
                if (p1.preciseX() == p2.preciseX()) {
                    poi.setPreciseX(p1.preciseX());
                } else {
                    poi.setPreciseY(p1.preciseY());
                }
                points.add(0, poi);
                return;
            }
            p2 = p1;
            --i;
        }
    }

    protected void cutOutLoops(List<PrecisionPoint> points) {
        int minLoopSize = 5;
        if (points.size() < 5) {
            return;
        }
        int i = points.size() - 1;
        while (i >= 4) {
            GeometryUtil.Line rearLine = new GeometryUtil.Line(this.geom.toPP((Point)points.get(i - 1)), this.geom.toPP((Point)points.get(i)));
            int j = 0;
            while (j <= i - 5 + 1) {
                GeometryUtil.Line frontLine = new GeometryUtil.Line(this.geom.toPP((Point)points.get(j)), this.geom.toPP((Point)points.get(j + 1)));
                PrecisionPoint poi = this.geom.getIntersection(rearLine, frontLine);
                if (poi != null) {
                    int k = i - 1;
                    while (k >= j + 1) {
                        points.remove(k);
                        --k;
                    }
                    points.add(j + 1, poi);
                    return;
                }
                ++j;
            }
            --i;
        }
    }

    private List<PrecisionPoint> dragAnchoredSegments(ConnData cd, Rectangle sourceBox, Rectangle targetBox, double localDx, double localDy, double localDw, double localDh) {
        List<PrecisionPoint> pointsCopy = cd.getInitialVisualPointsCopy();
        if (cd.isReflexive) {
            double y;
            PrecisionPoint np;
            PrecisionPoint ap;
            double x;
            double dx = localDx + localDw;
            double dy = localDy + localDh;
            if (cd.isSourceVertical) {
                x = this.clamp(true, pointsCopy.get(cd.sourceAnchorIndex), dx, targetBox, cd.SideDistance);
                ap = pointsCopy.get(cd.sourceAnchorIndex);
                ap.setPreciseX(x);
                ap.setPreciseY(ap.preciseY() + dy);
                np = pointsCopy.get(cd.sourceNeighborIndex);
                np.setPreciseX(x);
                np.setPreciseY(np.preciseY() + dy);
            } else {
                y = this.clamp(false, pointsCopy.get(cd.sourceAnchorIndex), dy, targetBox, cd.SideDistance);
                ap = pointsCopy.get(cd.sourceAnchorIndex);
                ap.setPreciseY(y);
                ap.setPreciseX(ap.preciseX() + dx);
                np = pointsCopy.get(cd.sourceNeighborIndex);
                np.setPreciseY(y);
                np.setPreciseX(np.preciseX() + dx);
            }
            if (cd.isTargetVertical) {
                x = this.clamp(true, pointsCopy.get(cd.targetAnchorIndex), dx, targetBox, cd.SideDistance);
                ap = pointsCopy.get(cd.targetAnchorIndex);
                ap.setPreciseX(x);
                ap.setPreciseY(ap.preciseY() + dy);
                np = pointsCopy.get(cd.targetNeighborIndex);
                np.setPreciseX(x);
                np.setPreciseY(np.preciseY() + dy);
            } else {
                y = this.clamp(false, pointsCopy.get(cd.targetAnchorIndex), dy, targetBox, cd.SideDistance);
                ap = pointsCopy.get(cd.targetAnchorIndex);
                ap.setPreciseY(y);
                ap.setPreciseX(ap.preciseX() + dx);
                np = pointsCopy.get(cd.targetNeighborIndex);
                np.setPreciseY(y);
                np.setPreciseX(np.preciseX() + dx);
            }
            if (pointsCopy.size() > 4) {
                for (PrecisionPoint p : pointsCopy.subList(2, pointsCopy.size() - 2)) {
                    p.setPreciseLocation(this.geom.getAdded(p, dx, dy));
                }
            }
        } else {
            double y;
            double x;
            double reqDy;
            PrecisionPoint np;
            PrecisionPoint ap;
            double reqDx;
            if (cd.isSource) {
                if (cd.isSourceVertical) {
                    reqDx = this.mmds[cd.sourceSideIndex].reqDelta(localDx, localDw);
                    if (reqDx != 0.0) {
                        ap = pointsCopy.get(cd.sourceAnchorIndex);
                        ap.setPreciseX(ap.preciseX() + reqDx);
                        np = pointsCopy.get(cd.sourceNeighborIndex);
                        np.setPreciseX(np.preciseX() + reqDx);
                    }
                } else {
                    reqDy = this.mmds[cd.sourceSideIndex].reqDelta(localDy, localDh);
                    if (reqDy != 0.0) {
                        ap = pointsCopy.get(cd.sourceAnchorIndex);
                        ap.setPreciseY(ap.preciseY() + reqDy);
                        np = pointsCopy.get(cd.sourceNeighborIndex);
                        np.setPreciseY(np.preciseY() + reqDy);
                    }
                }
                if (cd.isSourceVertical) {
                    x = this.clamp(true, pointsCopy.get(cd.sourceAnchorIndex), 0.0, sourceBox, cd.SideDistance);
                    ap = pointsCopy.get(cd.sourceAnchorIndex);
                    ap.setPreciseX(x);
                    np = pointsCopy.get(cd.sourceNeighborIndex);
                    np.setPreciseX(x);
                } else {
                    y = this.clamp(false, pointsCopy.get(cd.sourceAnchorIndex), 0.0, sourceBox, cd.SideDistance);
                    ap = pointsCopy.get(cd.sourceAnchorIndex);
                    ap.setPreciseY(y);
                    np = pointsCopy.get(cd.sourceNeighborIndex);
                    np.setPreciseY(y);
                }
            }
            if (cd.isTarget) {
                if (cd.isTargetVertical) {
                    reqDx = this.mmds[cd.targetSideIndex].reqDelta(localDx, localDw);
                    if (reqDx != 0.0) {
                        ap = pointsCopy.get(cd.targetAnchorIndex);
                        ap.setPreciseX(ap.preciseX() + reqDx);
                        np = pointsCopy.get(cd.targetNeighborIndex);
                        np.setPreciseX(np.preciseX() + reqDx);
                    }
                } else {
                    reqDy = this.mmds[cd.targetSideIndex].reqDelta(localDy, localDh);
                    if (reqDy != 0.0) {
                        ap = pointsCopy.get(cd.targetAnchorIndex);
                        ap.setPreciseY(ap.preciseY() + reqDy);
                        np = pointsCopy.get(cd.targetNeighborIndex);
                        np.setPreciseY(np.preciseY() + reqDy);
                    }
                }
                if (cd.isTargetVertical) {
                    x = this.clamp(true, pointsCopy.get(cd.targetAnchorIndex), 0.0, targetBox, cd.SideDistance);
                    ap = pointsCopy.get(cd.targetAnchorIndex);
                    ap.setPreciseX(x);
                    np = pointsCopy.get(cd.targetNeighborIndex);
                    np.setPreciseX(x);
                } else {
                    y = this.clamp(false, pointsCopy.get(cd.targetAnchorIndex), 0.0, targetBox, cd.SideDistance);
                    ap = pointsCopy.get(cd.targetAnchorIndex);
                    ap.setPreciseY(y);
                    np = pointsCopy.get(cd.targetNeighborIndex);
                    np.setPreciseY(y);
                }
            }
        }
        return pointsCopy;
    }

    protected void forceInitialLocations(ConnData cd) {
        List<RelativeBendpoint> constraint = this.createConstraint(cd.conn, cd.initialVisualPoints);
        ConnectionRouter router = cd.conn.getConnectionRouter();
        router.setConstraint(cd.conn, constraint);
        router.route(cd.conn);
    }

    private Rectangle getBounds(Connection conn, IFigure sourceOwner) {
        Rectangle sourceBox = sourceOwner.getBounds().getCopy();
        sourceOwner.translateToAbsolute((Translatable)sourceBox);
        conn.translateToRelative((Translatable)sourceBox);
        return sourceBox;
    }

    public ConnData getCD(IFigure figure) {
        return this.conn.get(figure);
    }

    public void initBoxDrag(Rectangle originalAbs, List<Connection> sourceConnections, List<Connection> targetConnections) {
        this.origDraggedBoundsAbs = originalAbs.getCopy();
        this.conn.clear();
        int i = 0;
        while (i < this.mmds.length) {
            this.mmds[i] = new MaxMoveDelta(i % 2 != 0);
            ++i;
        }
        IdentityHashMap<Connection, Boolean> isSource = new IdentityHashMap<Connection, Boolean>();
        for (Connection c : sourceConnections) {
            isSource.put(c, true);
        }
        IdentityHashMap<Connection, Boolean> isTarget = new IdentityHashMap<Connection, Boolean>();
        for (Connection c : targetConnections) {
            isTarget.put(c, true);
        }
        ArrayList<Connection> pureSource = new ArrayList<Connection>();
        ArrayList<Connection> reflexive = new ArrayList<Connection>();
        for (Connection c : sourceConnections) {
            if (!isTarget.containsKey(c)) {
                pureSource.add(c);
                continue;
            }
            reflexive.add(c);
        }
        ArrayList<Connection> pureTarget = new ArrayList<Connection>();
        for (Connection c : targetConnections) {
            if (isSource.containsKey(c)) continue;
            pureTarget.add(c);
        }
        this.initDrag(originalAbs, pureSource, true, false);
        this.initDrag(originalAbs, pureTarget, false, true);
        this.initDrag(originalAbs, reflexive, true, true);
    }

    private void initDrag(Rectangle originalAbs, List<Connection> connections, boolean isSource, boolean isTarget) {
        for (Connection connection : connections) {
            ConnData cd = new ConnData(connection, isSource, isTarget);
            this.conn.put(connection, cd);
            MaxMoveDelta[] mmds = cd.getMaxMoveDeltas(originalAbs);
            int i = 0;
            while (i < this.mmds.length) {
                this.mmds[i].merge(mmds[i]);
                ++i;
            }
        }
    }

    public void updateBoxDrag(Rectangle newBoundsAbs) {
        double dx = newBoundsAbs.preciseX() - this.origDraggedBoundsAbs.preciseX();
        double dy = newBoundsAbs.preciseY() - this.origDraggedBoundsAbs.preciseY();
        double dw = newBoundsAbs.preciseWidth() - this.origDraggedBoundsAbs.preciseWidth();
        double dh = newBoundsAbs.preciseHeight() - this.origDraggedBoundsAbs.preciseHeight();
        if (dx == 0.0 && dy == 0.0 && dw == 0.0 && dh == 0.0) {
            for (ConnData cd : this.conn.values()) {
                this.forceInitialLocations(cd);
            }
            return;
        }
        for (ConnData cd : this.conn.values()) {
            Rectangle brel = this.origDraggedBoundsAbs.getCopy();
            cd.conn.translateToRelative((Translatable)brel);
            Rectangle bnrel = newBoundsAbs.getCopy();
            cd.conn.translateToRelative((Translatable)bnrel);
            double localDx = bnrel.preciseX() - brel.preciseX();
            double localDy = bnrel.preciseY() - brel.preciseY();
            double localDw = bnrel.preciseWidth() - brel.preciseWidth();
            double localDh = bnrel.preciseHeight() - brel.preciseHeight();
            IFigure targetOwner = cd.conn.getTargetAnchor().getOwner();
            Rectangle targetBox = this.getBounds(cd.conn, targetOwner);
            IFigure sourceOwner = cd.conn.getSourceAnchor().getOwner();
            boolean isSelfAssoc = targetOwner == sourceOwner;
            Rectangle sourceBox = isSelfAssoc ? targetBox : this.getBounds(cd.conn, sourceOwner);
            List<PrecisionPoint> pointsCopy = this.dragAnchoredSegments(cd, sourceBox, targetBox, localDx, localDy, localDw, localDh);
            List<RelativeBendpoint> constraint = this.createConstraint(cd.conn, pointsCopy);
            ConnectionRouter router = cd.conn.getConnectionRouter();
            router.setConstraint(cd.conn, constraint);
            router.route(cd.conn);
            List<PrecisionPoint> list = cd.getVisualPoints();
            if (!targetBox.contains(sourceBox)) {
                this.cutOffEnd(list, targetBox, isSelfAssoc);
            }
            if (!sourceBox.contains(targetBox)) {
                this.cutOffStart(list, sourceBox, isSelfAssoc);
            }
            this.cutOutLoops(list);
            List<RelativeBendpoint> updatedConstraint = this.createConstraint(cd.conn, list);
            router.setConstraint(cd.conn, updatedConstraint);
            router.route(cd.conn);
        }
    }
}

